/*
 * Decompiled with CFR 0.152.
 */
package de.his.tools;

import de.his.tools.StringUtil;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ParseSQL {
    private static Logger logger = Logger.getLogger(ParseSQL.class);

    private ParseSQL() {
    }

    public static String[] getDBColNames(String select, boolean convertToLowerCase) {
        return StringUtil.vectorToArray(ParseSQL.getColNames(select, true, convertToLowerCase));
    }

    public static String[] getDBColNames(String select) {
        return ParseSQL.getDBColNames(select, true);
    }

    public static String[] getDBColNameAliases(String select) {
        return StringUtil.vectorToArray(ParseSQL.getColNames(select, false, true));
    }

    static Vector<String> getColNames(String select, boolean dbNames, boolean convertToLowerCase) {
        Vector<String> colNames = new Vector<String>();
        if (select == null || select.trim().length() == 0) {
            return colNames;
        }
        String fieldlist = ParseSQL.normalizeSelect(select, false);
        String start = ParseSQL.getSelectStart(fieldlist);
        fieldlist = fieldlist.substring(start.length()).trim();
        fieldlist = ParseSQL.removeBracketContents(fieldlist);
        if ((fieldlist = ParseSQL.clipFromPart(fieldlist)).endsWith(";")) {
            fieldlist = fieldlist.substring(0, fieldlist.length() - 1).trim();
        }
        int ixRoundBrackets = 0;
        String expr = null;
        int ixExpr = 0;
        for (int ix = 0; ix < fieldlist.length() && fieldlist.length() > 0; ++ix) {
            if (fieldlist.substring(ix, ix + 1).equals("'")) {
                ++ix;
                while (ix < fieldlist.length() && !fieldlist.substring(ix, ix + 1).equals("'")) {
                    logger.debug((Object)("      " + ix + "\t" + fieldlist.substring(ix, ix + 1)));
                    ++ix;
                }
                if (ix < fieldlist.length() && fieldlist.substring(ix, ix + 1).equals("'")) {
                    ++ix;
                }
            }
            if (ix < fieldlist.length() && fieldlist.substring(ix, ix + 1).equals("(")) {
                ++ix;
                ++ixRoundBrackets;
            }
            if (ix < fieldlist.length() && fieldlist.substring(ix, ix + 1).equals(")")) {
                --ixRoundBrackets;
                ++ix;
            }
            if (ix >= fieldlist.length() || !fieldlist.substring(ix, ix + 1).equals(",") || ixRoundBrackets >= 1) continue;
            expr = fieldlist.substring(ixExpr, ix).trim();
            ParseSQL.addColumnName(dbNames, convertToLowerCase, colNames, expr);
            ixExpr = ix + 1;
        }
        if (ixExpr < fieldlist.length()) {
            expr = fieldlist.substring(ixExpr).trim();
            ParseSQL.addColumnName(dbNames, convertToLowerCase, colNames, expr);
        }
        return colNames;
    }

    private static String removeBracketContents(String fieldlist) {
        fieldlist = ParseSQL.removeLiteralContent(fieldlist);
        int bracketIx = fieldlist.indexOf("(");
        int startIx = 0;
        int stack = 0;
        StringBuffer strBuf = new StringBuffer();
        while (bracketIx - startIx > -1) {
            int ix;
            ++stack;
            strBuf.append(fieldlist.substring(startIx, bracketIx));
            for (ix = bracketIx + 1; ix < fieldlist.length() && stack > 0; ++ix) {
                if (fieldlist.substring(ix, ix + 1).equals("(")) {
                    ++stack;
                }
                if (!fieldlist.substring(ix, ix + 1).equals(")")) continue;
                --stack;
            }
            startIx = ix;
            bracketIx = startIx + fieldlist.substring(startIx).indexOf("(");
        }
        strBuf.append(fieldlist.substring(startIx));
        return strBuf.toString();
    }

    private static String removeLiterals(String fieldlist) {
        int apostrIx = fieldlist.indexOf("'");
        int startIx = 0;
        StringBuffer strBuf = new StringBuffer();
        while (apostrIx - startIx > -1) {
            int ix;
            strBuf.append(fieldlist.substring(startIx, apostrIx));
            for (ix = apostrIx + 1; ix < fieldlist.length() && !fieldlist.substring(ix, ix + 1).equals("'"); ++ix) {
            }
            startIx = ix + 1;
            apostrIx = startIx + fieldlist.substring(startIx).indexOf("'");
        }
        strBuf.append(fieldlist.substring(startIx));
        return strBuf.toString();
    }

    private static String removeLiteralContent(String str) {
        int apostrIx = str.indexOf("'");
        int startIx = 0;
        StringBuffer strBuf = new StringBuffer();
        while (apostrIx - startIx > -1) {
            int ix;
            strBuf.append(str.substring(startIx, apostrIx) + "''");
            for (ix = apostrIx + 1; ix < str.length() && !str.substring(ix, ix + 1).equals("'"); ++ix) {
            }
            startIx = ix + 1;
            if (startIx >= str.length()) continue;
            apostrIx = startIx + str.substring(startIx).indexOf("'");
        }
        if (startIx < str.length()) {
            strBuf.append(str.substring(startIx));
        }
        return strBuf.toString();
    }

    private static String clipFromPart(String fieldlist) {
        int ix = StringUtil.containsWord(fieldlist.toLowerCase(), "from");
        if (ix > -1) {
            fieldlist = fieldlist.substring(0, ix).trim();
        }
        return fieldlist;
    }

    private static void addColumnName(boolean dbNames, boolean convertToLowerCase, Vector<String> colNames, String expr) {
        String colStr = ParseSQL.processColExpression(expr, dbNames, convertToLowerCase);
        colStr = StringUtil.unquoteDoubles(colStr);
        colStr = ParseSQL.removeLiterals(colStr);
        colNames.addElement(colStr);
    }

    public static String getSelectStart(String select) {
        String fieldlist = null;
        int ix = (select = ParseSQL.normalizeSelect(select, false)).toUpperCase().indexOf("SELECT ");
        if (ix <= -1) {
            return "";
        }
        fieldlist = select.substring(ix + 7).trim();
        if (fieldlist.toUpperCase().startsWith("DISTINCT ")) {
            fieldlist = fieldlist.substring(9).trim();
        }
        if (fieldlist.toUpperCase().startsWith("UNIQUE ")) {
            fieldlist = fieldlist.substring(7).trim();
        }
        if ((ix = select.indexOf(fieldlist)) < 0) {
            ix = 0;
        }
        return select.substring(0, ix);
    }

    private static String processColExpression(String expr, boolean dbNames, boolean convertDBNamesToLowerCase) {
        String colName = ParseSQL.getColName(expr, dbNames).trim();
        if (dbNames && colName.length() == 0) {
            colName = ParseSQL.getColName(expr, !dbNames).trim();
        }
        if (dbNames && convertDBNamesToLowerCase) {
            colName = colName.toLowerCase();
        }
        return colName;
    }

    private static String getColName(String expr, boolean dbNames) {
        String colName = expr;
        int ix = StringUtil.containsWord(colName.toLowerCase(), "as");
        if (ix > -1) {
            if (dbNames) {
                if ((colName = colName.substring(0, ix).trim()).indexOf("'") > -1) {
                    colName = expr.substring(ix + 3).trim();
                }
            } else {
                colName = colName.substring(ix + 3).trim();
            }
        }
        return colName;
    }

    public static String normalizeSelect(String sql, boolean toLower) {
        String select = toLower ? sql.toLowerCase().trim() : sql.trim();
        select = select.replace('\t', ' ').replace('\n', ' ').replace('\r', ' ').replace(';', ' ').trim();
        return select;
    }
}

