/*
 * Decompiled with CFR 0.152.
 */
package de.his.tools;

import de.his.otherlicence.unicode.UnicodeSupportingInputStreamReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LoggingStreamReader
implements Runnable {
    private static Logger logger = Logger.getLogger(LoggingStreamReader.class);
    private final BufferedReader reader;
    private Level level = Level.DEBUG;

    public LoggingStreamReader(InputStream is) {
        this.reader = new BufferedReader(new UnicodeSupportingInputStreamReader(is));
    }

    public LoggingStreamReader(InputStream is, Level level) {
        this.reader = new BufferedReader(new UnicodeSupportingInputStreamReader(is));
        this.level = level;
    }

    @Override
    public void run() {
        try {
            String line = this.reader.readLine();
            while (line != null) {
                logger.log((Priority)this.level, (Object)line);
                line = this.reader.readLine();
            }
            this.reader.close();
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public void start() {
        Thread thread = new Thread((Runnable)this, "LoggingStreamReader");
        thread.setDaemon(true);
        thread.start();
    }
}

