/*
 * Decompiled with CFR 0.152.
 */
package de.his.tools;

import com.lambdaworks.crypto.SCryptUtil;
import de.his.otherlicence.jbcrypt.BCrypt;
import de.his.otherlicence.pbkdf2.PBKDF2;
import de.his.otherlicence.shacrypt.Sha256Crypt;
import de.his.otherlicence.shacrypt.Sha512Crypt;
import de.his.tools.MDFiveHash;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Locale;
import org.apache.log4j.Logger;

public class HashCryptUtil {
    private static Logger logger = Logger.getLogger(HashCryptUtil.class);

    public static String hashPasswordWithSalt(String algorithm, String password) {
        if (password != null) {
            if (password.length() > 1000) {
                throw new RuntimeException("Password too long");
            }
            try {
                String newpasswordHashWithSalt = null;
                if (algorithm == null || algorithm.equals("")) {
                    newpasswordHashWithSalt = Sha512Crypt.Sha512_crypt(password, null, 0);
                } else if (algorithm.equals("H")) {
                    newpasswordHashWithSalt = MDFiveHash.hashWithSalt(password);
                } else if (algorithm.equals("HB") || algorithm.startsWith("H2") || algorithm.startsWith("2")) {
                    newpasswordHashWithSalt = BCrypt.hashpw(password, BCrypt.gensalt());
                } else if (algorithm.equals("H5") || algorithm.startsWith("5")) {
                    newpasswordHashWithSalt = Sha256Crypt.Sha256_crypt(password, null, 0);
                } else if (algorithm.equals("H6") || algorithm.startsWith("6")) {
                    newpasswordHashWithSalt = Sha512Crypt.Sha512_crypt(password, null, 0);
                } else if (algorithm.toUpperCase(Locale.ENGLISH).startsWith("HS") || algorithm.toUpperCase(Locale.ENGLISH).startsWith("S")) {
                    newpasswordHashWithSalt = SCryptUtil.scrypt((String)password, (int)16384, (int)8, (int)1);
                } else if (algorithm.toUpperCase(Locale.ENGLISH).startsWith("HP") || algorithm.toUpperCase(Locale.ENGLISH).startsWith("P")) {
                    newpasswordHashWithSalt = PBKDF2.createHash(password);
                } else {
                    logger.error((Object)("Unsupported algorithm: " + algorithm));
                }
                return newpasswordHashWithSalt;
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)"Fehler bei der UTF-Codierung: ", (Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                logger.error((Object)"Fehler beim Hashen: ", (Throwable)e);
            }
            catch (InvalidKeySpecException e) {
                logger.error((Object)"Fehler beim Hashen: ", (Throwable)e);
            }
        }
        return null;
    }

    public static String hashPasswordWithSalt(String algorithm, String password, int length) {
        if (length > 0) {
            if (length < 40) {
                logger.error((Object)("Maximum allowed length " + length + " for the password storage (e. g. size of database column) is too small to store securely hashed passwords"));
                return null;
            }
            if (length < 150 && algorithm != null && !algorithm.equals("H")) {
                logger.error((Object)("Maximum allowed length " + length + " for the password storage (e. g. size of database column) is too small for the requested secure hashing algorithm " + algorithm + ". Using deprecated \"MD5 with Salt\" algorithm."));
                return HashCryptUtil.hashPasswordWithSalt("H", password);
            }
        }
        return HashCryptUtil.hashPasswordWithSalt(algorithm, password);
    }

    public static boolean verify(String password, String hash) {
        block11: {
            if (hash == null || hash.length() < 10) {
                return false;
            }
            if (password == null || password.length() > 1000) {
                return false;
            }
            if (hash.startsWith("$1") || hash.startsWith("$apr1$")) {
                return MDFiveHash.compareSaltedHash(hash, password);
            }
            if (hash.startsWith("$2")) {
                return BCrypt.checkpw(password, hash);
            }
            if (hash.startsWith("$5")) {
                return Sha256Crypt.verifyPassword(password, hash);
            }
            if (hash.startsWith("$6")) {
                return Sha512Crypt.verifyPassword(password, hash);
            }
            if (hash.toUpperCase(Locale.ENGLISH).startsWith("$S")) {
                return SCryptUtil.check((String)password, (String)hash);
            }
            if (hash.indexOf(58, hash.indexOf(58) + 1) > 10) {
                try {
                    return PBKDF2.validatePassword(password, hash);
                }
                catch (NoSuchAlgorithmException e) {
                    logger.error((Object)e, (Throwable)e);
                    break block11;
                }
                catch (InvalidKeySpecException e) {
                    logger.error((Object)e, (Throwable)e);
                    break block11;
                }
            }
            logger.error((Object)("Unknown hash algorithm: " + hash.substring(3)), new Throwable());
        }
        return false;
    }

    public static String discoverAlgorithm(String hash) {
        if (hash.startsWith("$1") || hash.startsWith("$apr1$")) {
            return "H";
        }
        if (hash.startsWith("$2")) {
            return "H2";
        }
        if (hash.startsWith("$5")) {
            return "H5";
        }
        if (hash.startsWith("$6")) {
            return "H6";
        }
        if (hash.toUpperCase(Locale.ENGLISH).startsWith("$S")) {
            return "HS";
        }
        if (hash.indexOf(58, hash.indexOf(58) + 1) > 10) {
            return "HP";
        }
        logger.error((Object)"Unknown hash algorithm (see debug messages for more information)", new Throwable());
        logger.debug((Object)("Unknown hash algorithm: " + hash), new Throwable());
        return "-";
    }
}

