/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.jersey;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.enunciate.modules.jersey.DelegatingJAXBContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
public class EnunciateJAXBContextResolver
implements ContextResolver<JAXBContext> {
    private static final Logger LOG = Logger.getLogger(EnunciateJAXBContextResolver.class.getName());
    private final JAXBContext context;
    private final Object prefixMapper;
    private final Set<Class> types = this.loadTypes();

    public EnunciateJAXBContextResolver() throws Exception {
        this.prefixMapper = this.loadPrefixMapper();
        JAXBContext context = JAXBContext.newInstance((Class[])this.types.toArray(new Class[this.types.size()]));
        if (this.prefixMapper != null) {
            context = new DelegatingJAXBContext(context){

                public Marshaller createMarshaller() throws JAXBException {
                    Marshaller marshaller = super.createMarshaller();
                    try {
                        marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", EnunciateJAXBContextResolver.this.prefixMapper);
                    }
                    catch (PropertyException propertyException) {
                        // empty catch block
                    }
                    return marshaller;
                }
            };
        }
        this.context = context;
    }

    public Set<Class> loadTypes() {
        HashSet<Class> types = new HashSet<Class>();
        InputStream stream = this.loadResource("/jaxrs-jaxb-types.list");
        if (stream != null) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "utf-8"));
                String line = reader.readLine();
                while (line != null) {
                    try {
                        types.add(this.loadClass(line));
                    }
                    catch (Throwable e) {
                        LOG.log(Level.SEVERE, "Error loading jaxb type for jersey.", e);
                    }
                    line = reader.readLine();
                }
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "Error reading jaxb types for jersey.", e);
            }
        }
        return types;
    }

    protected Object loadPrefixMapper() {
        InputStream stream = this.loadResource("/ns2prefix.properties");
        Object prefixMapper = null;
        if (stream != null) {
            try {
                Properties ns2prefix = new Properties();
                ns2prefix.load(stream);
                prefixMapper = Class.forName("org.codehaus.enunciate.modules.jersey.PrefixMapper").getConstructor(Properties.class).newInstance(ns2prefix);
            }
            catch (Throwable e) {
                prefixMapper = null;
            }
        }
        return prefixMapper;
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null) {
            cl = EnunciateJAXBContextResolver.class.getClassLoader();
        }
        return cl;
    }

    protected InputStream loadResource(String resource) {
        return EnunciateJAXBContextResolver.getDefaultClassLoader().getResourceAsStream(resource);
    }

    protected Class loadClass(String classname) throws ClassNotFoundException {
        return EnunciateJAXBContextResolver.getDefaultClassLoader().loadClass(classname);
    }

    public JAXBContext getContext(Class<?> objectType) {
        if (this.types.contains(objectType)) {
            return this.context;
        }
        if (objectType.isAnnotationPresent(XmlRootElement.class)) {
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{objectType});
                if (this.prefixMapper != null) {
                    context = new DelegatingJAXBContext(context){

                        public Marshaller createMarshaller() throws JAXBException {
                            Marshaller marshaller = super.createMarshaller();
                            try {
                                marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", EnunciateJAXBContextResolver.this.prefixMapper);
                            }
                            catch (PropertyException propertyException) {
                                // empty catch block
                            }
                            return marshaller;
                        }
                    };
                }
                return context;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

