/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.bytecode;

import java.io.IOException;
import org.codehaus.enunciate.bytecode.InstrumentationInfo;
import org.codehaus.enunciate.bytecode.WebParamAnnotationInstrumentation;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnunciateInstrumentedClassLoader
extends ClassLoader {
    private final InstrumentationInfo instrumentation;

    public EnunciateInstrumentedClassLoader(ClassLoader parent, InstrumentationInfo instrumentation) throws ClassNotFoundException {
        super(parent);
        this.instrumentation = instrumentation;
        for (String instrumentedClass : instrumentation.getInstrumentedClasses()) {
            this.findClass(instrumentedClass);
        }
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        ClassReader reader;
        ClassWriter writer = new ClassWriter(0);
        try {
            reader = new ClassReader(name);
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Unable to read class " + name + ".", e);
        }
        reader.accept((ClassVisitor)new WebParamAnnotationInstrumentation((ClassVisitor)writer, this.instrumentation), 0);
        byte[] bytes = writer.toByteArray();
        return this.defineClass(name, bytes, 0, bytes.length);
    }
}

