/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.util;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReflectionUtil {
    private static Log logCat = LogFactory.getLog((Class)(class$org$dbforms$util$ReflectionUtil == null ? (class$org$dbforms$util$ReflectionUtil = ReflectionUtil.class$("org.dbforms.util.ReflectionUtil")) : class$org$dbforms$util$ReflectionUtil));
    static /* synthetic */ Class class$org$dbforms$util$ReflectionUtil;

    public static Object invoke(String className, String methodName, Class[] argsTypes, Object[] args) throws Exception {
        Class<?> c = Class.forName(className);
        Method m = c.getDeclaredMethod(methodName, argsTypes);
        Object i = c.newInstance();
        Object r = m.invoke(i, args);
        return r;
    }

    public static Object newInstance(String className) throws Exception {
        Class<?> myClass = Class.forName(className);
        return myClass.newInstance();
    }

    public static Object newInstance(String className, Class[] constructorArgsTypes, Object[] constructorArgs) throws Exception {
        Class<?> myClass = Class.forName(className);
        return ReflectionUtil.newInstance(myClass, constructorArgsTypes, constructorArgs);
    }

    public static Object newInstance(Class clazz, Class[] constructorArgsTypes, Object[] constructorArgs) throws Exception {
        Constructor myConstructor = clazz.getConstructor(constructorArgsTypes);
        return myConstructor.newInstance(constructorArgs);
    }

    public static void reflectClass(String name, OutputStream os) {
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(os));
        ReflectionUtil.reflectClass(name, w);
    }

    public static void reflectClass(String name, Writer w) {
        Class<?> c = null;
        try {
            c = Class.forName(name);
            ReflectionUtil.reflectClass(c.newInstance(), false, w);
        }
        catch (Exception e) {
            logCat.error((Object)("Class " + name + " is not found."));
            return;
        }
    }

    public static void reflectObject(Object o, OutputStream os) {
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(os));
        ReflectionUtil.reflectClass(o, true, w);
    }

    public static void reflectObject(Object o, Writer w) {
        ReflectionUtil.reflectClass(o, true, w);
    }

    public static String toString(Object o) {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(new PrintWriter(sw));
        String s = null;
        ReflectionUtil.reflectObject(o, bw);
        s = sw.getBuffer().toString();
        try {
            sw.close();
        }
        catch (Exception e) {
            logCat.error((Object)"::toString - cannot close the writer object", (Throwable)e);
        }
        return s;
    }

    public static String toString(String c) {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(new PrintWriter(sw));
        String s = null;
        ReflectionUtil.reflectClass(c, bw);
        s = sw.getBuffer().toString();
        try {
            sw.close();
        }
        catch (Exception e) {
            logCat.error((Object)"::toString - cannot close the writer object", (Throwable)e);
        }
        return s;
    }

    private static String getTypeName(Class c) {
        if (c.isArray()) {
            try {
                Class<?> cl = c;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuffer sb = new StringBuffer();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable e) {
                logCat.error((Object)"::getTypeName - cannot get the class type", e);
            }
        }
        return c.getName();
    }

    private static void listClassConstructors(PrintWriter pw, Class c) {
        Constructor<?>[] constructors = c.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            if (i == 0) {
                pw.println("  // Constructors");
            }
            pw.print("  " + Modifier.toString(constructors[i].getModifiers()) + " " + constructors[i].getName() + "(");
            ReflectionUtil.listParameters(pw, constructors[i].getParameterTypes());
            pw.println(");");
        }
        if (constructors.length > 0) {
            pw.println();
        }
    }

    private static void listClassMethods(PrintWriter pw, Class c) {
        Method[] methods = c.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (i == 0) {
                pw.println("  // Methods");
            }
            pw.print("  " + Modifier.toString(methods[i].getModifiers()) + " " + ReflectionUtil.getTypeName(methods[i].getReturnType()) + " " + methods[i].getName() + "(");
            ReflectionUtil.listParameters(pw, methods[i].getParameterTypes());
            pw.println(");");
        }
    }

    private static void listClassVariables(PrintWriter pw, Object o, boolean dumpValues) throws Exception {
        if (o != null) {
            Class<?> c = o.getClass();
            Field[] fields = c.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (i == 0) {
                    pw.println("  // Variables");
                }
                pw.print("  " + Modifier.toString(fields[i].getModifiers()) + " " + ReflectionUtil.getTypeName(fields[i].getType()) + " " + fields[i].getName());
                if (dumpValues) {
                    Field f = fields[i];
                    String fValue = null;
                    if (f.isAccessible()) {
                        fValue = f.get(o).toString();
                    } else {
                        try {
                            f.setAccessible(true);
                            fValue = f.get(o).toString();
                            f.setAccessible(false);
                        }
                        catch (Exception e) {
                            fValue = "NOT ACCESSIBLE";
                        }
                    }
                    pw.print(" = [ " + fValue + " ]");
                }
                pw.println(";");
            }
            if (fields.length > 0) {
                pw.println();
            }
        }
    }

    private static void listParameters(PrintWriter pw, Class[] parameters) {
        for (int j = 0; j < parameters.length; ++j) {
            pw.print(ReflectionUtil.getTypeName(parameters[j]));
            if (j >= parameters.length - 1) continue;
            pw.print(", ");
        }
    }

    private static void reflectClass(Object o, boolean dumpValues, Writer w) {
        PrintWriter pw = new PrintWriter(w);
        Class<?> c = o.getClass();
        pw.println(Modifier.toString(c.getModifiers()) + " " + c.getName());
        if (c.getSuperclass() != null) {
            pw.print("  extends " + c.getSuperclass().getName());
        }
        Class<?>[] interfaces = c.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (i == 0) {
                pw.print(" implements ");
            } else {
                pw.print(", ");
            }
            pw.print(interfaces[i].getName());
        }
        pw.println("\n{");
        try {
            ReflectionUtil.listClassVariables(pw, o, dumpValues);
        }
        catch (Exception e) {
            logCat.error((Object)"::reflectClass - cannot list the class variables", (Throwable)e);
        }
        ReflectionUtil.listClassConstructors(pw, c);
        ReflectionUtil.listClassMethods(pw, c);
        pw.println("\n}");
        pw.flush();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

