/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.servlets;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.dbforms.servlets.reports.LineReportServletAbstract;

public class CSVReportServlet
extends LineReportServletAbstract {
    private static final char Q = '\"';
    private static final String DEFAULTMIMETYPE = "text/comma-separated-values;charset=ASCII";
    private PrintWriter pw;

    private String clean(String s) {
        s = s.replaceAll("\"", "\\\"");
        return s;
    }

    protected String getMimeType() {
        return DEFAULTMIMETYPE;
    }

    protected String getFileExtension() {
        return ".csv";
    }

    protected void openStream(OutputStream out) throws Exception {
        OutputStreamWriter osw;
        try {
            osw = new OutputStreamWriter(out, "UTF8");
        }
        catch (Exception e) {
            osw = new OutputStreamWriter(out);
        }
        this.pw = new PrintWriter(osw);
    }

    protected void closeStream(OutputStream out) throws Exception {
        this.pw.flush();
        this.pw.close();
    }

    protected void writeData(Object[] data) throws Exception {
        for (int i = 0; i < data.length; ++i) {
            if (i > 0) {
                this.pw.print(',');
            }
            if (data[i] != null) {
                this.pw.print('\"' + this.clean(data[i].toString()) + '\"');
                continue;
            }
            this.pw.print("\"\"");
        }
        this.pw.println();
    }
}

