/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.event.classic;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbEventInterceptorData;
import org.dbforms.config.DbFormsConfig;
import org.dbforms.config.DbFormsConfigRegistry;
import org.dbforms.config.Field;
import org.dbforms.config.FieldValue;
import org.dbforms.config.FieldValues;
import org.dbforms.config.JDBCDataHelper;
import org.dbforms.event.ValidationEvent;
import org.dbforms.util.FileHolder;
import org.dbforms.util.MessageResourcesInternal;
import org.dbforms.util.ParseUtil;
import org.dbforms.util.StringUtil;
import org.dbforms.util.UniqueIDGenerator;
import org.dbforms.util.Util;

public class UpdateEvent
extends ValidationEvent {
    static Log logCat = LogFactory.getLog((String)(class$org$dbforms$event$classic$UpdateEvent == null ? (class$org$dbforms$event$classic$UpdateEvent = UpdateEvent.class$("org.dbforms.event.classic.UpdateEvent")) : class$org$dbforms$event$classic$UpdateEvent).getName());
    static /* synthetic */ Class class$org$dbforms$event$classic$UpdateEvent;

    public UpdateEvent(Integer tableId, String keyId, HttpServletRequest request, DbFormsConfig config) {
        super(tableId, keyId, request, config);
    }

    public UpdateEvent(String action, HttpServletRequest request, DbFormsConfig config) {
        super(StringUtil.getEmbeddedStringAsInteger(action, 2, '_'), StringUtil.getEmbeddedString(action, 3, '_'), request, config);
    }

    public FieldValues getFieldValues() {
        String s = ParseUtil.getParameter(this.getRequest(), "overridefieldcheck_" + this.getTable().getId());
        boolean flag = "true".equalsIgnoreCase(s);
        return this.getFieldValues(flag);
    }

    public void processEvent(Connection con) throws SQLException {
        if (!this.hasUserPrivileg(2)) {
            String s = MessageResourcesInternal.getMessage("dbforms.events.update.nogrant", this.getRequest().getLocale(), new String[]{this.getTable().getName()});
            throw new SQLException(s);
        }
        FieldValues fieldValues = this.getFieldValues();
        if (fieldValues.size() == 0) {
            logCat.info((Object)"no parameters to update found");
            return;
        }
        String keyValuesStr = this.getKeyValues();
        if (Util.isNull(keyValuesStr)) {
            logCat.error((Object)"At least one key is required per table, check your dbforms-config.xml");
            return;
        }
        DbEventInterceptorData interceptorData = new DbEventInterceptorData(this.getRequest(), this.getConfig(), con, this.getTable());
        interceptorData.setAttribute("fieldValues", fieldValues);
        interceptorData.setAttribute("keyValues", keyValuesStr);
        int operation = this.getTable().processInterceptors(2, interceptorData);
        if (operation == 0 && fieldValues.size() > 0) {
            int fieldType;
            Field curField;
            PreparedStatement ps = con.prepareStatement(this.getTable().getUpdateStatement(fieldValues));
            Iterator iter = fieldValues.elements();
            int col = 1;
            while (iter.hasNext()) {
                FieldValue fv = (FieldValue)iter.next();
                if (fv == null) continue;
                curField = fv.getField();
                fieldType = curField.getType();
                Object value = null;
                if (fieldType == 2004) {
                    logCat.info((Object)("we are looking for fileholder with name: f_" + this.getTable().getId() + "_" + this.getKeyId() + "_" + curField.getId()));
                    value = fv.getFileHolder();
                    logCat.info((Object)("and found a value=" + value));
                } else if (fieldType == 4200) {
                    FileHolder fileHolder = fv.getFileHolder();
                    String fileName = fileHolder.getFileName();
                    if (curField.hasEncodedSet()) {
                        int dotIndex = fileName.lastIndexOf(46);
                        String suffix = dotIndex != -1 ? fileName.substring(dotIndex) : "";
                        fileHolder.setFileName(UniqueIDGenerator.getUniqueID() + suffix);
                        value = fileHolder.getFileName();
                    } else {
                        value = fileName;
                    }
                } else {
                    value = fv.getFieldValueAsObject();
                }
                JDBCDataHelper.fillWithData(ps, fv.getField().getEscaper(), col, value, fieldType, this.getTable().getBlobHandlingStrategy());
                ++col;
            }
            this.getTable().populateWhereClauseWithKeyFields(keyValuesStr, ps, col);
            ps.executeUpdate();
            ps.close();
            iter = fieldValues.keys();
            while (iter.hasNext()) {
                String fieldName = (String)iter.next();
                curField = this.getTable().getFieldByName(fieldName);
                if (curField == null) continue;
                fieldType = curField.getType();
                String directory = null;
                try {
                    directory = Util.replaceRealPath(curField.getDirectory(), DbFormsConfigRegistry.instance().lookup().getRealPath());
                }
                catch (Exception e) {
                    throw new SQLException(e.getMessage());
                }
                if (fieldType != 4200) continue;
                if (directory == null) {
                    throw new IllegalArgumentException("directory-attribute needed for fields of type DISKBLOB");
                }
                File dir = new File(directory);
                if (!dir.isDirectory()) {
                    throw new IllegalArgumentException("Not a directory: " + directory);
                }
                if (!dir.canWrite()) {
                    throw new IllegalArgumentException("Not writable: " + directory);
                }
                FileHolder fileHolder = ParseUtil.getFileHolder(this.getRequest(), "f_" + this.getTable().getId() + "_" + this.getKeyId() + "_" + curField.getId());
                if (fileHolder != null) {
                    try {
                        fileHolder.writeBufferToFile(dir);
                        logCat.info((Object)"fin + closedy");
                        continue;
                    }
                    catch (IOException ioe) {
                        throw new SQLException("could not store file '" + fileHolder.getFileName() + "' to dir '" + directory + "'");
                    }
                }
                logCat.info((Object)"uh! empty fileHolder");
            }
            this.getTable().processInterceptors(3, interceptorData);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

