/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor.wizard;

import de.destatis.core.connect.TransferProtocol;
import de.destatis.core.map.editor.MappingEditor;
import de.destatis.core.map.editor.wizard.AbstractStep;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PromtAuthenticationStep
extends AbstractStep {
    private static String userName = null;
    private static char[] password = null;
    private JTextField userNameTextField;
    private JPasswordField passwordField;

    public PromtAuthenticationStep() {
        super(new GridBagLayout());
        String url;
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                PromtAuthenticationStep.this.fireStateChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PromtAuthenticationStep.this.fireStateChanged();
            }
        };
        this.userNameTextField = new JTextField(userName);
        this.userNameTextField.getDocument().addDocumentListener(documentListener);
        this.passwordField = new JPasswordField(password != null ? new String(password) : null);
        this.passwordField.getDocument().addDocumentListener(documentListener);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        this.add((Component)new JLabel("CORE.server-URL:"), gbc);
        ++gbc.gridy;
        gbc.insets.top = 5;
        this.add((Component)new JLabel("Benutzername:"), gbc);
        ++gbc.gridy;
        this.add((Component)new JLabel("Passwort:"), gbc);
        ++gbc.gridx;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets.left = 5;
        gbc.insets.top = 0;
        gbc.fill = 2;
        try {
            url = MappingEditor.getCoreServerServerAddress().getURI(TransferProtocol.HTTPS).toString();
        }
        catch (Exception e) {
            url = MappingEditor.getCoreServerServerAddress().toString();
        }
        JLabel urlLabel = new JLabel(url);
        urlLabel.setFont(urlLabel.getFont().deriveFont(1));
        this.add((Component)urlLabel, gbc);
        ++gbc.gridy;
        gbc.insets.top = 5;
        this.add((Component)this.userNameTextField, gbc);
        ++gbc.gridy;
        this.add((Component)this.passwordField, gbc);
    }

    public String getUserName() {
        return this.userNameTextField.getText();
    }

    public char[] getPassword() {
        return this.passwordField.getPassword();
    }

    @Override
    public String getTitle() {
        return "Anmeldung";
    }

    @Override
    public String getInfo() {
        return "Geben Sie bitte Ihren Benutzernamen und das Passwort f\u00fcr den Zugriff auf den CORE.server ein.";
    }

    @Override
    public boolean isComplete() {
        return this.getUserName() != null && this.getUserName().length() > 0 && this.getPassword() != null && this.getPassword().length > 0;
    }

    @Override
    public void commit() {
        userName = this.getUserName();
        password = this.getPassword();
    }
}

