/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor.welcome;

import de.destatis.core.map.editor.MappingEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class WelcomePageTool
extends JPanel {
    private static final String HYPERLINK_ACTION_PERFORM_ACTION = "perform";
    private static final String HYPERLINK_PARAM_ACTION = "action";
    private static final String ACTIONID_NEW_MAPPING = "file.new.mapping";
    private static final String ACTIONID_NEW_META_MAPPING = "file.new.metamapping";
    private static final String ACTIONID_OPEN = "file.open";
    private MappingEditor mappingEditor;

    public WelcomePageTool(MappingEditor mappingEditor) {
        this.mappingEditor = mappingEditor;
        this.init();
    }

    public Component getGui() {
        return this;
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JEditorPane htmlView = new JEditorPane("text/html", "");
        htmlView.setEditable(false);
        htmlView.setMargin(null);
        htmlView.setFocusable(false);
        try {
            htmlView.setPage(this.getClass().getResource("html/welcome.html"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        htmlView.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String ref = e.getDescription();
                    WelcomePageTool.this.handleHyperlink(ref);
                }
            }
        });
        JScrollPane scrollPaneView = new JScrollPane(htmlView);
        scrollPaneView.setBorder(null);
        this.add((Component)scrollPaneView, "Center");
    }

    private void handleHyperlink(String hyperlinkRef) {
        String param;
        int questionMarkIndex;
        if (hyperlinkRef != null && hyperlinkRef.length() > 0 && hyperlinkRef.startsWith(HYPERLINK_ACTION_PERFORM_ACTION) && (questionMarkIndex = hyperlinkRef.indexOf(63)) != -1 && (param = hyperlinkRef.substring(questionMarkIndex + 1)).length() > 0 && param.matches("action=.+")) {
            String action = param.substring(HYPERLINK_PARAM_ACTION.length() + 1);
            if (ACTIONID_NEW_MAPPING.equals(action)) {
                this.mappingEditor.create();
            } else if (ACTIONID_NEW_META_MAPPING.equals(action)) {
                this.mappingEditor.createMetaDatenMapping();
            } else if (ACTIONID_OPEN.equals(action)) {
                this.mappingEditor.load();
            }
        }
    }
}

