/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor.util;

import de.destatis.core.map.FieldSetBinding;
import de.destatis.core.map.editor.util.CsvTableCreator;
import de.destatis.core.map.model.BindingHelper;
import de.destatis.core.map.model.MetaMapping;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class MetaMappingCsvTemplateCreator
extends CsvTableCreator {
    private MetaMapping metaMapping;
    private File file;

    public MetaMappingCsvTemplateCreator(MetaMapping metaMapping, File file, String encoding, char csvSeparator, char csvQuote) {
        super(encoding, csvSeparator, csvQuote);
        this.metaMapping = metaMapping;
        this.file = file;
    }

    @Override
    public void run() {
        try {
            this.createTemplate();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTemplate() throws IOException {
        FileOutputStream fOut = null;
        try {
            File directory = this.file.getParentFile();
            if (directory != null && !directory.isDirectory() && !directory.mkdirs()) {
                throw new IOException("Das Verzeichnis der Zieldatei existiert nicht und konnte nicht angelegt werden.");
            }
            fOut = new FileOutputStream(this.file);
            BufferedWriter writer = this.encoding != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)fOut, this.encoding)) : new BufferedWriter(new OutputStreamWriter(fOut));
            Object[] csvRecord = this.createRecord(this.metaMapping.getDocumentBinding());
            if (csvRecord != null) {
                this.writeCsvRecord(writer, csvRecord);
            }
            writer.newLine();
            csvRecord = this.createRecord(this.metaMapping.getMessageBinding());
            if (csvRecord != null) {
                this.writeCsvRecord(writer, csvRecord);
            }
            writer.close();
            fOut = null;
        }
        finally {
            if (fOut != null) {
                try {
                    fOut.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private Object[] createRecord(FieldSetBinding fieldSetBinding) {
        Object[] record = null;
        Integer lastCsvPosition = BindingHelper.getLastCalculatedCsvPosition(fieldSetBinding);
        if (lastCsvPosition != null) {
            record = new Object[lastCsvPosition.intValue()];
            this.fillForFieldSet(record, fieldSetBinding);
        }
        return record;
    }
}

