/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.connect.transfer.https;

import de.destatis.core.connect.DataDelivery;
import de.destatis.core.connect.Response;
import de.destatis.core.connect.ResponseStatus;
import de.destatis.core.connect.ResponseToDataDelivery;
import de.destatis.core.connect.document.DatMLResDocument;
import de.destatis.core.connect.document.DocumentSource;
import de.destatis.core.connect.document.ValidationException;
import de.destatis.core.connect.transfer.https.ConnectInputStreamBody;
import de.destatis.core.connect.transfer.https.HttpsRequestHandler;
import de.destatis.core.connect.util.ClientConfig;
import de.destatis.core.connect.util.ClientLogger;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.entity.mime.content.ContentBody;

public class HttpsDataDeliveryHandler
extends HttpsRequestHandler {
    private static final ClientLogger LOG = ClientLogger.getLogger(HttpsDataDeliveryHandler.class);

    public HttpsDataDeliveryHandler(DataDelivery request, ClientConfig config) {
        super(request, config);
    }

    @Override
    public String getActionValue() {
        return "send_delivery_connect";
    }

    @Override
    public void addParts(Map<String, ContentBody> partList) {
        InputStream bodyIn;
        LOG.debug("enter addParts()");
        boolean compression = false;
        DataDelivery delivery = (DataDelivery)this.getRequest();
        DocumentSource docSource = delivery.getData().getDocumentSource();
        String fileName = delivery.getFileName() == null ? "connect-datmlraw.xml" : delivery.getFileName();
        long length = docSource.getLength();
        LOG.trace("Anzahl zu sendender Bytes: " + length);
        if (!this.getConfig().isCompressionNone()) {
            LOG.trace("Das DatML/RAW-Dokument wird komprimiert uebertragen");
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            BufferedInputStream in = null;
            try {
                DeflaterOutputStream zipStream;
                in = new BufferedInputStream(docSource.getInputStream());
                if (this.getConfig().isCompressionGZIP()) {
                    LOG.trace("GZIP-Komprimierung");
                    zipStream = new GZIPOutputStream(outStream);
                } else {
                    LOG.trace("ZIP-Komprimierung");
                    zipStream = new DeflaterOutputStream(outStream);
                }
                compression = true;
                byte[] buffer = new byte[1024];
                int len = 0;
                while ((len = ((InputStream)in).read(buffer)) > 0) {
                    zipStream.write(buffer, 0, len);
                }
                zipStream.close();
                try {
                    ((InputStream)in).close();
                    in = null;
                }
                catch (IOException e) {
                    LOG.error("Fehler beim Schliessen des InputStreams der DocumentSource.", e);
                }
                byte[] zippedBytes = outStream.toByteArray();
                length = zippedBytes.length;
                LOG.trace("Laenge der komprimierten Daten: " + length);
                bodyIn = new BufferedInputStream(new ByteArrayInputStream(zippedBytes));
            }
            catch (IOException exc) {
                LOG.error("Fehler beim Erstellen des Deflater-Streams:", exc);
                throw new RuntimeException(exc);
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        LOG.trace("Keine komprimierte Uebertragung des DatML/RAW-Dokuments");
        bodyIn = docSource.getInputStream();
        LOG.trace("file=<DatML/RAW-Dokument>");
        String transferEncoding = null;
        if (compression) {
            if (this.getConfig().isCompressionZIP()) {
                LOG.trace("TransferEncoding auf deflate gesetzt");
                transferEncoding = "deflate";
            } else if (this.getConfig().isCompressionGZIP()) {
                LOG.trace("TransferEncoding auf gzip gesetzt");
                transferEncoding = "gzip";
            }
        }
        ConnectInputStreamBody filePart = new ConnectInputStreamBody(bodyIn, "text/xml; charset=" + docSource.getEncoding(), fileName, transferEncoding);
        partList.put("file", (ContentBody)filePart);
    }

    @Override
    public Response getResponse(HttpResponse httpResponse) {
        LOG.trace("enter getResponse()");
        ResponseToDataDelivery response = null;
        ResponseStatus responseStatus = this.getResponseStatus(httpResponse);
        if (responseStatus.equals(ResponseStatus.OK)) {
            String responseBody = this.getResponseBody(httpResponse);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Anfrage wurde fehlerfrei verarbeitet");
                LOG.trace("Zurueckgelieferter Inhalt:");
                LOG.trace(responseBody);
            }
            String transferTicket = null;
            Header transferTicketHeader = httpResponse.getFirstHeader("X-EntryStamp");
            if (transferTicketHeader != null) {
                transferTicket = transferTicketHeader.getValue();
            }
            if (transferTicket == null) {
                response = new ResponseToDataDelivery(ResponseStatus.BAD_RESPONSE, "Antwort vom Server enth\u00e4lt kein Transferticket.", null, null);
            }
            if (response == null) {
                DatMLResDocument document = null;
                if (responseBody != null && responseBody.length() > 0) {
                    document = new DatMLResDocument();
                    try {
                        document.setDocument(responseBody);
                    }
                    catch (ValidationException exc) {
                        LOG.error("Fehlerhaftes DatML/RES-Dokument geliefert bekommen", exc);
                        response = new ResponseToDataDelivery(ResponseStatus.BAD_RESPONSE, exc.getMessage(), transferTicket, null);
                    }
                }
                if (response == null) {
                    response = new ResponseToDataDelivery(responseStatus, null, transferTicket, document);
                }
            }
        } else if (responseStatus.equals(ResponseStatus.NO_VALID_XML)) {
            String responseBody = this.getResponseBody(httpResponse);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Anfrage wurde mit Status '" + ResponseStatus.NO_VALID_XML + "' verarbeitet");
                LOG.trace("Zurueckgelieferter Inhalt:");
                LOG.trace(responseBody);
            }
            DatMLResDocument document = null;
            if (responseBody != null && responseBody.length() > 0) {
                document = new DatMLResDocument();
                try {
                    document.setDocument(responseBody);
                }
                catch (ValidationException exc) {
                    LOG.error("Fehlerhaftes DatML/RES-Dokument geliefert bekommen", exc);
                    response = new ResponseToDataDelivery(ResponseStatus.BAD_RESPONSE, exc.getMessage(), null, null);
                }
            } else {
                response = new ResponseToDataDelivery(ResponseStatus.BAD_RESPONSE, "Antwort vom Server enth\u00e4lt kein Protokoll.", null, null);
            }
            if (response == null) {
                response = new ResponseToDataDelivery(responseStatus, responseStatus.getMessage(), null, document);
            }
        } else {
            String errorMsg = this.getResponseBody(httpResponse);
            response = new ResponseToDataDelivery(responseStatus, errorMsg, null, null);
        }
        return response;
    }
}

