/*
 * Decompiled with CFR 0.152.
 */
package com_cenqua_clover;

import com.atlassian.clover.CloverProperties;
import com.atlassian.clover.Environment;
import com.atlassian.clover.ErrorInfo;
import com.atlassian.clover.Logger;
import com.atlassian.clover.RecorderLogging;
import com.atlassian.clover.recorder.DelayedRecorder;
import com.atlassian.clover.recorder.FixedSizeCoverageRecorder;
import com.atlassian.clover.recorder.GrowableCoverageRecorder;
import com.atlassian.clover.recorder.NullRecorder;
import com.atlassian.clover.recorder.SharedCoverageRecorder;
import com.atlassian.clover.remote.DistributedClover;
import com.atlassian.clover.remote.RpcMessage;
import com_cenqua_clover.CloverProfile;
import com_cenqua_clover.CoverageRecorder;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public final class Clover {
    public static final int NO_SLICE = -1;
    public static final String SECURITY_EXCEPTION_MSG = "[CLOVER] FATAL ERROR: Clover could not be initialised because it has insufficient security privileges. Please consult the Clover documentation on the security policy file changes required.";
    private static volatile boolean initialisedOrInitialising = false;
    private static volatile Runtime runtime = new UninitialisedRuntime();

    private static synchronized Runtime ensureInitialised() {
        if (!initialisedOrInitialising) {
            initialisedOrInitialising = true;
            runtime = new InitialisedRuntime();
        }
        return runtime;
    }

    public static boolean isInitialised() {
        return runtime instanceof InitialisedRuntime;
    }

    private Clover() {
    }

    public static void globalFlush() {
        Clover.ensureInitialised().globalFlush();
    }

    public static int getCurrentSlice() {
        return Clover.ensureInitialised().getCurrentSlice();
    }

    public static String getCurrentType() {
        return Clover.ensureInitialised().getCurrentType();
    }

    public static long getCurrentSliceStart() {
        return Clover.ensureInitialised().getCurrentSliceStart();
    }

    public static int getCurrentTestRunID() {
        return Clover.ensureInitialised().getCurrentTestRunID();
    }

    public static CoverageRecorder getRecorder(String initChars, long dbVersion, long cfgbits, int maxNumElements, CloverProfile[] profiles, String[] nvpProperties) {
        return Clover.ensureInitialised().getRecorder(initChars, dbVersion, cfgbits, maxNumElements, profiles, nvpProperties);
    }

    public static int getTypeID(String runtimeType) {
        return Clover.ensureInitialised().getTypeID(runtimeType);
    }

    public static void resetRecorders() {
        Clover.ensureInitialised().resetRecorders();
    }

    public static boolean hasRecorded() {
        return Clover.ensureInitialised().hasRecorded();
    }

    public static void allRecordersFlush() {
        Clover.ensureInitialised().allRecordersFlush();
    }

    public static void allRecordersSliceStart(String type, int slice, long startTime) {
        Clover.ensureInitialised().allRecordersSliceStart(type, slice, startTime);
    }

    public static void allRecordersSliceEnd(String type, String method, String runtimeTestName, int slice, int p, ErrorInfo ei) {
        Clover.ensureInitialised().allRecordersSliceEnd(type, method, runtimeTestName, slice, p, ei);
    }

    public static CoverageRecorder createRecorder(String dbName, long dbVersion, long cfgbits, int maxNumElements, CloverProfile profile, CloverProperties properties) {
        return Clover.ensureInitialised().createRecorder(dbName, dbVersion, cfgbits, maxNumElements, profile, properties);
    }

    private static int abs(int value) {
        return value != Integer.MIN_VALUE ? Math.abs(value) : Integer.MAX_VALUE;
    }

    private static long abs(long value) {
        return value != Long.MIN_VALUE ? Math.abs(value) : Long.MAX_VALUE;
    }

    public static String getRecordingName(int hash, String dbname, long timestamp) {
        return dbname + Integer.toString(Clover.abs(hash), 36) + "_" + Long.toString(Clover.abs(timestamp), 36);
    }

    public static String getSliceRecordingName(int typeid, int methodID, int runID, int hash, String dbname, long timestamp) {
        long globalSliceID = (long)typeid << 32 | (long)methodID;
        return dbname + Long.toString(Clover.abs(globalSliceID), 36) + "_" + Integer.toString(Clover.abs(runID), 36) + "_" + Integer.toString(Clover.abs(hash), 36) + "_" + Long.toString(Clover.abs(timestamp), 36) + ".s";
    }

    public static void l(String m) {
        Clover.ensureInitialised().l(m);
    }

    public static void l(String m, Throwable t) {
        Clover.ensureInitialised().l(m, t);
    }

    public static ErrorInfo getErrorInfo(Throwable t) {
        return Clover.ensureInitialised().getErrorInfo(t);
    }

    public static CoverageRecorder getNullRecorder() {
        return NullRecorder.INSTANCE;
    }

    public static String stackTraceFor(Throwable throwable) {
        return Clover.ensureInitialised().stackTraceFor(throwable);
    }

    static File resolveRegistryFile(String dbName, CloverProperties properties) {
        try {
            String initStringProp = Environment.substituteSysPropRefs(properties.getProperty("clover.initstring"));
            if (initStringProp != null && initStringProp.length() > 0) {
                Logger.getInstance().verbose("overriding initstring: " + initStringProp);
                return new File(initStringProp);
            }
            String initStringBaseProp = Environment.substituteSysPropRefs(properties.getProperty("clover.initstring.basedir"));
            if (initStringBaseProp != null && initStringBaseProp.length() > 0) {
                Logger.getInstance().verbose("overriding initstring basedir: " + initStringBaseProp);
                File dbFile = new File(dbName);
                return new File(initStringBaseProp, dbFile.getName());
            }
            String initStringPrefixProp = Environment.substituteSysPropRefs(properties.getProperty("clover.initstring.prefix"));
            if (initStringPrefixProp != null && initStringPrefixProp.length() > 0) {
                Logger.getInstance().verbose("prepending initstring prefix: " + initStringPrefixProp);
                String newInit = initStringPrefixProp + dbName;
                if ((initStringPrefixProp.endsWith("/") || initStringPrefixProp.endsWith("\\")) && (dbName.startsWith("\\") || dbName.startsWith("/"))) {
                    newInit = initStringPrefixProp + dbName.substring(1);
                }
                return new File(newInit);
            }
        }
        catch (SecurityException e) {
            Logger.getInstance().verbose("Failed to retrieve Clover properties clover.initstring*", e);
        }
        return new File(dbName);
    }

    private static class InitialisedRuntime
    implements Runtime {
        private int currentSlice = -1;
        private long currentSliceStart = 0L;
        private String currentType;
        private int typeID;
        private int testRunID = 0;
        private Map<String, Integer> typeIDs;
        private final HashMap<String, CoverageRecorder> RECORDERS = new HashMap();
        private DistributedClover distributedRuntime = null;
        private volatile String cloverProfileName;

        public InitialisedRuntime() {
            RecorderLogging.init();
            this.typeID = Math.abs((int)(System.currentTimeMillis() + (long)Clover.class.hashCode()));
            this.typeIDs = Collections.synchronizedMap(new HashMap());
        }

        public void globalFlush() {
            this.allRecordersFlush();
        }

        public int getCurrentSlice() {
            return this.currentSlice;
        }

        public String getCurrentType() {
            return this.currentType;
        }

        public long getCurrentSliceStart() {
            return this.currentSliceStart;
        }

        public int getCurrentTestRunID() {
            return this.testRunID;
        }

        public CoverageRecorder getRecorder(final String initString, final long dbVersion, final long cfgbits, final int maxNumElements, final CloverProfile[] profiles, String ... nvpProperties) {
            final CloverProperties properties = new CloverProperties(nvpProperties);
            return AccessController.doPrivileged(new PrivilegedAction<CoverageRecorder>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public CoverageRecorder run() {
                    CloverProfile currentProfile = InitialisedRuntime.this.selectCloverProfile(profiles);
                    String recorderKey = currentProfile != null && currentProfile.getCoverageRecorder() == CloverProfile.CoverageRecorderType.SHARED ? initString + "_" + cfgbits : initString + "_" + dbVersion + "_" + cfgbits;
                    HashMap hashMap = InitialisedRuntime.this.RECORDERS;
                    synchronized (hashMap) {
                        CoverageRecorder recorder = (CoverageRecorder)InitialisedRuntime.this.RECORDERS.get(recorderKey);
                        if (recorder != null) {
                            Logger.getInstance().debug("[found existing recorder for " + recorderKey + "]");
                            recorder = recorder.withCapacityFor(maxNumElements);
                        } else {
                            if (Logger.isDebug()) {
                                Logger.getInstance().debug("Clover.getRecorder(" + String.valueOf(initString) + ", " + dbVersion + ", " + cfgbits + ", " + maxNumElements + ", " + properties + ") " + "resulting in new recorder called from (first 10 stack elements):\n" + InitialisedRuntime.this.callerChain(10));
                            }
                            Logger.getInstance().debug("[creating new recorder for " + recorderKey + "]");
                            recorder = InitialisedRuntime.this.createRecorder(initString, dbVersion, cfgbits, maxNumElements, currentProfile, properties);
                            recorder.startRun();
                        }
                        InitialisedRuntime.this.RECORDERS.put(recorderKey, recorder);
                        if (InitialisedRuntime.this.distributedRuntime == null) {
                            InitialisedRuntime.this.distributedRuntime = new DistributedClover(properties, currentProfile);
                        }
                        return recorder;
                    }
                }
            });
        }

        private String callerChain(int maxDepth) {
            LinkedList<StackTraceElement> elements = new LinkedList<StackTraceElement>(Arrays.asList(new Exception().getStackTrace()));
            elements.removeFirst();
            elements.removeFirst();
            StringBuffer buf = new StringBuffer();
            Iterator iterator = elements.iterator();
            int depth = 0;
            while (iterator.hasNext() && depth < maxDepth) {
                StackTraceElement element = (StackTraceElement)iterator.next();
                if (element.getClassName().startsWith("sun.reflect") || element.getClassName().startsWith("java.lang.reflect")) {
                    iterator.remove();
                    continue;
                }
                buf.append(element);
                buf.append("\n");
                ++depth;
            }
            return buf.toString();
        }

        public int getTypeID(String runtimeType) {
            int result;
            Integer val = this.typeIDs.get(runtimeType);
            if (val == null) {
                result = this.typeID++;
                this.typeIDs.put(runtimeType, new Integer(result));
            } else {
                result = val;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetRecorders() {
            HashMap<String, CoverageRecorder> hashMap = this.RECORDERS;
            synchronized (hashMap) {
                this.RECORDERS.clear();
            }
        }

        public boolean hasRecorded() {
            return this.RECORDERS.size() > 0;
        }

        public void allRecordersFlush() {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() {
                    HashMap hashMap = InitialisedRuntime.this.RECORDERS;
                    synchronized (hashMap) {
                        for (CoverageRecorder recorder : InitialisedRuntime.this.RECORDERS.values()) {
                            recorder.forceFlush();
                        }
                    }
                    return null;
                }
            });
        }

        public void allRecordersSliceStart(final String type, final int slice, final long startTime) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() {
                    HashMap hashMap = InitialisedRuntime.this.RECORDERS;
                    synchronized (hashMap) {
                        InitialisedRuntime.this.currentSlice = slice;
                        InitialisedRuntime.this.currentSliceStart = startTime > 0L ? startTime : System.currentTimeMillis();
                        InitialisedRuntime.this.currentType = type;
                        for (CoverageRecorder recorder : InitialisedRuntime.this.RECORDERS.values()) {
                            recorder.sliceStart(type, InitialisedRuntime.this.currentSliceStart, slice, InitialisedRuntime.this.testRunID);
                        }
                        if (InitialisedRuntime.this.distributedRuntime != null) {
                            InitialisedRuntime.this.distributedRuntime.remoteFlush(new RpcMessage(1, type, slice, InitialisedRuntime.this.currentSliceStart));
                        }
                    }
                    return null;
                }
            });
        }

        public void allRecordersSliceEnd(final String type, final String method, final @Nullable String runtimeTestName, final int slice, final int p, final ErrorInfo ei) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() {
                    HashMap hashMap = InitialisedRuntime.this.RECORDERS;
                    synchronized (hashMap) {
                        InitialisedRuntime.this.currentSlice = -1;
                        long ts = System.currentTimeMillis();
                        for (CoverageRecorder recorder : InitialisedRuntime.this.RECORDERS.values()) {
                            recorder.sliceEnd(type, method, runtimeTestName, ts, slice, InitialisedRuntime.this.testRunID, p, ei);
                        }
                        if (InitialisedRuntime.this.distributedRuntime != null) {
                            InitialisedRuntime.this.distributedRuntime.remoteFlush(new RpcMessage(2, type, method, runtimeTestName, slice, p, ei));
                        }
                        InitialisedRuntime.this.testRunID++;
                    }
                    return null;
                }
            });
        }

        public CoverageRecorder createRecorder(String dbName, long dbVersion, long cfgbits, int maxNumElements, CloverProfile currentProfile, CloverProperties properties) {
            block7: {
                File dbFile = Clover.resolveRegistryFile(dbName, properties);
                try {
                    if (this.isDisableClover()) {
                        Logger.getInstance().verbose("CLOVER: The system property 'clover.enable' is set to false. Coverage recording is disabled.");
                        return NullRecorder.INSTANCE;
                    }
                    if ((currentProfile == null || currentProfile.getCoverageRecorder() == CloverProfile.CoverageRecorderType.FIXED) && dbFile.exists() && !dbFile.isDirectory() && dbFile.canRead()) {
                        return FixedSizeCoverageRecorder.createFor(dbFile, dbVersion, maxNumElements, cfgbits);
                    }
                    if (currentProfile != null && currentProfile.getCoverageRecorder() == CloverProfile.CoverageRecorderType.GROWABLE) {
                        return GrowableCoverageRecorder.createFor(dbFile.getAbsolutePath(), dbVersion, cfgbits, maxNumElements);
                    }
                    if (currentProfile != null && currentProfile.getCoverageRecorder() == CloverProfile.CoverageRecorderType.SHARED) {
                        return SharedCoverageRecorder.createFor(dbFile.getAbsolutePath(), dbVersion, cfgbits, maxNumElements);
                    }
                    this.logRecorderCreationFailure(dbFile, null);
                }
                catch (SecurityException e) {
                    Logger.getInstance().warn(Clover.SECURITY_EXCEPTION_MSG);
                    this.logRecorderCreationFailure(dbFile, e);
                }
                catch (Throwable e) {
                    this.logRecorderCreationFailure(dbFile, e);
                    if (!(e instanceof Error)) break block7;
                    throw (Error)e;
                }
            }
            return NullRecorder.INSTANCE;
        }

        private boolean isDisableClover() {
            try {
                String cloverEnable = System.getProperty("clover.enable");
                return cloverEnable != null && (cloverEnable.equalsIgnoreCase("false") || cloverEnable.equalsIgnoreCase("no"));
            }
            catch (SecurityException ex) {
                Logger.getInstance().verbose("Unable to read 'clover.enable' property. Assuming that Clover is enabled.");
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CloverProfile selectCloverProfile(CloverProfile[] profiles) {
            if (profiles == null || profiles.length == 0) {
                Logger.getInstance().debug("CLOVER: No profiles defined in instrumented classes. Using standard settings.");
                return null;
            }
            if (this.cloverProfileName == null) {
                InitialisedRuntime initialisedRuntime = this;
                synchronized (initialisedRuntime) {
                    try {
                        this.cloverProfileName = System.getProperty("clover.profile");
                        if (this.cloverProfileName == null) {
                            Logger.getInstance().debug("CLOVER: System property 'clover.profile' was not found. Assuming the 'default' profile.");
                            this.cloverProfileName = "default";
                        }
                    }
                    catch (SecurityException ex) {
                        Logger.getInstance().verbose("CLOVER: Unable to read 'clover.profile' system property. Assuming the 'default' profile.", ex);
                        this.cloverProfileName = "default";
                    }
                }
            }
            for (CloverProfile profile : profiles) {
                if (!profile.getName().equals(this.cloverProfileName)) continue;
                Logger.getInstance().verbose("CLOVER: Using profile '" + this.cloverProfileName + "' with settings " + "[coverageRecorder=" + (Object)((Object)profile.getCoverageRecorder()) + (profile.getDistributedCoverage() != null ? " distributedCoverage=" + profile.getDistributedCoverage().getConfigString() : "") + "]");
                return profile;
            }
            Logger.getInstance().verbose("CLOVER: Profile '" + this.cloverProfileName + "' not found in instrumented classes. Using standard settings.");
            return null;
        }

        private void logRecorderCreationFailure(File dbFile, Throwable t) {
            Logger.getInstance().error("CLOVER: Unable to load the coverage database at \"" + dbFile.getAbsolutePath() + "\"");
            Logger.getInstance().error("CLOVER: No coverage data will be gathered.");
            if (t != null) {
                Logger.getInstance().error("CLOVER: " + t.getClass().getName());
                if (t.getMessage() != null) {
                    Logger.getInstance().error("CLOVER: " + t.getMessage(), t);
                }
            }
        }

        public void l(String m) {
            Logger.getInstance().error(m);
        }

        public void l(String m, Throwable t) {
            Logger.getInstance().error(m, t);
        }

        public ErrorInfo getErrorInfo(Throwable t) {
            return t == null ? null : new ErrorInfo(t.getMessage(), this.stackTraceFor(t));
        }

        public String stackTraceFor(Throwable throwable) {
            StringWriter sw = new StringWriter();
            throwable.printStackTrace(new PrintWriter(sw));
            return sw.toString();
        }
    }

    private static class UninitialisedRuntime
    implements Runtime {
        private UninitialisedRuntime() {
        }

        private void throwNotInitialisedException() {
            throw new IllegalStateException("Clover runtime not yet initialised.");
        }

        public void globalFlush() {
        }

        public boolean hasRecorded() {
            return false;
        }

        public void l(String m) {
        }

        public void l(String m, Throwable t) {
        }

        public CoverageRecorder getRecorder(String initString, long dbVersion, long cfgbits, int maxNumElements, CloverProfile[] profiles, String ... nvpProperties) {
            return new DelayedRecorder(initString, dbVersion, cfgbits, maxNumElements, profiles, nvpProperties);
        }

        public int getCurrentSlice() {
            this.throwNotInitialisedException();
            return 0;
        }

        public String getCurrentType() {
            this.throwNotInitialisedException();
            return null;
        }

        public long getCurrentSliceStart() {
            this.throwNotInitialisedException();
            return 0L;
        }

        public int getCurrentTestRunID() {
            this.throwNotInitialisedException();
            return 0;
        }

        public int getTypeID(String runtimeType) {
            this.throwNotInitialisedException();
            return 0;
        }

        public void resetRecorders() {
            this.throwNotInitialisedException();
        }

        public void allRecordersFlush() {
            this.throwNotInitialisedException();
        }

        public void allRecordersSliceStart(String type, int slice, long startTime) {
            this.throwNotInitialisedException();
        }

        public void allRecordersSliceEnd(String type, String method, String runtimeTestName, int slice, int p, ErrorInfo ei) {
            this.throwNotInitialisedException();
        }

        public CoverageRecorder createRecorder(String dbName, long dbVersion, long cfgbits, int maxNumElements, CloverProfile profile, CloverProperties properties) {
            this.throwNotInitialisedException();
            return null;
        }

        public ErrorInfo getErrorInfo(Throwable t) {
            this.throwNotInitialisedException();
            return null;
        }

        public String stackTraceFor(Throwable throwable) {
            this.throwNotInitialisedException();
            return null;
        }
    }

    private static interface Runtime {
        public void globalFlush();

        public int getCurrentSlice();

        public String getCurrentType();

        public long getCurrentSliceStart();

        public int getCurrentTestRunID();

        public CoverageRecorder getRecorder(String var1, long var2, long var4, int var6, CloverProfile[] var7, String ... var8);

        public int getTypeID(String var1);

        public void resetRecorders();

        public boolean hasRecorded();

        public void allRecordersFlush();

        public void allRecordersSliceStart(String var1, int var2, long var3);

        public void allRecordersSliceEnd(String var1, String var2, String var3, int var4, int var5, ErrorInfo var6);

        public CoverageRecorder createRecorder(String var1, long var2, long var4, int var6, CloverProfile var7, CloverProperties var8);

        public void l(String var1);

        public void l(String var1, Throwable var2);

        public ErrorInfo getErrorInfo(Throwable var1);

        public String stackTraceFor(Throwable var1);
    }
}

