/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.entities;

import com.atlassian.clover.recorder.PerTestRecordingTranscript;
import com.atlassian.clover.registry.entities.FullClassInfo;
import com.atlassian.clover.registry.entities.FullMethodInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.entities.StackTraceInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class TestCaseInfo
implements Serializable {
    static final long serialVersionUID = 0L;
    public static final int DEFAULT_SLICE_ID_OFFSET = 0;
    private transient WeakReference<FullMethodInfo> sourceMethod;
    private transient WeakReference<FullClassInfo> runtimeType;
    private transient Integer id;
    private String runtimeTypeName;
    private String sourceMethodName;
    private boolean hasResult = false;
    private long startTime;
    private long endTime;
    private float time = -1.0f;
    private boolean error;
    private boolean failure;
    private String failMessage;
    private String failType;
    private String failFullMessage;
    private String staticTestName;
    @Nullable
    private String runtimeTestName;
    private Integer hashCode = null;
    private transient StackTraceInfo stackTrace;

    private TestCaseInfo(long startTime, long endTime, String runtimeTypeName, String sourceMethodName, @Nullable String runtimeTestName) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.runtimeTypeName = runtimeTypeName;
        this.sourceMethodName = sourceMethodName;
        this.runtimeType = new WeakReference<Object>(null);
        this.sourceMethod = new WeakReference<Object>(null);
        this.runtimeTestName = runtimeTestName;
    }

    public TestCaseInfo(Integer id, FullClassInfo runtimeType, FullMethodInfo sourceMethod, @Nullable String runtimeTestName) {
        this.id = id;
        this.runtimeType = new WeakReference<FullClassInfo>(runtimeType);
        this.sourceMethod = new WeakReference<FullMethodInfo>(sourceMethod);
        this.staticTestName = sourceMethod != null ? (sourceMethod.getStaticTestName() != null ? sourceMethod.getStaticTestName() : sourceMethod.getSimpleName()) : null;
        this.runtimeTestName = runtimeTestName;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public boolean isResolved() {
        return this.getRuntimeType() != null && this.getSourceMethod() != null;
    }

    public boolean resolve(FullProjectInfo project) {
        String rtClassname = this.runtimeTypeName.replaceAll("\\.[0-9]+", "");
        FullClassInfo runtimeType = (FullClassInfo)project.findClass(rtClassname);
        this.runtimeType = new WeakReference<FullClassInfo>(runtimeType);
        int lastDot = this.sourceMethodName.lastIndexOf(".");
        if (lastDot > 0 && lastDot < this.sourceMethodName.length()) {
            String srcClassname = this.sourceMethodName.substring(0, lastDot);
            FullClassInfo srcClass = rtClassname.equals(srcClassname) ? runtimeType : (FullClassInfo)project.findClass(srcClassname);
            FullMethodInfo testMethodFound = null;
            if (srcClass != null) {
                testMethodFound = srcClass.getTestMethodDeclaration(this.sourceMethodName.substring(lastDot + 1));
                this.sourceMethod = new WeakReference<FullMethodInfo>(testMethodFound);
            }
            String string = this.staticTestName = testMethodFound != null && testMethodFound.getStaticTestName() != null ? testMethodFound.getStaticTestName() : this.sourceMethodName.substring(lastDot + 1);
            if (runtimeType != null) {
                runtimeType.addTestCase(this);
            }
            if (this.stackTrace != null) {
                this.stackTrace.resolve(project);
            }
        }
        return this.isResolved();
    }

    public Object readResolve() throws ObjectStreamException {
        TestCaseInfo info = Factory.getInstance(this);
        StackTraceInfo strace = info.getStackTrace();
        if (strace != null) {
            strace.setOriginatingTest(info);
        }
        return info;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.failFullMessage != null) {
            this.stackTrace = new StackTraceInfo(this, this.failFullMessage);
        }
    }

    public String getKey() {
        return TestCaseInfo.makeKey(this.runtimeTypeName, this.sourceMethodName, this.startTime);
    }

    public static String makeKey(String runtimeTypeName, String sourceMethodName, long startTime) {
        return runtimeTypeName + "/" + sourceMethodName + "/" + startTime;
    }

    public String getClassName() {
        FullClassInfo runtimeType = (FullClassInfo)this.runtimeType.get();
        return runtimeType == null ? null : runtimeType.getName();
    }

    public String getTestName() {
        return this.runtimeTestName != null ? this.runtimeTestName : this.staticTestName;
    }

    public float getTime() {
        return this.startTime == 0L ? this.time : (float)(this.endTime - this.startTime) / 1000.0f;
    }

    public boolean isError() {
        return this.hasResult && this.error;
    }

    public boolean isHasResult() {
        return this.hasResult;
    }

    public void setHasResult(boolean hasResult) {
        this.hasResult = hasResult;
    }

    public void setTime(float time) {
        this.time = time;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public boolean isFailure() {
        return this.hasResult && this.failure;
    }

    public void setFailure(boolean failure) {
        this.failure = failure;
    }

    public boolean isSuccess() {
        return this.hasResult && !this.isFailure() && !this.isError();
    }

    public String getFailMessage() {
        return this.failMessage;
    }

    public void setFailMessage(String failMessage) {
        this.failMessage = failMessage;
    }

    public String getFailType() {
        return this.failType;
    }

    public void setFailType(String failType) {
        this.failType = failType;
    }

    public String getFailFullMessage() {
        return this.failFullMessage;
    }

    public void setFailFullMessage(String failFullMessage) {
        this.failFullMessage = failFullMessage;
        if (failFullMessage != null) {
            this.stackTrace = new StackTraceInfo(this, failFullMessage);
        }
    }

    @Nullable
    public StackTraceInfo getStackTrace() {
        return this.stackTrace;
    }

    @Nullable
    public FullClassInfo getRuntimeType() {
        return this.runtimeType == null ? null : (FullClassInfo)this.runtimeType.get();
    }

    @Nullable
    public FullMethodInfo getSourceMethod() {
        return this.sourceMethod == null ? null : (FullMethodInfo)this.sourceMethod.get();
    }

    @Nullable
    public String getQualifiedName() {
        FullClassInfo runtimeType = this.getRuntimeType();
        return runtimeType == null ? null : runtimeType.getQualifiedName() + "." + this.getTestName();
    }

    @Nullable
    public String getRuntimeTypeName() {
        return this.runtimeTypeName;
    }

    @Nullable
    public String getSourceMethodName() {
        return this.sourceMethodName;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestCaseInfo that = (TestCaseInfo)o;
        if (this.endTime != that.endTime) {
            return false;
        }
        if (this.error != that.error) {
            return false;
        }
        if (this.failure != that.failure) {
            return false;
        }
        if (this.hasResult != that.hasResult) {
            return false;
        }
        if (this.startTime != that.startTime) {
            return false;
        }
        if (this.failFullMessage != null ? !this.failFullMessage.equals(that.failFullMessage) : that.failFullMessage != null) {
            return false;
        }
        if (this.failMessage != null ? !this.failMessage.equals(that.failMessage) : that.failMessage != null) {
            return false;
        }
        if (this.failType != null ? !this.failType.equals(that.failType) : that.failType != null) {
            return false;
        }
        if (this.runtimeTypeName != null ? !this.runtimeTypeName.equals(that.runtimeTypeName) : that.runtimeTypeName != null) {
            return false;
        }
        if (this.sourceMethodName != null ? !this.sourceMethodName.equals(that.sourceMethodName) : that.sourceMethodName != null) {
            return false;
        }
        if (this.staticTestName != null ? !this.staticTestName.equals(that.staticTestName) : that.staticTestName != null) {
            return false;
        }
        return !(this.runtimeTestName != null ? !this.runtimeTestName.equals(that.runtimeTestName) : that.runtimeTestName != null);
    }

    public int hashCode() {
        if (this.hashCode == null) {
            int result = this.runtimeTypeName != null ? this.runtimeTypeName.hashCode() : 0;
            result = 31 * result + (this.sourceMethodName != null ? this.sourceMethodName.hashCode() : 0);
            result = 31 * result + (this.hasResult ? 1 : 0);
            result = 31 * result + (int)(this.startTime ^ this.startTime >>> 32);
            result = 31 * result + (int)(this.endTime ^ this.endTime >>> 32);
            result = 31 * result + (this.error ? 1 : 0);
            result = 31 * result + (this.failure ? 1 : 0);
            result = 31 * result + (this.failMessage != null ? this.failMessage.hashCode() : 0);
            result = 31 * result + (this.failType != null ? this.failType.hashCode() : 0);
            result = 31 * result + (this.failFullMessage != null ? this.failFullMessage.hashCode() : 0);
            result = 31 * result + (this.staticTestName != null ? this.staticTestName.hashCode() : 0);
            result = 31 * result + (this.runtimeTestName != null ? this.runtimeTestName.hashCode() : 0);
            this.hashCode = new Integer(result);
        }
        return this.hashCode;
    }

    public String toString() {
        return "TestCaseInfo[id=" + this.id + ", runtimeTypeName='" + this.runtimeType + '\'' + ", staticTestName='" + this.staticTestName + '\'' + ", runtimeTestName='" + this.runtimeTestName + '\'' + ", sourceMethodName='" + this.sourceMethodName + '\'' + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", pass=" + !this.failure + ']';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory {
        private static Map<String, TestCaseInfo> instanceCache = new HashMap<String, TestCaseInfo>();
        private static int sliceOffset = 0;

        public static void reset() {
            instanceCache.clear();
            sliceOffset = 0;
        }

        public static TestCaseInfo getInstance(TestCaseInfo tci) {
            TestCaseInfo result = instanceCache.get(tci.getKey());
            if (result == null) {
                result = tci;
                tci.setId(new Integer(sliceOffset++));
                instanceCache.put(tci.getKey(), tci);
            }
            return result;
        }

        public static TestCaseInfo getInstanceForSlice(PerTestRecordingTranscript recording) {
            TestCaseInfo tci = new TestCaseInfo(recording.getStart(), recording.getEnd(), recording.getTestTypeName(), recording.getTestMethodName(), recording.getRuntimeTestName());
            TestCaseInfo result = instanceCache.get(tci.getKey());
            if (result == null) {
                result = tci;
                String stackTrace = recording.getStackTrace();
                String exitMessage = recording.getExitMessage();
                tci.setHasResult(recording.hasResult());
                if (recording.hasResult()) {
                    tci.setError(!recording.isResultPassed() && stackTrace == null);
                    tci.setFailure(!recording.isResultPassed() && stackTrace != null);
                    tci.setFailMessage(exitMessage);
                    tci.setFailFullMessage(stackTrace);
                }
                tci.setId(new Integer(sliceOffset++));
                instanceCache.put(tci.getKey(), tci);
            }
            return result;
        }

        public static Set<TestCaseInfo> getCacheValues() {
            return new HashSet<TestCaseInfo>(instanceCache.values());
        }
    }
}

