/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.baseobjects.coll.NamedIdObjectWithParentSet;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.memtext.tree.TreeBuilder;
import de.memtext.util.DateUtils;
import de.memtext.util.EqualsUtil;
import de.superx.common.AbstractSicht;
import de.superx.common.SelectableItem;
import de.superx.common.SelectableItemNode;
import de.superx.common.SelectableItemTree;
import de.superx.common.SxResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FieldElementCache {
    private HashMap map = new HashMap();

    FieldElementCache() {
    }

    public void init() {
        this.map.clear();
    }

    public boolean isSichtCachingWanted(String quelle) {
        if (quelle.length() > 7 && quelle.substring(0, 7).equals("<<SQL>>")) {
            quelle = quelle.substring(7);
        }
        return quelle.indexOf("<<") == -1;
    }

    public String generateSQL(String sql, String dialect) {
        if ((sql = AbstractSicht.getStrippedSQL(sql)).toString().startsWith("sp_")) {
            sql = dialect.equals("Postgres") ? "select " + sql : "execute procedure " + sql;
        }
        return sql;
    }

    public void addSicht(String mandantenID, String name_intern, SxResultSet items, boolean isOrganigramm) throws NoMainEntryException, KeyParentEqualException, SQLException {
        NamedIdObjectWithParentSet selectableItemCollection = new NamedIdObjectWithParentSet();
        selectableItemCollection.clear();
        if (items.size() > 0) {
            try {
                selectableItemCollection.addAll(SelectableItem.toSelectableItemCollection(items, isOrganigramm));
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new SQLException("Sicht " + name_intern + " konnte nicht aufgebaut werden.\n" + e2);
            }
        }
        Logger.getLogger("superx_" + mandantenID).log(Level.FINER, " Datenbank lieferte f\u00fcr Sicht:  " + name_intern + items.size() + " Eintr\u00e4ge " + DateUtils.getNowString());
        if (EqualsUtil.areEqual(Logger.getLogger("superx_" + mandantenID).getLevel(), Level.FINEST)) {
            Logger.getLogger("superx_" + mandantenID).log(Level.FINEST, selectableItemCollection.toString());
        }
        HashMap childrensMap = new HashMap();
        for (SelectableItem item : selectableItemCollection) {
            SelectableItemNode n;
            TreeBuilder.add(childrensMap, n, (n = new SelectableItemNode(item)).getParentKey() == null ? "" : n.getParentKey());
        }
        SelectableItemNode root = SelectableItemTree.getARootNode();
        TreeBuilder.addNodesToRootFromMap(root, "", childrensMap, null);
        this.map.put("sicht_" + name_intern, root);
        this.map.put("sicht_coll" + name_intern, selectableItemCollection);
    }

    public void add(String sql, SxResultSet rs) {
        this.map.put(sql, rs);
    }

    public boolean containsEntry(String entry) {
        return this.map.containsKey(entry);
    }

    public Collection getSichtColl(String entry) {
        return (Collection)this.map.get(entry);
    }

    public SelectableItemNode getSichtRoot(String entry) {
        SelectableItemNode r = (SelectableItemNode)this.map.get(entry);
        return r;
    }

    public SxResultSet get(String fieldsql) {
        SxResultSet r = (SxResultSet)this.map.get(fieldsql);
        return r;
    }
}

