/*
 * Decompiled with CFR 0.152.
 */
package de.superx.dbadmin;

import de.memtext.tree.AutoScrollJTree;
import de.superx.dbadmin.SxThemenEintrag2;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class ThemenDragTree
extends AutoScrollJTree
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    private DragSource dragSource = new DragSource(){

        protected DragSourceContext createDragSourceContext(DragSourceContextPeer dscp, DragGestureEvent dgl, Cursor dragCursor, Image dragImage, Point imageOffset, Transferable t, DragSourceListener dsl) {
            return new DragSourceContext(dscp, dgl, dragCursor, dragImage, imageOffset, t, dsl){

                @Override
                protected void updateCurrentCursor(int dropOp, int targetAct, int status) {
                }
            };
        }
    };
    private DragSourceContext dragSourceContext = null;
    private DropTarget dropTarget;
    int maxtid = 0;
    int actions;

    public ThemenDragTree(String actionstr) {
        this.actions = actionstr.equals("copy_move") ? 3 : 1;
        DragGestureRecognizer dgr = this.dragSource.createDefaultDragGestureRecognizer(this, this.actions, this);
        dgr.setSourceActions(dgr.getSourceActions() & 0xFFFFFFFB);
        this.dropTarget = new DropTarget(this, this.actions, this);
    }

    private void setNoDropCursor() {
        if (this.dragSourceContext != null) {
            this.dragSourceContext.setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    private void setCursor(DragSourceDragEvent e2) {
        this.dragSourceContext = e2.getDragSourceContext();
        this.dragSourceContext.setCursor(this.selectCursor(e2.getDropAction()));
    }

    private Cursor selectCursor(int action) {
        return action == 2 ? DragSource.DefaultMoveDrop : DragSource.DefaultCopyDrop;
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e2) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent e2) {
        this.setCursor(e2);
    }

    @Override
    public void dragEnter(DropTargetDragEvent e2) {
    }

    @Override
    public void dragExit(DragSourceEvent e2) {
    }

    @Override
    public void dragExit(DropTargetEvent e2) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e2) {
        TreePath path = this.getLeadSelectionPath();
        DefaultMutableTreeNode was = (DefaultMutableTreeNode)path.getLastPathComponent();
        Transferable tr = (Transferable)was.getUserObject();
        Cursor cursor = this.selectCursor(e2.getDragAction());
        this.dragSource.startDrag(e2, cursor, tr, this);
    }

    @Override
    public void dragOver(DragSourceDragEvent e2) {
        this.setCursor(e2);
    }

    @Override
    public void dragOver(DropTargetDragEvent e2) {
        Point cursorLocationBis = e2.getLocation();
        TreePath destinationPath = this.getPathForLocation(cursorLocationBis.x, cursorLocationBis.y);
        if (destinationPath == null) {
            e2.rejectDrag();
            this.setNoDropCursor();
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)destinationPath.getLastPathComponent();
        Object userobj = node.getUserObject();
        if (userobj instanceof SxThemenEintrag2) {
            SxThemenEintrag2 x = (SxThemenEintrag2)userobj;
            if (x.isKnoten()) {
                e2.acceptDrag(this.actions);
            } else {
                e2.rejectDrag();
                this.setNoDropCursor();
            }
        } else {
            this.setNoDropCursor();
            e2.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e2) {
        this.setCursor(e2);
    }

    @Override
    public void drop(DropTargetDropEvent e2) {
        DefaultMutableTreeNode oldParent = null;
        DefaultMutableTreeNode newParent = null;
        try {
            TreePath selectedNodePath = this.getLeadSelectionPath();
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)selectedNodePath.getLastPathComponent();
            Point loc = e2.getLocation();
            TreePath destinationPath = this.getPathForLocation(loc.x, loc.y);
            newParent = (DefaultMutableTreeNode)destinationPath.getLastPathComponent();
            SxThemenEintrag2 xnewparent = (SxThemenEintrag2)newParent.getUserObject();
            DefaultMutableTreeNode newChild = null;
            if (e2.getDropAction() == 1) {
                newChild = this.nodeCopy(selectedNode, xnewparent.getTid());
            } else {
                newChild = selectedNode;
                oldParent = (DefaultMutableTreeNode)selectedNode.getParent();
                oldParent.remove(newChild);
                SxThemenEintrag2 x = (SxThemenEintrag2)newChild.getUserObject();
                x.setParent(xnewparent.getTid());
            }
            newParent.add(newChild);
            if (e2.getDropAction() == 1) {
                e2.acceptDrop(1);
            } else {
                e2.acceptDrop(2);
            }
            e2.getDropTargetContext().dropComplete(true);
            ((DefaultTreeModel)this.getModel()).reload(oldParent);
            ((DefaultTreeModel)this.getModel()).reload(newParent);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.validate();
        this.repaint();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e2) {
    }

    private void parentEintragAnpassen(DefaultMutableTreeNode node) {
        SxThemenEintrag2 x = (SxThemenEintrag2)node.getUserObject();
        Enumeration<TreeNode> en = node.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)en.nextElement();
            if (aNode == node) continue;
            SxThemenEintrag2 x2 = (SxThemenEintrag2)aNode.getUserObject();
            x2.setParent(x.getTid());
        }
    }

    public int getMaxTid() {
        return this.maxtid;
    }

    public void setMaxTid(int neu) {
        this.maxtid = neu;
    }

    public void incMaxTid() {
        ++this.maxtid;
    }

    private DefaultMutableTreeNode nodeCopy(DefaultMutableTreeNode org, Integer parent) {
        SxThemenEintrag2 x = (SxThemenEintrag2)org.getUserObject();
        SxThemenEintrag2 xneu = (SxThemenEintrag2)x.clone();
        int newtid = this.getMaxTid() + 1;
        xneu.setTid(new Integer(newtid));
        this.setMaxTid(newtid);
        xneu.setParent(parent);
        DefaultMutableTreeNode neu = new DefaultMutableTreeNode(xneu);
        Enumeration<TreeNode> en = org.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)en.nextElement();
            if (aNode == org) continue;
            DefaultMutableTreeNode weitererKnoten = this.nodeCopy(aNode, new Integer(newtid));
            neu.add(weitererKnoten);
        }
        return neu;
    }
}

