/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.tree.HideableNodesTreeModel;
import de.memtext.util.EqualsUtil;
import de.memtext.util.StringUtils;
import de.superx.common.SelectableItem;
import de.superx.common.SelectableItemNode;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SelectableItemTree
extends JTree {
    private static final long serialVersionUID = 1L;
    public static final int PREORDER_ENUM = 1;
    public static final int BREADTHFIRST_ENUM = 2;
    public static final int DEPTHFIRST_ENUM = 3;

    public SelectableItemTree() {
        HideableNodesTreeModel model = new HideableNodesTreeModel(SelectableItemTree.getARootNode());
        model.setFilterActive(true);
        this.setModel(model);
    }

    public static SelectableItemNode getARootNode() {
        SelectableItem item = new SelectableItem("xxxxxx-xxxxxx@", "alles");
        item.setLehre(true);
        item.setAllowed(false);
        return new SelectableItemNode(item);
    }

    public void add(SelectableItemNode itemnode) {
        ((SelectableItemNode)this.getModel().getRoot()).add(itemnode);
    }

    public boolean containsItemWithId(String selectedKey) {
        boolean result = false;
        Enumeration<TreeNode> en = ((SelectableItemNode)this.getModel().getRoot()).breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode node = (SelectableItemNode)en.nextElement();
            if (node.getId() == null) {
                if (selectedKey != null) continue;
                result = true;
                continue;
            }
            if (!node.getId().toString().equals(selectedKey)) continue;
            result = true;
        }
        return result;
    }

    public String getAllKeys() {
        StringBuffer result = new StringBuffer();
        Enumeration<TreeNode> en = ((SelectableItemNode)this.getModel().getRoot()).breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode node = (SelectableItemNode)en.nextElement();
            if (node.getId() == null || node.getId().equals("") || node.getId().toString().equals("xxxxxx-xxxxxx@")) continue;
            if (node.getId() instanceof String) {
                result.append("'" + node.getId() + "',");
                continue;
            }
            result.append(node.getId() + ",");
        }
        StringUtils.removeLastChar(result);
        return result.toString();
    }

    public SelectableItemNode getById(String selectedKey) {
        SelectableItemNode result = null;
        Enumeration<TreeNode> en = ((SelectableItemNode)this.getModel().getRoot()).breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode node = (SelectableItemNode)en.nextElement();
            if (node.getId() == null) {
                if (selectedKey != null) continue;
                result = node;
                break;
            }
            if (!node.getId().toString().equals(selectedKey)) continue;
            result = node;
            break;
        }
        return result;
    }

    public String getSuitingKeyString(String muster) {
        StringBuffer result = new StringBuffer();
        muster = StringUtils.replace(muster, "*", ".*");
        boolean isFirst = true;
        Enumeration<TreeNode> en = ((SelectableItemNode)this.getModel().getRoot()).breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode node = (SelectableItemNode)en.nextElement();
            if (node.isTemporary() || node.getId() == null || !node.getId().toString().matches(muster)) continue;
            if (!isFirst) {
                result.append("|");
            } else {
                isFirst = false;
            }
            result.append(node.getId().toString());
        }
        return result.toString();
    }

    public void removeTempElements() {
        LinkedList<SelectableItemNode> tempNodes = new LinkedList<SelectableItemNode>();
        Enumeration<TreeNode> en = ((SelectableItemNode)this.getModel().getRoot()).breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode node = (SelectableItemNode)en.nextElement();
            if (!node.isTemporary()) continue;
            tempNodes.add(node);
        }
        for (SelectableItemNode tempNode : tempNodes) {
            tempNode.removeFromParent();
        }
    }

    public SelectableItemNode getRoot() {
        return (SelectableItemNode)this.getModel().getRoot();
    }

    public Object clone() throws CloneNotSupportedException {
        SelectableItemTree cl = new SelectableItemTree();
        SelectableItemTree.cloneNodes((SelectableItemNode)this.getModel().getRoot(), (SelectableItemNode)cl.getModel().getRoot());
        return cl;
    }

    public static void cloneNodes(SelectableItemNode sourceN, SelectableItemNode targetN) {
        Enumeration<TreeNode> en = sourceN.children();
        while (en.hasMoreElements()) {
            SelectableItemNode aChild = (SelectableItemNode)en.nextElement();
            SelectableItemNode cl = (SelectableItemNode)aChild.clone();
            targetN.add(cl);
            SelectableItemTree.cloneNodes(aChild, cl);
        }
    }

    public Collection getElements(int enumType) {
        LinkedList<SelectableItemNode> result = new LinkedList<SelectableItemNode>();
        SelectableItemNode startNode = (SelectableItemNode)this.getModel().getRoot();
        if (this.getSelectionCount() > 0) {
            startNode = (SelectableItemNode)this.getSelectionPath().getLastPathComponent();
        }
        Enumeration<TreeNode> en = null;
        if (enumType < 1 || enumType > 3) {
            throw new IllegalArgumentException("Ung\u00fcltiger Enumtype");
        }
        if (enumType == 1) {
            en = startNode.preorderEnumeration();
        }
        if (enumType == 2) {
            en = startNode.breadthFirstEnumeration();
        }
        if (enumType == 3) {
            en = startNode.depthFirstEnumeration();
        }
        while (en.hasMoreElements()) {
            SelectableItemNode node = (SelectableItemNode)en.nextElement();
            result.add(node);
        }
        return result;
    }

    public void setSelectedKey(String selectedKey) {
        this.clearSelection();
        Enumeration<TreeNode> en = ((SelectableItemNode)this.getModel().getRoot()).preorderEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode node = (SelectableItemNode)en.nextElement();
            if (!EqualsUtil.areEqual((String)node.getId(), selectedKey)) continue;
            this.setSelectionPath(new TreePath(node.getPath()));
            break;
        }
        if (this.getSelectionCount() == 0) {
            throw new IllegalArgumentException("Kein Knoten mit key " + selectedKey + " gefunden");
        }
    }

    public void setSelectedKeys(String keys) throws IllegalArgumentException {
        if (keys == null || keys.indexOf("|") == -1) {
            throw new IllegalArgumentException("Mehrere keys mit | getrennt erwartet, nicht " + keys);
        }
        this.clearSelection();
        StringTokenizer st = new StringTokenizer(keys, "|");
        while (st.hasMoreTokens()) {
            String key = st.nextToken();
            boolean isOk = false;
            Enumeration<TreeNode> en = ((SelectableItemNode)this.getModel().getRoot()).preorderEnumeration();
            while (en.hasMoreElements()) {
                SelectableItemNode node = (SelectableItemNode)en.nextElement();
                if (!EqualsUtil.areEqual((String)node.getId(), key)) continue;
                isOk = true;
                this.addSelectionPath(new TreePath(node.getPath()));
                break;
            }
            if (isOk) continue;
            throw new IllegalArgumentException("Kein Knoten mit key " + key + " gefunden");
        }
    }

    public Collection getSelectedItems() {
        LinkedList<Object> list = new LinkedList<Object>();
        int i2 = 0;
        while (i2 < this.getSelectionCount()) {
            list.add(this.getSelectionPaths()[i2].getLastPathComponent());
            ++i2;
        }
        return list;
    }

    public Collection getSelectedItemsSortByKey() {
        TreeSet ts = new TreeSet(new ItemComparator(){

            public int compare(Object o1, Object o2) {
                String key1 = ((SelectableItemNode)o1).getKey().toString();
                String key2 = ((SelectableItemNode)o2).getKey().toString();
                return key1.compareTo(key2);
            }
        });
        ts.addAll(this.getSelectedItems());
        return ts;
    }

    public Collection getSelectedItemsSortByName() {
        TreeSet ts = new TreeSet(new ItemComparator(){

            public int compare(Object o1, Object o2) {
                String name1 = ((SelectableItemNode)o1).getName();
                String name2 = ((SelectableItemNode)o2).getName();
                int pos = name1.substring(0, Math.min(name1.length(), 15)).indexOf("-");
                if (pos > -1) {
                    name1 = name1.substring(pos + 1);
                }
                if ((pos = name2.substring(0, Math.min(name2.length(), 15)).indexOf("-")) > -1) {
                    name2 = name2.substring(pos + 1);
                }
                return name1.compareTo(name2);
            }
        });
        ts.addAll(this.getSelectedItems());
        return ts;
    }

    public Collection getSelectedItemsSortByStrukturInt() {
        TreeSet ts = new TreeSet(new ItemComparator(){

            public int compare(Object o1, Object o2) {
                Integer i1 = ((SelectableItemNode)o1).getStrukturInt();
                Integer i2 = ((SelectableItemNode)o2).getStrukturInt();
                int result = 0;
                if (i1 != null && i2 != null) {
                    result = i1.compareTo(i2);
                }
                return result;
            }
        });
        ts.addAll(this.getSelectedItems());
        return ts;
    }

    public Collection getSelectedItemsSortByStrukturStr() {
        TreeSet ts = new TreeSet(new ItemComparator(){

            public int compare(Object o1, Object o2) {
                String s1 = ((SelectableItemNode)o1).getStrukturStr();
                String s2 = ((SelectableItemNode)o2).getStrukturStr();
                int result = 0;
                if (s1 != null && s2 != null) {
                    result = s1.compareTo(s2);
                }
                return result;
            }
        });
        ts.addAll(this.getSelectedItems());
        return ts;
    }

    public String getLongDebugString() {
        StringBuffer result = new StringBuffer();
        Enumeration<TreeNode> en = ((SelectableItemNode)this.getModel().getRoot()).breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode node = (SelectableItemNode)en.nextElement();
            int i2 = 0;
            while (i2 < node.getLevel()) {
                result.append(" ");
                ++i2;
            }
            result.append(node.getId() + "\n");
        }
        return result.toString();
    }

    public String getDebugString() {
        StringBuffer result = new StringBuffer();
        Enumeration<TreeNode> en = ((SelectableItemNode)this.getModel().getRoot()).breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode node = (SelectableItemNode)en.nextElement();
            result.append("Level" + node.getLevel() + ": " + node.getId() + " -");
        }
        return result.toString();
    }

    private abstract class ItemComparator
    implements Comparator {
        private ItemComparator() {
        }

        @Override
        public boolean equals(Object o) {
            return this == o;
        }
    }
}

