/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.DateUtils;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;

public class DialectCreator {
    private static String path;
    private static String sourceFileName;
    private static String source;
    protected static Configuration cfg;
    private static Template template;

    static {
        cfg = new Configuration();
    }

    public static void main(String[] args) {
        DialectCreator.checkArgs(args);
        try {
            cfg.setDirectoryForTemplateLoading(new File(path));
            template = cfg.getTemplate(sourceFileName);
            DialectCreator.translate("Informix", "_ids");
            DialectCreator.translate("Postgres", "_pg");
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private static void checkArgs(String[] args) {
        if (args.length != 2) {
            System.out.println("Error: use: DialectCreator path sourcefilename");
            System.exit(1);
        }
        path = args[0];
        sourceFileName = args[1];
        File f2 = new File(String.valueOf(path) + File.separator + sourceFileName);
        if (!f2.exists() || !f2.canRead()) {
            System.out.println("Error: can't read source file " + args[1]);
            System.exit(1);
        }
    }

    private static void translatePostgres() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("SQLdialect", "Postgres");
    }

    private static void translate(String dialect, String fileAppendix) throws TemplateException, IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("SQLdialect", dialect);
        map.put("current", String.valueOf(DateUtils.getTodayString()) + " um " + DateUtils.getNowString());
        String fname = String.valueOf(sourceFileName.substring(0, sourceFileName.length() - 4)) + fileAppendix + ".sql";
        FileWriter out = new FileWriter(String.valueOf(path) + File.separator + fname);
        template.process(map, (Writer)out);
        ((Writer)out).close();
        System.out.println("  " + dialect + " variant created:" + fname);
    }
}

