/*
 * Decompiled with CFR 0.152.
 */
package de.superx.applet;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class SxLogoPanel
extends JPanel {
    SxLogoPanel SxThis = this;
    Vector images;
    ImageIcon image;
    ImageIcon bg;
    Color bg_color;
    int count;
    int steps;
    int aktImage;
    int imageX;
    int imageY;
    int imageW;
    int imageH;
    int delay;
    animationThread animation = null;
    boolean running;
    boolean stopping;

    public SxLogoPanel(ImageIcon logo, int[] pixels, int steps, int delay) {
        super(true);
        this.steps = steps;
        this.delay = delay;
        this.bg_color = this.getBackground();
        this.images = new Vector();
        this.imageW = logo.getIconWidth();
        this.imageH = logo.getIconHeight();
        this.imageX = 5;
        this.imageY = 5;
        this.aktImage = this.steps / 2;
        this.running = false;
        this.stopping = false;
        if (pixels == null) {
            this.steps = 0;
            this.images.insertElementAt(logo, 0);
            this.aktImage = 0;
            this.count = 1;
        } else {
            this.setImages(pixels);
        }
    }

    public void start() {
        this.running = true;
        this.stopping = false;
        this.animation = new animationThread(this.delay);
        this.animation.start();
    }

    public void stop() {
        this.stopping = true;
    }

    public void setImages(int[] pixels) {
        Image[] imagearray = null;
        Image[] imagearray2 = null;
        int[] tpixelarray = null;
        Object pg = null;
        if (pixels == null) {
            return;
        }
        tpixelarray = pixels;
        double phi = 0.0;
        double phistep = Math.PI / (double)this.steps;
        int turnw = this.imageW;
        int turnh = this.imageH;
        imagearray = new Image[this.steps];
        imagearray2 = new Image[this.steps];
        int[][] rpixelarray = new int[this.steps][turnw * turnh];
        int[][] helpimagearray = new int[this.steps][turnw * turnh];
        int c2 = 0;
        while (c2 < this.steps) {
            int b2;
            double m = Math.sin(phi);
            int a2 = 0;
            while (a2 < turnw * turnh) {
                rpixelarray[c2][a2] = 0;
                ++a2;
            }
            a2 = 0;
            while (a2 < turnh) {
                b2 = turnw / 2;
                while (b2 >= 0) {
                    rpixelarray[c2][(int)Math.abs((double)((double)(a2 * turnw + turnw / 2) - m * (double)b2))] = tpixelarray[a2 * turnw + turnw / 2 - b2];
                    --b2;
                }
                ++a2;
            }
            a2 = 0;
            while (a2 < turnh) {
                b2 = 0;
                while (b2 < turnw / 2) {
                    rpixelarray[c2][(int)Math.abs((double)((double)(a2 * turnw + turnw / 2) + m * (double)b2))] = tpixelarray[a2 * turnw + turnw / 2 + b2];
                    ++b2;
                }
                ++a2;
            }
            imagearray[c2] = this.createImage(new MemoryImageSource(turnw, turnh, rpixelarray[c2], 0, turnw));
            a2 = 0;
            while (a2 < turnh) {
                b2 = 0;
                while (b2 < turnw) {
                    helpimagearray[c2][a2 * turnw + b2] = rpixelarray[c2][a2 * turnw + turnw - b2 - 1];
                    ++b2;
                }
                ++a2;
            }
            imagearray2[c2] = this.createImage(new MemoryImageSource(turnw, turnh, helpimagearray[c2], 0, turnw));
            if ((phi += phistep) > Math.PI) {
                phi %= Math.PI;
            }
            ++c2;
        }
        this.count = 0;
        int i2 = 0;
        while (i2 < this.steps) {
            this.images.insertElementAt(new ImageIcon(imagearray[i2]), this.count);
            ++this.count;
            ++i2;
        }
        i2 = 0;
        while (i2 < this.steps) {
            this.images.insertElementAt(new ImageIcon(imagearray2[i2]), this.count);
            ++this.count;
            ++i2;
        }
        int[] bg_pixels = new int[this.imageW * this.imageH];
        int bg_colorint = this.bg_color.getRGB();
        int i3 = 0;
        while (i3 < this.imageW * this.imageH) {
            bg_pixels[i3] = bg_colorint;
            ++i3;
        }
        Image bg_img = this.createImage(new MemoryImageSource(this.imageW, this.imageH, bg_pixels, 0, this.imageW));
        this.bg = new ImageIcon(bg_img);
        bg_pixels = null;
        rpixelarray = null;
        helpimagearray = null;
        imagearray = null;
        imagearray2 = null;
        System.gc();
    }

    @Override
    public void paint(Graphics g2) {
        if (this.images.size() > 0) {
            if (this.aktImage > this.count - 1) {
                this.aktImage = 0;
            }
            this.image = (ImageIcon)this.images.elementAt(this.aktImage);
            if (this.image != null) {
                g2.drawImage(this.image.getImage(), this.imageX, this.imageY, this.bg_color, this);
            }
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.imageW + this.imageX, this.imageH + this.imageY);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(this.imageW + this.imageX, this.imageH + this.imageY);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.imageW + this.imageX, this.imageH + this.imageY);
    }

    class animationThread
    extends Thread {
        public animationThread(int d2) {
            SxLogoPanel.this.delay = d2;
            this.setPriority(1);
        }

        @Override
        public void run() {
            while (SxLogoPanel.this.running) {
                SxLogoPanel.this.SxThis.paint(SxLogoPanel.this.SxThis.getGraphics());
                try {
                    if (SxLogoPanel.this.stopping && SxLogoPanel.this.aktImage == SxLogoPanel.this.steps / 2) {
                        throw new InterruptedException("Stopping");
                    }
                    ++SxLogoPanel.this.aktImage;
                    animationThread.sleep(SxLogoPanel.this.delay);
                }
                catch (InterruptedException ie) {
                    SxLogoPanel.this.animation = null;
                    SxLogoPanel.this.running = false;
                    SxLogoPanel.this.aktImage = SxLogoPanel.this.steps / 2;
                }
            }
        }
    }
}

