/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.util;

import de.memtext.util.ExceptionHandler;
import de.memtext.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class XMLUtils {
    private static ExceptionHandler exceptionHandler = new ExceptionHandler();
    private static DocumentBuilder builder = null;
    private static Document document = null;
    private static DocumentBuilderFactory factory;

    private XMLUtils() {
    }

    private static void init() {
        if (factory == null) {
            factory = DocumentBuilderFactory.newInstance();
            try {
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e2) {
                XMLUtils.handle(e2);
            }
            builder.setErrorHandler(new DTDErrorHandler());
        }
    }

    public static Document buildDocument(File f2) {
        return XMLUtils.buildDocument(f2, false);
    }

    public static Document buildDocument(File file, boolean isValidating) {
        XMLUtils.init();
        factory.setValidating(isValidating);
        Document document = null;
        try {
            if (!file.canRead()) {
                throw new IOException("can't read file " + file.getAbsolutePath());
            }
            document = builder.parse(file);
        }
        catch (Throwable e2) {
            XMLUtils.handle(e2);
        }
        return document;
    }

    public static Document buildDocument(InputStream in, boolean isValidating) {
        XMLUtils.init();
        factory.setValidating(isValidating);
        try {
            document = builder.parse(in);
        }
        catch (Throwable e2) {
            XMLUtils.handle(e2);
        }
        return document;
    }

    public static Document buildDocumentFromString(String input, boolean isValidating) {
        XMLUtils.init();
        factory.setValidating(isValidating);
        InputSource is = new InputSource(new StringReader(input));
        try {
            document = builder.parse(is);
        }
        catch (Throwable e2) {
            XMLUtils.handle(e2);
        }
        return document;
    }

    public static Document buildDocumentFromString2(String input, boolean isValidating) throws Exception {
        XMLUtils.init();
        factory.setValidating(isValidating);
        InputSource is = new InputSource(new StringReader(input));
        document = builder.parse(is);
        return document;
    }

    public static Document buildDocumentFromXmlUrl(String url, boolean isValidating) {
        XMLUtils.init();
        factory.setValidating(isValidating);
        try {
            document = builder.parse(url);
        }
        catch (Throwable e2) {
            XMLUtils.handle(e2);
        }
        return document;
    }

    public static boolean hasAttrib(Node node, String attribname) {
        if (node == null) {
            throw new IllegalArgumentException("node is null - can't check");
        }
        if (attribname == null) {
            throw new IllegalArgumentException("attribname is null - can't check");
        }
        NamedNodeMap map = node.getAttributes();
        boolean result = false;
        if (map != null && map.getNamedItem(attribname) != null) {
            result = true;
        }
        return result;
    }

    public static String getAttribValue(Node node, String attribname) {
        return XMLUtils.getNamedItemValueFromAttribs(node, attribname);
    }

    public static void setAttribValue(Node node, String name, String value) {
        Element e2 = (Element)node;
        e2.setAttribute(name, value);
    }

    public static String getTheValue(Node node) {
        String result = "";
        if (node == null) {
            throw new IllegalArgumentException("Node is null can't get value");
        }
        Node n = node.getFirstChild();
        if (n == null) {
            throw new IllegalArgumentException("Node " + node + " can't get value - no child node found");
        }
        if (n.getNodeType() == 3) {
            result = n.getNodeValue();
        }
        if (n.getNodeType() == 4) {
            CharacterData txt = (CharacterData)n;
            result = txt.getData();
        }
        return result;
    }

    public static String getChildNodeValues(Node node) {
        String result = "";
        if (node == null) {
            throw new IllegalArgumentException("Node is null can't get value");
        }
        NodeList mynodes = node.getChildNodes();
        int anz = mynodes.getLength();
        int i2 = 0;
        while (i2 <= anz) {
            Node child = mynodes.item(i2);
            if (child != null) {
                if (child.getNodeType() == 3) {
                    result = String.valueOf(result) + child.getNodeValue();
                }
                if (child.getNodeType() == 4) {
                    CharacterData txt = (CharacterData)child;
                    result = String.valueOf(result) + txt.getData();
                }
            }
            ++i2;
        }
        return result;
    }

    public static boolean hasValue(Node node) {
        Node firstChildNode;
        boolean result = false;
        if (node == null) {
            throw new IllegalArgumentException("Node is null can't check");
        }
        if (node.hasChildNodes() && ((firstChildNode = node.getFirstChild()).getNodeType() == 3 || firstChildNode.getNodeType() == 4)) {
            result = true;
        }
        return result;
    }

    public static Iterator getChildNodeIterator(Node aNode) {
        LinkedList<Node> result = new LinkedList<Node>();
        NodeList rawList = aNode.getChildNodes();
        int i2 = 0;
        while (i2 < rawList.getLength()) {
            Node n = rawList.item(i2);
            if (n.getNodeType() != 3 && n.getNodeType() != 8) {
                result.add(n);
            }
            ++i2;
        }
        return result.iterator();
    }

    public static String getChildNodeValue(Node node, String name) {
        String result = null;
        Node childnode = XMLUtils.getChildNode(node, name);
        if (childnode.hasChildNodes()) {
            result = childnode.getFirstChild().getNodeValue();
        }
        return result;
    }

    public static int getNodeCount(Document document, String name) {
        NodeList list = document.getElementsByTagName(name);
        return list.getLength();
    }

    public static Node getFirstNode(Document document, String name) {
        if (XMLUtils.getNodeCount(document, name) == 0) {
            throw new IllegalArgumentException("No node with name:" + name + " found");
        }
        NodeList list = document.getElementsByTagName(name);
        return list.item(0);
    }

    public static String getFirstNodeValue(Document document, String nodename) {
        Node node = XMLUtils.getFirstNode(document, nodename);
        return XMLUtils.getTheValue(node);
    }

    public static Node getFirstNodeWithNameAndAttrib(Document d2, String nodename, String attribname, String attribvalue) {
        Node result = null;
        NodeList list = document.getElementsByTagName(nodename);
        int i2 = 0;
        while (i2 < list.getLength()) {
            Node n = list.item(0);
            if (XMLUtils.hasAttrib(n, attribname) && XMLUtils.getAttribValue(n, attribname).equals(attribvalue)) {
                result = n;
                break;
            }
            ++i2;
        }
        return result;
    }

    public static boolean hasANodeWithName(Document document, String name) {
        return XMLUtils.getNodeCount(document, name) > 0;
    }

    public static boolean hasChildNode(Node node, String name) {
        NodeList nl = node.getChildNodes();
        int i2 = 0;
        while (i2 < nl.getLength()) {
            Node n = nl.item(i2);
            if (n.getNodeName().equals(name)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public static Node getChildNode(Node node, String name) {
        NodeList nl = node.getChildNodes();
        Node childnode = null;
        int i2 = 0;
        while (i2 < nl.getLength()) {
            Node n = nl.item(i2);
            if (n.getNodeName().equals(name)) {
                childnode = n;
            }
            ++i2;
        }
        if (childnode == null) {
            throw new IllegalArgumentException("Node " + node + " doesn't have a child " + name);
        }
        return childnode;
    }

    public static List getListWithValuesOfNodes(Node node, String childnodename) {
        LinkedList<String> result = new LinkedList<String>();
        NodeList nl = node.getChildNodes();
        int i2 = 0;
        while (i2 < nl.getLength()) {
            Node aNode = nl.item(i2);
            if (aNode.getNodeName().equals(childnodename)) {
                result.add(aNode.getFirstChild().getNodeValue());
            }
            ++i2;
        }
        return result;
    }

    public static List getListWithAttribOfNodes(Node parentNode, String acceptedChildNodeName, String attribName) {
        LinkedList<String> result = new LinkedList<String>();
        NodeList nl = parentNode.getChildNodes();
        int i2 = 0;
        while (i2 < nl.getLength()) {
            Node aNode = nl.item(i2);
            if (aNode.getNodeName().equals(acceptedChildNodeName)) {
                result.add(XMLUtils.getAttribValue(aNode, attribName));
            }
            ++i2;
        }
        return result;
    }

    private static String getNamedItemValueFromAttribs(Node node, String name) {
        String result = "";
        NamedNodeMap attribs = node.getAttributes();
        if (attribs == null) {
            throw new RuntimeException("node " + node + " doesn't habe attribs - was looking for attrib:" + name);
        }
        Node node2 = attribs.getNamedItem(name);
        if (node2 == null) {
            throw new RuntimeException("node " + node + " doesn't habe attribute:" + name);
        }
        result = node2.getNodeValue();
        return result;
    }

    public static void setExceptionHandler(ExceptionHandler handler) {
        exceptionHandler = handler;
    }

    public static ExceptionHandler getExceptionHandler() {
        return exceptionHandler;
    }

    public static void handle(Throwable e2) {
        exceptionHandler.handle(e2);
        System.out.println(e2);
    }

    public static void main(String[] a2) {
        Document d2 = XMLUtils.buildDocument(new File("/home/superx/tomcat_sx/webapps/superx/xml/tablle_fo_pdf.xsl"));
        Node headernode = XMLUtils.getFirstNodeWithNameAndAttrib(d2, "fo:static-content", "flow-name", "xsl-region-before");
    }

    public static int getChildNodeCount(Node aNode, String name) {
        int result = 0;
        NodeList rawList = aNode.getChildNodes();
        int i2 = 0;
        while (i2 < rawList.getLength()) {
            Node n = rawList.item(i2);
            if (n.getNodeType() != 3 && n.getNodeType() != 8 && n.getNodeName().equals(name)) {
                ++result;
            }
            ++i2;
        }
        return result;
    }

    public static String removeTroublesomeCharacters(StringBuffer inString) {
        return XMLUtils.removeTroublesomeCharacters(inString.toString());
    }

    public static String removeTroublesomeCharactersXX(String inString) {
        String xx = "";
        String n = "";
        Charset charset = Charset.forName("ISO-8859-1");
        CharsetDecoder decoder = charset.newDecoder();
        CharsetEncoder encoder = charset.newEncoder();
        int iCount = 128;
        while (iCount <= 165) {
            xx = new Character((char)iCount).toString();
            try {
                n = new String(xx.getBytes("ISO-8859-1"));
                ByteBuffer bbuf = encoder.encode(CharBuffer.wrap(xx));
                CharBuffer cbuf = decoder.decode(bbuf);
                n = cbuf.toString();
                inString = StringUtils.replace(inString, xx, n);
            }
            catch (Exception ex) {
                System.out.println(ex.toString());
            }
            long iValue = xx.charAt(0);
            ++iCount;
        }
        int i2 = 0;
        while (i2 < inString.length()) {
            if (inString.charAt(i2) > '\u007f' && inString.charAt(i2) < '\u00ff') {
                System.out.println("pos " + i2 + " " + inString.charAt(i2));
            }
            ++i2;
        }
        return inString;
    }

    public static String removeTroublesomeCharacters(String input) {
        if (input == null) {
            return null;
        }
        String output = input;
        int l1 = 150;
        int l2 = 151;
        int l3 = 132;
        int l4 = 152;
        int l5 = 147;
        int l6 = 148;
        int l7 = 145;
        int l8 = 146;
        int l9 = 128;
        int l10 = 133;
        int l11 = 149;
        output = output.replace((char)l1, '-');
        output = output.replace((char)l2, '-');
        output = output.replace((char)l3, '\"');
        output = output.replace((char)l4, '\"');
        output = output.replace((char)l5, '\"');
        output = output.replace((char)l6, '\"');
        output = StringUtils.replace(output, "" + (char)l9, "EUR");
        output = output.replace((char)l7, '\'');
        output = output.replace((char)l8, '\'');
        output = output.replace((char)l10, '\u00e0');
        output = output.replace((char)l11, ' ');
        output = output.replace('\u0093', ' ');
        output = output.replace('\u0095', '-');
        StringBuilder newString = new StringBuilder();
        int i2 = 0;
        while (i2 < output.length()) {
            char ch = output.charAt(i2);
            if (ch < '\u00fd' && ch > '\u001f' || ch == '\t' || ch == '\r' || ch == '\n') {
                newString.append(ch);
            }
            ++i2;
        }
        return input;
    }

    static class DTDErrorHandler
    implements ErrorHandler {
        DTDErrorHandler() {
        }

        @Override
        public void warning(SAXParseException error) throws RuntimeException {
            XMLUtils.handle(new RuntimeException("XML-Parse Exception Zeile: " + error.getLineNumber() + "\nDatei: " + error.getSystemId() + "\n" + error.getMessage()));
        }

        @Override
        public void error(SAXParseException error) throws RuntimeException {
            XMLUtils.handle(new RuntimeException("XML-Parse Exception Zeile: " + error.getLineNumber() + "\nDatei: " + error.getSystemId() + "\n" + error.getMessage()));
        }

        @Override
        public void fatalError(SAXParseException error) throws RuntimeException {
            System.out.println("XML-Parse Exception Zeile: " + error.getLineNumber() + "\nDatei: " + error.getSystemId() + "\n" + error.getMessage());
        }
    }
}

