/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

public class LicenseTester {
    private static double[][] versionCodes = new double[][]{{0.9, 56.0}, {1.0, 456.0}, {1.1, 1785.0}, {1.2, 2004.0}, {2.0, 204.0}};

    private LicenseTester() {
    }

    public static boolean isOk(int softwareId, double version, String eing) {
        boolean result = false;
        try {
            String name = eing.substring(0, eing.indexOf(42));
            String code = eing.substring(eing.indexOf(42) + 1);
            String nameCode = code.substring(0, code.indexOf(42));
            String versionCode = code.substring(code.indexOf(42) + 1);
            if (nameCode.equals(LicenseTester.encryptName(softwareId, name)) && version <= LicenseTester.getVersion(softwareId, name, versionCode)) {
                result = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static String encrypt(int softwareId, double version, String name) {
        return String.valueOf(name) + "*" + LicenseTester.encryptName(softwareId, name) + "*" + LicenseTester.encryptVersion(softwareId, name, version);
    }

    private static double getVersion(int softwareId, String name, String encryptedVersionString) {
        double version = -1.0;
        try {
            int sum = Integer.parseInt(encryptedVersionString);
            if ((sum += 42373) % 1573 != 0) {
                sum = -1;
            }
            sum /= 1573;
            sum -= LicenseTester.getNameSum(softwareId, name);
            int i2 = 0;
            while (i2 < versionCodes.length) {
                if (versionCodes[i2][1] == (double)sum) {
                    version = versionCodes[i2][0];
                }
                ++i2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return version;
    }

    private static String encryptVersion(int softwareId, String name, double version) {
        double versionCode = -1.0;
        int i2 = 0;
        while (i2 < versionCodes.length) {
            if (versionCodes[i2][0] == version) {
                versionCode = versionCodes[i2][1];
            }
            ++i2;
        }
        if (versionCode == -1.0) {
            throw new IllegalArgumentException("cannot encrypt -no version code found in class LicenceTester");
        }
        int sum = (int)((double)LicenseTester.getNameSum(softwareId, name) + versionCode);
        sum *= 1573;
        return "" + (sum -= 42373);
    }

    private static String encryptName(int softwareId, String name) {
        int sum = LicenseTester.getNameSum(softwareId, name);
        return String.valueOf(sum + 1308) + "-" + sum + "-" + sum * 2;
    }

    private static int getNameSum(int softwareId, String name) {
        int sum = 1308;
        int i2 = 0;
        while (i2 < name.length()) {
            sum += name.charAt(i2);
            ++i2;
        }
        return sum += softwareId * 13;
    }

    private static void batch(String filename) {
        try {
            String line;
            FileReader fr = new FileReader(new File(filename));
            BufferedReader bfr = new BufferedReader(fr);
            StringBuffer result = new StringBuffer();
            while ((line = bfr.readLine()) != null) {
                String crpt = LicenseTester.encrypt(200, 1.1, line);
                System.out.println(crpt);
            }
            bfr.close();
            fr.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String test = "SZST";
        System.out.println(LicenseTester.encrypt(100, 0.9, test));
        System.out.println("Ok:" + LicenseTester.isOk(100, 0.9, "VPS*4165-2857-5714*4539776"));
        test = "Hochschule Karlsruhe";
        String crpt = LicenseTester.encrypt(200, 1.1, test);
        System.out.println(crpt);
        System.out.println(LicenseTester.isOk(200, 0.9, crpt));
    }
}

