/*
 * Decompiled with CFR 0.152.
 */
package de.superx.util.test;

import de.superx.servlet.SxSQL_Server;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.h2.jdbcx.JdbcDataSource;
import org.pentaho.di.core.database.DataSourceNamingException;
import org.pentaho.di.core.database.DataSourceProviderInterface;

public class KettleH2TestDataSourceProvider
implements DataSourceProviderInterface {
    private Logger logger = Logger.getLogger(this.getClass());
    private String mandantenID = SxSQL_Server.DEFAULT_MANDANTEN_ID;
    private String h2Url;

    public KettleH2TestDataSourceProvider(String mandantenID, Logger logger, String h2Url) {
        if (logger != null) {
            this.logger = logger;
        }
        this.h2Url = h2Url;
        this.mandantenID = mandantenID;
        if (this.mandantenID != null || this.mandantenID.equals("")) {
            this.mandantenID = SxSQL_Server.DEFAULT_MANDANTEN_ID;
        }
        this.logger.info((Object)("Kettle H2 DB Provider inited with url=" + h2Url));
    }

    public KettleH2TestDataSourceProvider(String mandantenID, Logger logger) {
        this(mandantenID, logger, "jdbc:h2:mem:eduetl;DB_CLOSE_DELAY=-1;MODE=POSTGRESQL;DATABASE_TO_LOWER=TRUE;NON_KEYWORDS=KEY,VALUE;BUILTIN_ALIAS_OVERRIDE=TRUE");
    }

    public DataSource getNamedDataSource(String s) throws DataSourceNamingException {
        if (!s.equals("eduetl")) {
            throw new DataSourceNamingException("Data source name unknown: " + s);
        }
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL(this.h2Url);
        ds.setUser("sa");
        return ds;
    }

    public DataSource getNamedDataSource(String s, DataSourceProviderInterface.DatasourceType arg1) throws DataSourceNamingException {
        return this.getNamedDataSource(s);
    }
}

