/*
 * Decompiled with CFR 0.152.
 */
package de.superx.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;

public class FileUtils {
    public static String getFileContentsWithEncoding(String filePath, String encoding) {
        File f = new File(filePath);
        if (!f.exists()) {
            System.out.println("Fehler: Datei " + filePath + " existiert nicht.");
            return null;
        }
        String fileContents = "";
        if (encoding == null || encoding.trim().equals("")) {
            encoding = System.getProperty("file.encoding");
        }
        try {
            FileInputStream fis = new FileInputStream(f);
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fis, encoding));
            StringWriter out = new StringWriter();
            String text = in.readLine();
            while (text != null) {
                out.write(text);
                out.write(System.getProperty("line.separator"));
                text = in.readLine();
            }
            if (out != null) {
                fileContents = out.toString();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fileContents;
    }

    public static void saveFileContentsWithEncoding(String filename, String contents, String encoding) throws FileNotFoundException, IOException {
        File f = new File(filename);
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), encoding));
        out.write(contents);
        out.close();
    }

    public static String convertToIso(String inp, String dbsystem) throws UnsupportedEncodingException {
        String outp = new String(inp.getBytes("ISO-8859-1"));
        if (dbsystem.equalsIgnoreCase("postgres")) {
            outp = outp.replaceAll("\u00b4", " ");
        }
        return outp;
    }
}

