/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.batch.util;

import java.io.IOException;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.QuoteMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;

public class SuperxRowMapper
implements RowMapper<String> {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final CSVFormat format_pg = CSVFormat.POSTGRESQL_CSV.withDelimiter('^').withIgnoreSurroundingSpaces().withQuoteMode(QuoteMode.MINIMAL);
    public static final CSVFormat format_ifx = CSVFormat.INFORMIX_UNLOAD.withDelimiter('^').withQuoteMode(QuoteMode.NONE).withTrailingDelimiter(true);
    private CSVFormat format;

    public SuperxRowMapper(CSVFormat format) {
        this.format = format;
    }

    public String mapRow(ResultSet rs, int rowNum) throws SQLException {
        int columnCount = rs.getMetaData().getColumnCount();
        StringWriter resultStream = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)resultStream, this.format);){
            for (int i = 0; i < columnCount; ++i) {
                String field = rs.getString(i + 1);
                if (field != null && (field = field.trim()).isEmpty()) {
                    field = " ";
                }
                printer.print((Object)field);
            }
            if (this.format.getTrailingDelimiter()) {
                resultStream.append(this.format.getDelimiter());
            }
        }
        catch (IOException e) {
            this.logger.error("Couldn't map row from ResultSet to csv", (Throwable)e);
            throw new RuntimeException(e);
        }
        return resultStream.toString();
    }
}

