/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.batch.tasklet;

import de.memtext.util.XMLUtils;
import de.superx.spring.service.EntityJobDescriptionSource;
import de.superx.util.PathAndFileUtils;
import java.io.File;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UpgradeDbConfigTasklet
implements Tasklet {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private String component;

    public UpgradeDbConfigTasklet(String component) {
        this.component = component;
    }

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        try {
            File dbFormsConfigFile = PathAndFileUtils.getDbFormsConfigFile();
            File dbFormsModuleTemplateFile = PathAndFileUtils.getDbFormsTemplateFile(this.component, "pg");
            if (this.component.equals("kern") && dbFormsConfigFile.exists()) {
                return RepeatStatus.FINISHED;
            }
            Document doc = this.generateDbFormsConfig(dbFormsConfigFile, dbFormsModuleTemplateFile);
            UpgradeDbConfigTasklet.replaceDbFormsConfig(doc);
            this.logger.info(String.format("successfully updated %s using template %s", dbFormsConfigFile.getAbsolutePath(), dbFormsModuleTemplateFile.getAbsolutePath()));
        }
        catch (Exception e) {
            this.logger.error("error updating dbforms-config", (Throwable)e);
            ExitStatus exitStatus = ExitStatus.FAILED;
            exitStatus = exitStatus.addExitDescription(e.getMessage());
            contribution.setExitStatus(exitStatus);
        }
        return RepeatStatus.FINISHED;
    }

    private Document generateDbFormsConfig(File dbFormsConfigFile, File dbFormsModuleTemplateFile) throws Exception {
        Document dbFormsConfigDoc = PathAndFileUtils.readXmlFile(dbFormsConfigFile);
        Document dbFormsModuleTemplateDoc = PathAndFileUtils.readXmlFile(dbFormsModuleTemplateFile);
        if (this.component.equals("kern")) {
            return dbFormsModuleTemplateDoc;
        }
        DocumentBuilderFactory dbf = XMLUtils.createSecureDocumentBuilderFactory();
        Document result = dbf.newDocumentBuilder().newDocument();
        Element dbFormsConfig = result.createElement("dbforms-config");
        Element date = result.createElement("date-format");
        date.appendChild(result.createTextNode("dd.MM.yyyy"));
        dbFormsConfig.appendChild(date);
        dbFormsConfig.appendChild(result.createComment("Hier beginnt Moduldefinition"));
        result.appendChild(dbFormsConfig);
        NodeList dbConfigTables = dbFormsConfigDoc.getElementsByTagName("table");
        NodeList dbConfigTemplateTables = dbFormsModuleTemplateDoc.getElementsByTagName("table");
        for (int i = 0; i < dbConfigTables.getLength(); ++i) {
            Node table = dbConfigTables.item(i);
            if (UpgradeDbConfigTasklet.tableExists(dbConfigTemplateTables, table)) continue;
            dbFormsConfig.appendChild(UpgradeDbConfigTasklet.importNode(result, table));
        }
        String importComment = String.format("Beginn Import von %s f\u00fcr %s", dbFormsModuleTemplateFile.getAbsolutePath(), PathAndFileUtils.getWebinfPath());
        dbFormsConfig.appendChild(result.createComment(importComment));
        for (int i = 0; i < dbConfigTemplateTables.getLength(); ++i) {
            Node table = dbConfigTemplateTables.item(i);
            if (!UpgradeDbConfigTasklet.hasDiskBlobField(table)) {
                dbFormsConfig.appendChild(UpgradeDbConfigTasklet.importNode(result, table));
                continue;
            }
            dbFormsConfig.appendChild(UpgradeDbConfigTasklet.createNewTable(result, table));
        }
        dbFormsConfig.appendChild(result.createComment("Ende Import von " + dbFormsConfigFile.getAbsolutePath()));
        NodeList dbConfigConnections = dbFormsConfigDoc.getElementsByTagName("dbconnection");
        for (int i = 0; i < dbConfigConnections.getLength(); ++i) {
            Node connection = dbConfigConnections.item(i);
            String name = PathAndFileUtils.getAttribute(connection.getAttributes(), "name");
            if (name.equals("java:/comp/env/jdbc/superx")) {
                dbFormsConfig.appendChild(UpgradeDbConfigTasklet.createNewConnection(result));
                continue;
            }
            dbFormsConfig.appendChild(UpgradeDbConfigTasklet.importNode(result, connection));
        }
        return result;
    }

    private static Node createNewConnection(Document doc) {
        Element newConnection = doc.createElement("dbconnection");
        newConnection.setAttribute("id", "datasourceBean");
        newConnection.setAttribute("connectionProviderClass", "de.superx.db.SpringBeanConnectionProvider");
        newConnection.setAttribute("isPow2", "true");
        newConnection.setAttribute("isJndi", "false");
        newConnection.setAttribute("default", "true");
        return newConnection;
    }

    private static Node createNewTable(Document document, Node table) {
        Element newTable = document.createElement("table");
        NodeList fields = table.getChildNodes();
        int len = fields.getLength();
        for (int i = 0; i < len; ++i) {
            Node field = fields.item(i);
            boolean hasfieldTypeDiskBlob = PathAndFileUtils.getAttribute(field.getAttributes(), "fieldType").equals("diskblob");
            if (!hasfieldTypeDiskBlob) {
                newTable.appendChild(field);
                continue;
            }
            Element newField = document.createElement("field");
            newField.setAttribute("name", PathAndFileUtils.getAttribute(field.getAttributes(), "name"));
            newField.setAttribute("encoding", PathAndFileUtils.getAttribute(field.getAttributes(), "encoding"));
            newField.setAttribute("fieldType", "diskblob");
            newField.setAttribute("directory", PathAndFileUtils.getWebinfPath() + PathAndFileUtils.getAttribute(field.getAttributes(), "directory"));
            newTable.appendChild(newField);
        }
        return newTable;
    }

    private static boolean hasDiskBlobField(Node table) {
        return !EntityJobDescriptionSource.filterElements(table.getChildNodes()).stream().filter(field -> PathAndFileUtils.getAttribute(field.getAttributes(), "fieldType").equals("diskblob")).findFirst().isEmpty();
    }

    private static boolean tableExists(NodeList list, Node table) {
        String tableName = PathAndFileUtils.getAttribute(table.getAttributes(), "name");
        return !EntityJobDescriptionSource.filterElements(list).stream().filter(node -> PathAndFileUtils.getAttribute(node.getAttributes(), "name").equals(tableName)).findFirst().isEmpty();
    }

    private static Node importNode(Document target, Node node) {
        return target.importNode(node, true);
    }

    private static void replaceDbFormsConfig(Document doc) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", null);
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult streamResult = new StreamResult(PathAndFileUtils.getDbFormsConfigFile());
        transformer.transform(source, streamResult);
    }
}

