/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.batch.tasklet;

import de.superx.util.TrailingDelimiterRemovingReader;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.postgresql.PGConnection;
import org.postgresql.copy.CopyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.core.io.Resource;

public class PgCopyLoadTasklet
implements Tasklet,
StepListener {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private String table;
    private Resource unlFile;
    private String delimiter;
    private boolean isCsv;
    private String encoding = "UTF8";
    private boolean header = false;
    private boolean truncateTargetTable;
    private DataSource dataSource;
    private boolean continueOnError = true;

    public PgCopyLoadTasklet(Resource unlFile, String delimiter, String table, DataSource dataSource) {
        this(unlFile, delimiter, table, dataSource, true, true, false);
    }

    public PgCopyLoadTasklet(Resource unlFile, String delimiter, String table, DataSource dataSource, boolean truncateTable, boolean isCsv) {
        this(unlFile, delimiter, table, dataSource, truncateTable, true, isCsv);
    }

    public PgCopyLoadTasklet(Resource unlFile, String delimiter, String table, DataSource dataSource, boolean truncateTable, boolean continueOnError, boolean isCsv) {
        this.table = table;
        this.unlFile = unlFile;
        this.delimiter = delimiter;
        this.dataSource = dataSource;
        this.truncateTargetTable = truncateTable;
        this.continueOnError = continueOnError;
        this.isCsv = isCsv;
    }

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        this.logger.info("Load from " + this.unlFile.getFile().getAbsolutePath());
        this.logger.info("Into table " + this.table);
        String copySql = "COPY " + this.table + " FROM STDIN WITH (" + (this.isCsv ? "FORMAT csv, " : "") + "DELIMITER '" + this.delimiter + "', NULL '', ENCODING '" + this.encoding + "'" + (this.header ? " HEADER" : "") + ")";
        try (Connection con = this.dataSource.getConnection();
             FileReader unl = new FileReader(this.unlFile.getFile());
             BufferedReader reader = new BufferedReader(unl);){
            int columnCount = this.getColumnCount(con);
            long count = 0L;
            if (!this.isCsv) {
                try (TrailingDelimiterRemovingReader in = new TrailingDelimiterRemovingReader(reader, this.delimiter, columnCount, true, this.unlFile.getFilename());){
                    CopyManager copyManager = PgCopyLoadTasklet.getPgConnection(con).getCopyAPI();
                    count = copyManager.copyIn(copySql, (Reader)in);
                }
            } else {
                CopyManager copyManager = PgCopyLoadTasklet.getPgConnection(con).getCopyAPI();
                count = copyManager.copyIn(copySql, (Reader)reader);
            }
            this.logger.info(count + " records loaded.");
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            this.logger.error("Error loading table: " + this.table);
            this.logger.error(errorMsg);
            if (!this.continueOnError) {
                throw e;
            }
            ExitStatus exitStatus = ExitStatus.FAILED;
            exitStatus = exitStatus.addExitDescription(errorMsg);
            contribution.setExitStatus(exitStatus);
        }
        return RepeatStatus.FINISHED;
    }

    private static PGConnection getPgConnection(Connection connection) throws SQLException {
        PGConnection pgConnection = null;
        pgConnection = connection instanceof PGConnection ? (PGConnection)connection : connection.unwrap(PGConnection.class);
        return pgConnection;
    }

    private int getColumnCount(Connection con) throws SQLException {
        int count = -1;
        try (Statement st = con.createStatement();
             ResultSet rs = st.executeQuery("select * from " + this.table + " limit 1");){
            ResultSetMetaData rsm = rs.getMetaData();
            count = rsm.getColumnCount();
            if (this.truncateTargetTable) {
                st.execute("delete from " + this.table);
            }
        }
        return count;
    }
}

