/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.filter.GenericFilterBean;

public class SessionCookieFilter
extends GenericFilterBean {
    private final List<String> PATHS_TO_IGNORE_SETTING_SAMESITE = Arrays.asList(new String[0]);
    private final String SESSION_COOKIE_NAME = "JSESSIONID";
    private final String SESSION_PATH_ATTRIBUTE = ";Path=";
    private final String ROOT_CONTEXT = "/";
    private final String SAME_SITE_ATTRIBUTE_VALUES = ";HttpOnly;SameSite=Strict";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        List<Cookie> cookieList;
        Cookie sessionCookie;
        Cookie[] cookies;
        boolean isResourceRequest;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String requestUrl = req.getRequestURL().toString();
        boolean bl = isResourceRequest = requestUrl != null ? StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.PATHS_TO_IGNORE_SETTING_SAMESITE.stream().filter(s -> requestUrl.contains((CharSequence)s)).findFirst().orElse(null)}) : false;
        if (!isResourceRequest && (cookies = ((HttpServletRequest)request).getCookies()) != null && cookies.length > 0 && (sessionCookie = (Cookie)(cookieList = Arrays.asList(cookies)).stream().filter(cookie -> "JSESSIONID".equals(cookie.getName())).findFirst().orElse(null)) != null) {
            String contextPath = request.getServletContext() != null && StringUtils.isNotBlank((CharSequence)request.getServletContext().getContextPath()) ? request.getServletContext().getContextPath() : "/";
            resp.setHeader("Set-Cookie", sessionCookie.getName() + "=" + sessionCookie.getValue() + ";Path=" + contextPath + ";HttpOnly;SameSite=Strict");
        }
        chain.doFilter(request, response);
    }
}

