/*
 * Decompiled with CFR 0.152.
 */
package de.superx.sec;

import de.superx.common.Field;
import de.superx.sec.InputCheck;
import de.superx.sec.InputCheckRegistry;
import de.superx.sec.StringCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CheckExecution {
    private Field field = null;
    private static String CHECK_REGEX = "\\{InputCheck:(?<id>[A-Za-z][A-Za-z0-9\\\\_\\\\.]*)\\}";
    private static Pattern CHECK_PATTERN = Pattern.compile(CHECK_REGEX);
    public static String DEFAULT_CHECK = "default";

    public CheckExecution(Field field) {
        this.field = field;
    }

    public boolean run(String input) {
        InputCheck check;
        String att = this.field.getAttribut();
        int zeilenanzahl = this.field.getZeilenanzahl();
        if (zeilenanzahl == 1 && (input.contains("\n") || input.contains("\r"))) {
            return false;
        }
        String checkId = CheckExecution.determineId(att);
        if (System.getProperty("SuperX-HISinOne-VERSION") == null) {
            String fieldType = this.field.getTyp().getStringValue();
            if (checkId.equals(DEFAULT_CHECK) && fieldType.equals(Field.Typ.typ_char.getStringValue())) {
                checkId = StringCheck.STRING_CHECK;
            }
        }
        if ((check = InputCheckRegistry.lookupCheck(checkId)) == null) {
            return false;
        }
        return check.check(input);
    }

    private static String determineId(String string) {
        Matcher matcher = CHECK_PATTERN.matcher(string);
        if (matcher.find()) {
            return matcher.group("id");
        }
        return DEFAULT_CHECK;
    }
}

