/*
 * Decompiled with CFR 0.152.
 */
package de.superx.saiku;

import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.saiku.service.PlatformUtilsService;
import org.saiku.service.util.dto.Plugin;
import org.springframework.beans.factory.annotation.Autowired;

public class SuperxPlatformUtilsService
extends PlatformUtilsService {
    protected static Logger logger = Logger.getLogger(SuperxPlatformUtilsService.class);
    private String filePath;
    @Autowired
    ServletContext servletContext;

    public void setPath(String path) {
        this.filePath = this.servletContext.getRealPath(path);
        logger.info((Object)("Set Path: " + this.filePath));
    }

    public String getPath() {
        logger.info((Object)("Get Path: " + this.filePath));
        return this.filePath;
    }

    public ArrayList<Plugin> getAvailablePlugins() {
        logger.info((Object)("Plugins Path: " + this.filePath));
        ArrayList<Plugin> l = new ArrayList<Plugin>();
        File f = new File(this.filePath);
        String[] directories = f.list(new FilenameFilter(){

            @Override
            public boolean accept(File current, String name) {
                return new File(current, name).isDirectory();
            }
        });
        if (directories != null && directories.length > 0) {
            for (String d : directories) {
                File subdir = new File(this.filePath + "/" + d);
                File[] subfiles = subdir.listFiles();
                if (subfiles == null) continue;
                for (File s : subfiles) {
                    if (!s.getName().equals("plugin.js")) continue;
                    Plugin p = new Plugin(s.getParentFile().getName(), "", "js/saiku/plugins/" + s.getParentFile().getName() + "/plugin.js");
                    l.add(p);
                }
            }
        }
        return l;
    }
}

