/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.baseobjects.coll.IdObjectSet;
import de.memtext.util.NumberUtils;
import de.memtext.util.StringUtils;
import de.memtext.util.XMLUtils;
import de.superx.bin.fm.EtlStarter;
import de.superx.bin.fm.FMListe;
import de.superx.bin.fm.SqlVarsDirective;
import de.superx.bin.fm.SxHash;
import de.superx.common.RepositoryItem;
import de.superx.common.RepositoryItemCollection;
import de.superx.common.SelectableItem;
import de.superx.common.SelectableItemNode;
import de.superx.common.StandaloneSicht;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.servlet.SxSQL_Server;
import de.superx.util.PathAndFileUtils;
import de.superx.util.SqlStringUtils;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.ParseException;
import freemarker.log.Logger;
import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TemplateProcessor {
    private Configuration cfg;
    public SxResultSet rawFmTemplates;
    protected HashMap repositoryMap = new HashMap();
    protected String mandantenID = SxSQL_Server.DEFAULT_MANDANTEN_ID;
    protected Connection con = null;
    public static final String REPOSITORY_SELECT = "select trim(both from id) as id,caption,content,gueltig_seit,gueltig_bis,comment,sort1,sort2,sort3 from sx_repository where aktiv=1";

    public TemplateProcessor(String mandantenID, Connection con) {
        this(mandantenID);
        this.con = con;
    }

    public TemplateProcessor(String mandantenID) {
        this.mandantenID = mandantenID;
        Configuration myCfg = new Configuration(Configuration.VERSION_2_3_21);
        StringTemplateLoader stringLoader = new StringTemplateLoader();
        FileTemplateLoader fileLoader = null;
        try {
            fileLoader = new FileTemplateLoader(new File(PathAndFileUtils.getWebinfPath() + File.separator + "freemarker"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        MultiTemplateLoader multiLoader = new MultiTemplateLoader(new TemplateLoader[]{stringLoader, fileLoader});
        myCfg.setTemplateLoader((TemplateLoader)multiLoader);
        try {
            myCfg.setSetting("number_format", "###########.####");
            myCfg.setSharedVariable("etl", (TemplateModel)new EtlStarter(mandantenID));
            myCfg.setSharedVariable("sqlvar", (TemplateModel)new SqlVarsDirective());
        }
        catch (TemplateException e) {
            System.out.println("FreeMarker warning: " + String.valueOf((Object)e));
            e.printStackTrace();
        }
        this.cfg = myCfg;
    }

    public void setRepositoryMap(HashMap repository) {
        this.repositoryMap = repository;
    }

    public void add(String id, String ts) {
        MultiTemplateLoader mtl = (MultiTemplateLoader)this.cfg.getTemplateLoader();
        ((StringTemplateLoader)mtl.getTemplateLoader(0)).putTemplate(id, ts);
    }

    protected synchronized Template buildTemplateObject(String templateName, String template) throws IOException {
        Template t = null;
        templateName = this.cleanName((String)templateName);
        templateName = (String)templateName + "-rnd:" + NumberUtils.getRandomInt(1000000000);
        template = template.replaceAll("\\p{javaSpaceChar}", " ");
        MultiTemplateLoader tl = (MultiTemplateLoader)this.cfg.getTemplateLoader();
        ((StringTemplateLoader)tl.getTemplateLoader(0)).putTemplate((String)templateName, template);
        try {
            t = this.cfg.getTemplate((String)templateName);
            this.cfg.removeTemplateFromCache((String)templateName);
        }
        catch (ParseException e) {
            throw new RuntimeException("FreeMarker-Parsing fehlgeschlagen - " + e.getMessage() + "DETAILS: Die Zeilennummer bezieht sich auf folgende Vorlage\n(Masken select_stmt nach SuperX-Verarbeitung mit generateSql)\n" + template);
        }
        return t;
    }

    public String process(String templateName, String fmSql, HashMap hmap, String sqldialect) throws TemplateException, IOException, SQLException {
        StringBuffer b = new StringBuffer();
        fmSql = b.toString() + (String)fmSql;
        templateName = this.cleanName(templateName);
        hmap.put("SQLdialect", sqldialect);
        hmap.putAll(this.repositoryMap);
        if (((String)fmSql).indexOf("<sqlvars>") > -1) {
            this.addSqlVars(hmap, (String)fmSql, sqldialect);
            fmSql = StringUtils.removeSqlVars((String)fmSql);
        }
        StringWriter out = new StringWriter();
        Template t = this.buildTemplateObject(templateName, (String)fmSql);
        t.process((Object)hmap, (Writer)out);
        ((Writer)out).close();
        return ((Object)out).toString();
    }

    private synchronized void addSqlVars(HashMap hmap, String fmSql, String sqldialect) throws SQLException, TemplateException, IOException {
        int i = fmSql.indexOf("<sqlvars>");
        int i2 = fmSql.indexOf("</sqlvars>");
        String sqlvarsxml = fmSql.substring(i, i2 + 10);
        Document doc = null;
        try {
            doc = XMLUtils.buildDocumentFromStringWithException(sqlvarsxml, false);
        }
        catch (SAXException e) {
            String msg = "Sqlvars konnten nicht zu XML-Dokument verarbeitet werden, Syntax checken ";
            System.out.println(msg);
            System.out.println(sqlvarsxml);
            e.printStackTrace();
            throw new SQLException(msg + "vergl. catalina.out ");
        }
        NodeList list = doc.getElementsByTagName("sqlvar");
        for (i = 0; i < list.getLength(); ++i) {
            FMListe liste;
            SxResultSet roh;
            Node n = list.item(i);
            String varname = XMLUtils.getAttribValue(n, "name");
            Object sql = n.getTextContent();
            SqlVarType type = SqlVarType.none;
            if (XMLUtils.hasAttrib(n, "type")) {
                type = SqlVarType.valueOf(XMLUtils.getAttribValue(n, "type").toLowerCase());
            }
            String name_intern = "";
            if (type == SqlVarType.sichtsequence) {
                roh = this.readFromDb((String)sql);
                liste = new FMListe();
                for (SxResultRow zeile : roh) {
                    String gewuenschterStand = "today";
                    liste.add(this.addSqlVarSicht(hmap, "nur_ein_dummy", (String)zeile.get(0), gewuenschterStand));
                }
                hmap.put(varname, liste);
                continue;
            }
            if (type == SqlVarType.hashlist) {
                List<TemplateHashModel> results = this.selectFromDb((String)sql);
                hmap.put(varname, results);
                continue;
            }
            if (type == SqlVarType.sicht) {
                name_intern = XMLUtils.getAttribValue(n, "name_intern");
                String gewuenschterStand = "today";
                if (XMLUtils.hasAttrib(n, "stand")) {
                    gewuenschterStand = XMLUtils.getAttribValue(n, "stand");
                }
                this.addSqlVarSicht(hmap, varname, name_intern, gewuenschterStand);
                continue;
            }
            if (type == SqlVarType.list) {
                roh = this.readFromDb((String)sql);
                ArrayList<String> results = new ArrayList<String>();
                for (SxResultRow zeile : roh) {
                    results.add((String)zeile.get(0));
                }
                hmap.put(varname, results);
                continue;
            }
            if (type == SqlVarType.string) {
                String resultstring = this.process("sqlvar " + varname + NumberUtils.getRandomInt(99999999), (String)sql, hmap, sqldialect);
                hmap.put(varname, resultstring);
                continue;
            }
            if (SqlStringUtils.tableExists(this.con, "sx_repository", this.mandantenID)) {
                sql = "<#include \"SuperX_general\"/><#include \"SQL_lingua_franca\"/>" + (String)sql;
            }
            sql = this.process("sqlvar " + varname + NumberUtils.getRandomInt(99999999), (String)sql, hmap, sqldialect);
            roh = this.readFromDb((String)sql);
            liste = new FMListe();
            boolean isSelectableItem = false;
            Object entry = "";
            int rowcount = roh.size();
            for (SxResultRow zeile : roh) {
                if (type == SqlVarType.hash || type == SqlVarType.hashsequence) {
                    SxHash h = new SxHash();
                    for (int j = 0; j < zeile.size(); ++j) {
                        String key = roh.getColumnName(j).toLowerCase();
                        Object value = zeile.get(j);
                        h.put(key, value);
                    }
                    if (rowcount == 1) {
                        entry = h;
                    }
                    liste.add(h);
                    continue;
                }
                entry = zeile.get(0);
                if (entry == null) {
                    entry = "";
                }
                String nam = "";
                if (zeile.size() > 1) {
                    nam = SqlStringUtils.getValueAsString(zeile.get(1));
                    isSelectableItem = true;
                }
                SelectableItem item = new SelectableItem(entry, nam);
                if (zeile.size() > 2) {
                    item.setStrukturInfo(zeile.get(2));
                }
                if (zeile.size() > 3) {
                    item.setStrukturInfo(zeile.get(3));
                }
                liste.add(new SelectableItemNode(item));
            }
            if (type == SqlVarType.hashsequence || type == SqlVarType.hash && rowcount > 1 || isSelectableItem) {
                hmap.put(varname, liste);
                liste = null;
                continue;
            }
            hmap.put(varname, entry);
            entry = null;
        }
    }

    protected List<TemplateHashModel> selectFromDb(String sql) throws SQLException {
        ArrayList<TemplateHashModel> result = new ArrayList<TemplateHashModel>();
        try (Statement st = this.con.createStatement();
             ResultSet res = st.executeQuery(sql);){
            ResultSetMetaData meta = res.getMetaData();
            int colCount = meta.getColumnCount();
            ArrayList<String> colLabels = new ArrayList<String>(colCount);
            for (int i = 0; i < colCount; ++i) {
                colLabels.add(meta.getColumnLabel(i + 1));
            }
            while (res.next()) {
                HashMap<String, String> row = new HashMap<String, String>();
                for (String colLabel : colLabels) {
                    row.put(colLabel, res.getString(colLabel));
                }
                result.add((TemplateHashModel)new SimpleHash(row));
            }
        }
        return result;
    }

    protected StandaloneSicht addSqlVarSicht(HashMap hmap, String varname, String name_intern, String gewuenschterStand) throws SQLException {
        throw new IllegalStateException("sqlvar mit type Sicht wird hier nicht unterst\u00fctzt");
    }

    protected SxResultSet readFromDb(String sql) throws SQLException {
        return new SxResultSet();
    }

    protected String cleanName(String templateName) {
        if (templateName.indexOf("/") > -1) {
            templateName = templateName.replace('/', ' ');
        }
        if (templateName.indexOf("\\") > -1) {
            templateName = templateName.replace('\\', ' ');
        }
        return templateName;
    }

    public void setTemplates(SxResultSet rawFmTemplates) {
        this.rawFmTemplates = rawFmTemplates;
        if (rawFmTemplates == null) {
            throw new RuntimeException("Keine FreeMarker Templates geliefert");
        }
        for (SxResultRow row : rawFmTemplates) {
            String name = (String)row.get(0);
            String content = SqlStringUtils.getValueAsString(row.get(1));
            this.add(name, content);
            this.cfg.addAutoInclude(name);
        }
    }

    public static void repositoryToMap(SxResultSet rs, HashMap map) {
        IdObjectSet riColls = new IdObjectSet();
        for (SxResultRow row : rs) {
            Object id = row.get(0);
            String name = (String)row.get(1);
            RepositoryItem ri = new RepositoryItem();
            ri.setId(id);
            ri.setName(name);
            ri.setContent(SqlStringUtils.getValueAsString(row.get(2)));
            ri.setValidSince((Date)row.get(3));
            ri.setValidTill((Date)row.get(4));
            ri.setComment(SqlStringUtils.getValueAsString(row.get(5)));
            RepositoryItemCollection riColl = null;
            if (riColls.containsItemWithId(id)) {
                riColl = (RepositoryItemCollection)riColls.getById(id);
            } else {
                riColl = new RepositoryItemCollection(id);
                riColls.add(riColl);
            }
            riColl.add(ri);
        }
        for (RepositoryItemCollection rcoll : riColls) {
            map.put(rcoll.getId(), rcoll);
        }
    }

    static {
        try {
            Logger.selectLoggerLibrary((int)0);
        }
        catch (Exception e) {
            System.out.println("FreeMarker warning: " + String.valueOf(e));
        }
    }

    public static enum SqlVarType {
        list,
        hashlist,
        hash,
        hashsequence,
        sicht,
        sichtsequence,
        string,
        none;

    }
}

