/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.metadata.models.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.superx.bianalysis.FaultyMetadataException;
import de.superx.bianalysis.metadata.UpsertStringBuilder;
import de.superx.bianalysis.metadata.models.json.MetaDimension;
import de.superx.bianalysis.metadata.models.json.MetaObject;
import de.superx.bianalysis.models.CriteriaGroup;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"id", "default_release", "position", "caption", "criteria_group", "dim_column", "sort_order_column", "ref_to", "description", "fact_column"})
public class MetaDimensionAttribute
extends MetaObject {
    @JsonProperty(value="dim_column")
    private String dimColumn;
    @JsonProperty(value="sort_order_column")
    private String sortOrderColumn;
    @JsonProperty(value="hierarchical_filter")
    private boolean hierarchicalFilter;
    private Integer position;
    @JsonIgnore
    private MetaDimension dimension;
    @JsonIgnore
    private MetaDimensionAttribute confDimAttrRef;
    @JsonProperty(value="ref_to")
    private String refTo;
    @JsonProperty(value="filter_selection")
    private String filterSelection;
    @JsonProperty(value="is_hidden")
    private boolean isHidden;
    @JsonProperty(value="criteria_groups")
    private List<CriteriaGroup> criteriaGroups;

    public MetaDimensionAttribute() {
        super("dimension_attribute");
    }

    public MetaDimensionAttribute(String attrColumn) {
        super("dimension_attribute");
        this.refTo = attrColumn;
    }

    public void setConformedDimensionAttribute(MetaDimensionAttribute attribute) {
        this.confDimAttrRef = attribute;
    }

    @Override
    public UpsertStringBuilder getUpsertBuilder() {
        UpsertStringBuilder builder = new UpsertStringBuilder();
        if (this.confDimAttrRef == null) {
            builder = super.getUpsert().withIdCol("dimension_id", this.dimension.id).withStringCol("columnname", this.dimColumn).withCriteriaGroup("criteria_groups", this.criteriaGroups).withStringCol("sort_order_column", this.sortOrderColumn).withStringCol("filter_selection", this.getFilterSelectionWithDefault()).withIntCol("position", this.position).withStringCol("is_hidden", String.valueOf(this.isHidden));
        } else {
            builder = new UpsertStringBuilder().forTable("metadata", this.sourceTable).withStringCol("namespace", this.namespace).withIdCol("id", this.id).withStringCol("default_release", this.defaultRelease);
            builder = this.isHidden ? builder.withStringCol("is_hidden", String.valueOf(this.isHidden)) : builder.withStringCol("is_hidden", String.valueOf(this.confDimAttrRef.isHidden));
            builder = this.position != null ? builder.withIntCol("position", this.position) : builder.withIntCol("position", this.confDimAttrRef.getPosition());
            builder = this.getCaption() != null && !this.getCaption().isBlank() ? builder.withStringCol("caption", this.caption) : builder.withStringCol("caption", this.confDimAttrRef.getCaption());
            builder = this.getDimColumn() != null && !this.getDimColumn().isBlank() ? builder.withStringCol("columnname", this.dimColumn) : builder.withStringCol("columnname", this.confDimAttrRef.getDimColumn());
            builder = this.getFilterSelection() != null && !this.getFilterSelection().isBlank() ? builder.withStringCol("filter_selection", this.filterSelection) : builder.withStringCol("filter_selection", this.confDimAttrRef.getFilterSelectionWithDefault());
            builder = this.getSortOrderColumn() != null && !this.getSortOrderColumn().isBlank() ? builder.withStringCol("sort_order_column", this.sortOrderColumn) : builder.withStringCol("sort_order_column", this.confDimAttrRef.getSortOrderColumn());
            builder = builder.withIdCol("dimension_id", this.dimension.id);
            builder = builder.withIdCol("conformed", this.confDimAttrRef.id);
        }
        if (this.dimColumn == null && this.criteriaGroups != null && this.criteriaGroups.size() > 0) {
            String newColumnName = this.caption.toLowerCase().replaceAll("\\s+", "_").replaceAll("[^a-z0-9-]", "_");
            builder = builder.withStringCol("columnname", newColumnName);
        }
        builder = this.confDimAttrRef != null && this.confDimAttrRef.hierarchicalFilter ? builder.withStringCol("hierarchical_filter", String.valueOf(this.confDimAttrRef.hierarchicalFilter)) : builder.withStringCol("hierarchical_filter", String.valueOf(this.hierarchicalFilter));
        builder = this.description != null && !this.description.isBlank() ? builder.withStringCol("description", this.description) : (this.confDimAttrRef != null ? builder.withStringCol("description", this.confDimAttrRef.getDescription()) : builder.withStringCol("description", ""));
        return builder;
    }

    public Integer getPosition() {
        return this.position;
    }

    public void setPosition(Integer position) {
        this.position = position;
    }

    public String getDimColumn() {
        return this.dimColumn;
    }

    public void setDimColumn(String dimColumn) {
        this.dimColumn = dimColumn;
    }

    public String getSortOrderColumn() {
        return this.sortOrderColumn;
    }

    public void setSortOrderColumn(String sortOrderColumn) {
        this.sortOrderColumn = sortOrderColumn;
    }

    public String getFilterSelection() {
        return this.filterSelection;
    }

    public void setFilterSelection(String filterSelection) {
        this.filterSelection = filterSelection;
    }

    public MetaDimension getDimension() {
        return this.dimension;
    }

    public void setDimension(MetaDimension dimension) {
        this.dimension = dimension;
    }

    public MetaDimensionAttribute getConfDimAttrRef() {
        return this.confDimAttrRef;
    }

    public void setConfDimAttrRef(MetaDimensionAttribute confDimAttrRef) {
        this.confDimAttrRef = confDimAttrRef;
    }

    public String getRefTo() {
        return this.refTo;
    }

    public void setRefTo(String refTo) {
        this.refTo = refTo;
    }

    public List<CriteriaGroup> getCriteriaGroups() {
        return this.criteriaGroups;
    }

    public void setCriteriaGroups(List<CriteriaGroup> criteriaGroups) {
        this.criteriaGroups = criteriaGroups;
    }

    @Override
    @JsonIgnore
    public String getDocIdentifier() {
        if (this.refTo != null) {
            if (this.confDimAttrRef == null) {
                throw new FaultyMetadataException("The Object with the id '" + String.valueOf(this.id) + "' references a conformed attribute with the name '" + this.refTo + "'. This Object cannot be found.");
            }
            return this.confDimAttrRef.getDocIdentifier();
        }
        return this.dimension.getDocIdentifier() + "." + this.dimColumn;
    }

    public boolean isHierarchicalFilter() {
        return this.hierarchicalFilter;
    }

    public void setHierarchicalFilter(boolean hierarchicalFilter) {
        this.hierarchicalFilter = hierarchicalFilter;
    }

    @JsonIgnore
    public boolean isHidden() {
        return this.isHidden;
    }

    @JsonIgnore
    public String getFilterSelectionWithDefault() {
        if (this.filterSelection == null || this.filterSelection.isBlank()) {
            return "show_existing_only";
        }
        return this.filterSelection;
    }

    @JsonIgnore
    public void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }
}

