/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.metadata.models.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.superx.bianalysis.metadata.Identifier;
import de.superx.bianalysis.metadata.UpsertStringBuilder;
import de.superx.bianalysis.metadata.models.json.MetaDimensionAttribute;
import de.superx.bianalysis.metadata.models.json.MetaFact;
import de.superx.bianalysis.metadata.models.json.MetaObject;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"id", "default_release", "position", "ref_to", "caption", "description", "dimension", "is_historical", "fact_column", "view", "alias", "is_hierarchy", "id_column", "attributes"})
public class MetaDimension
extends MetaObject {
    @JsonProperty(value="ref_to")
    private String refTo;
    private String dimension;
    @JsonProperty(value="fact_column")
    private String factColumn;
    private String alias;
    private String view;
    @JsonProperty(value="id_column")
    private String idColumn;
    private List<MetaDimensionAttribute> attributes;
    @JsonProperty(value="is_hierarchy")
    private boolean isHierarchy;
    @JsonProperty(value="is_historical")
    private boolean isHistorical;
    @JsonProperty(value="is_hidden")
    private boolean isHidden;
    @JsonProperty(value="attributes_sql")
    private String attributesSql;
    @JsonIgnore
    private MetaFact fact;
    private Integer position;
    @JsonIgnore
    private boolean isConformed = false;
    @JsonIgnore
    private MetaDimension conformedDimension;

    public MetaDimension() {
        super("dimension");
    }

    public void setConformedDimension(MetaDimension dimension) {
        this.conformedDimension = dimension;
    }

    @Override
    public UpsertStringBuilder getUpsertBuilder() {
        Identifier factId = this.isConformed ? null : this.fact.id;
        UpsertStringBuilder builder = new UpsertStringBuilder();
        if (this.conformedDimension == null) {
            builder = super.getUpsert().withIdCol("facttable_id", factId).withStringCol("joincolumn", this.factColumn).withStringCol("alias", this.alias).withStringCol("is_hierarchy", String.valueOf(this.isHierarchy)).withStringCol("is_historical", String.valueOf(this.isHistorical)).withStringCol("tablename", this.dimension).withStringCol("id_column", this.idColumn).withIntCol("position", this.position).withStringCol("is_hidden", String.valueOf(this.isHidden));
        } else {
            builder = new UpsertStringBuilder().forTable("metadata", this.sourceTable).withStringCol("namespace", this.namespace).withIdCol("id", this.id).withStringCol("default_release", this.defaultRelease);
            builder = builder.withIdCol("facttable_id", factId);
            builder = this.idColumn != null && !this.idColumn.isBlank() ? builder.withStringCol("id_column", this.idColumn) : builder.withStringCol("id_column", this.conformedDimension.getIdColumn());
            builder = this.position != null ? builder.withIntCol("position", this.position) : builder.withIntCol("position", this.conformedDimension.getPosition());
            builder = this.caption != null && !this.caption.isBlank() ? builder.withStringCol("caption", this.caption) : builder.withStringCol("caption", this.conformedDimension.getCaption());
            builder = this.factColumn != null && !this.factColumn.isBlank() ? builder.withStringCol("joincolumn", this.factColumn) : builder.withStringCol("joincolumn", this.conformedDimension.getFactColumn());
            builder = this.alias != null && !this.factColumn.isBlank() ? builder.withStringCol("alias", this.alias) : builder.withStringCol("alias", this.conformedDimension.getAlias());
            builder = this.isHidden ? builder.withStringCol("is_hidden", String.valueOf(this.isHidden)) : builder.withStringCol("is_hidden", String.valueOf(this.conformedDimension.isHidden));
            builder = this.isHierarchy ? builder.withStringCol("is_hierarchy", String.valueOf(this.isHierarchy)) : builder.withStringCol("is_hierarchy", String.valueOf(this.conformedDimension.isHierarchy));
            builder = this.isHistorical ? builder.withStringCol("is_historical", String.valueOf(this.isHistorical)) : builder.withStringCol("is_historical", String.valueOf(this.conformedDimension.isHistorical));
            builder = this.conformedDimension.getDimension() != null && !this.conformedDimension.getDimension().isBlank() ? (this.view != null && !this.view.isBlank() ? builder.withStringCol("tablename", this.view) : builder.withStringCol("tablename", this.conformedDimension.getDimension())) : builder.withStringCol("tablename", this.dimension);
            builder = builder.withIdCol("conformed", this.conformedDimension.id);
        }
        builder = this.description != null && !this.description.isBlank() ? builder.withStringCol("description", this.description) : (this.conformedDimension != null ? builder.withStringCol("description", this.conformedDimension.getDescription()) : builder.withStringCol("description", ""));
        return builder;
    }

    public Integer getPosition() {
        return this.position;
    }

    public void setPosition(Integer position) {
        this.position = position;
    }

    public String getRefTo() {
        return this.refTo;
    }

    public void setRefTo(String refTo) {
        this.refTo = refTo;
    }

    public String getDimension() {
        return this.dimension;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public List<MetaDimensionAttribute> getAttributes() {
        if (this.attributes == null) {
            return new ArrayList<MetaDimensionAttribute>();
        }
        return this.attributes;
    }

    public void setAttributes(List<MetaDimensionAttribute> attributes) {
        for (MetaDimensionAttribute metaDimensionAttribute : attributes) {
            metaDimensionAttribute.setDimension(this);
        }
        this.attributes = attributes;
    }

    public MetaFact getFact() {
        return this.fact;
    }

    public void setFact(MetaFact fact) {
        this.fact = fact;
    }

    @JsonIgnore
    public boolean isConformed() {
        return this.isConformed;
    }

    @JsonIgnore
    public void setConformed(boolean isConformed) {
        this.isConformed = isConformed;
    }

    public MetaDimension getConformedDimension() {
        return this.conformedDimension;
    }

    public String getFactColumn() {
        return this.factColumn;
    }

    public void setFactColumn(String factColumn) {
        this.factColumn = factColumn;
    }

    public void addAttribute(MetaDimensionAttribute metaDimensionAttribute) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<MetaDimensionAttribute>();
        }
        this.attributes.add(metaDimensionAttribute);
    }

    @Override
    @JsonIgnore
    public String getDocIdentifier() {
        if (this.conformedDimension != null) {
            return this.conformedDimension.getDocIdentifier();
        }
        return this.dimension;
    }

    @JsonIgnore
    public boolean isHierarchy() {
        return this.isHierarchy;
    }

    @JsonIgnore
    public void setHierarchy(boolean isHierarchy) {
        this.isHierarchy = isHierarchy;
    }

    @JsonIgnore
    public boolean isHistorical() {
        return this.isHistorical;
    }

    @JsonIgnore
    public void setHistorical(boolean isHistorical) {
        this.isHistorical = isHistorical;
    }

    public String getView() {
        return this.view;
    }

    public void setView(String view) {
        this.view = view;
    }

    public String getIdColumn() {
        return this.idColumn;
    }

    public void setIdColumn(String idColumn) {
        this.idColumn = idColumn;
    }

    public String getAttributesSql() {
        return this.attributesSql;
    }

    public void setAttributesSql(String attributesSql) {
        this.attributesSql = attributesSql;
    }

    @JsonIgnore
    public boolean isHidden() {
        return this.isHidden;
    }

    @JsonIgnore
    public void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }
}

