/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.metadata;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.superx.bianalysis.metadata.Identifier;
import de.superx.bianalysis.models.CriteriaGroup;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.StringJoiner;

public class UpsertStringBuilder {
    LinkedHashMap<String, String> columns = new LinkedHashMap();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private String schema;
    private String tablename;
    private List<UpsertStringBuilder> builders = new ArrayList<UpsertStringBuilder>();

    public void addUpsertStringBuilder(UpsertStringBuilder builder) {
        this.builders.add(builder);
    }

    public UpsertStringBuilder forTable(String schema, String tablename) {
        this.tablename = tablename;
        this.schema = schema;
        return this;
    }

    public UpsertStringBuilder withCriteriaGroup(String colName, List<CriteriaGroup> groups) {
        if (groups == null || groups.isEmpty()) {
            this.columns.remove(colName);
            this.columns.put(colName, "NULL");
            return this;
        }
        try {
            String json = this.objectMapper.writeValueAsString(groups);
            this.columns.put(colName, "'" + json + "'::jsonb");
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Failed to serialize CriteriaGroup list to JSON", e);
        }
        return this;
    }

    public UpsertStringBuilder withStringCol(String colName, String value) {
        Object actualVal = value;
        actualVal = value == null ? "null" : "'" + value + "'";
        if (this.columns.containsKey(colName)) {
            this.columns.remove(colName);
        }
        this.columns.put(colName, (String)actualVal);
        return this;
    }

    public UpsertStringBuilder withStringCol(String colName, Object value) {
        if (value != null) {
            return this.withStringCol(colName, value.toString());
        }
        return this.withStringCol(colName, "unknown");
    }

    public UpsertStringBuilder withStringCol(String colName, String value, String defaultVal) {
        if (value != null) {
            return this.withStringCol(colName, value);
        }
        return this.withStringCol(colName, defaultVal);
    }

    public UpsertStringBuilder withStringCol(String colName, Object value, Object defaultVal) {
        if (value != null) {
            return this.withStringCol(colName, value);
        }
        return this.withStringCol(colName, defaultVal);
    }

    public UpsertStringBuilder withIntCol(String colName, Integer value) {
        this.columns.put(colName, String.valueOf(value));
        return this;
    }

    public UpsertStringBuilder withIdCol(String colName, Identifier id) {
        if (id != null) {
            return this.withStringCol(colName, id.composedId);
        }
        return this.withStringCol(colName, null);
    }

    public String build(boolean hasOnConflictConstruct) {
        StringJoiner cols = new StringJoiner(", ");
        StringJoiner values = new StringJoiner(", ");
        StringJoiner onConflict = new StringJoiner(", ");
        for (String column : this.columns.keySet()) {
            cols.add(column);
            onConflict.add(String.format("%s = EXCLUDED.%s", column, column));
            values.add(this.columns.get(column));
        }
        Object result = "INSERT INTO %s.%s(%s) VALUES(%s)";
        result = String.format((String)result, this.schema, this.tablename, cols, values);
        if (hasOnConflictConstruct) {
            result = (String)result + " ON CONFLICT(id) DO NOTHING";
        }
        result = (String)result + ";\n";
        if (this.builders.size() > 0) {
            for (UpsertStringBuilder upsertStringBuilder : this.builders) {
                result = (String)result + upsertStringBuilder.build(hasOnConflictConstruct);
            }
        }
        return result;
    }
}

