/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.superx.bianalysis.metadata.IdentifierSerializer;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

@JsonSerialize(using=IdentifierSerializer.class)
public class Identifier {
    private static final String ID_SEPARATOR = ":";
    @JsonIgnore
    public Integer value;
    @JsonIgnore
    public String namespace;
    public String composedId;

    public Identifier(String composedId) {
        if (composedId == null || composedId.isBlank()) {
            return;
        }
        this.composedId = composedId;
        String[] result = composedId.split(ID_SEPARATOR);
        this.namespace = result[0];
        this.value = Integer.valueOf(result[1]);
    }

    public Identifier(Identifier id) {
        this.value = id.value;
        this.namespace = id.namespace;
        this.composedId = id.composedId;
    }

    @JsonIgnore
    public static Identifier getNewIdentifierValue(List<Identifier> list, String namespace) {
        List values = list.stream().filter(i -> i.value != null).map(i -> i.value).collect(Collectors.toList());
        Integer value = values.isEmpty() ? Integer.valueOf(1) : Integer.valueOf((Integer)Collections.max(values) + 1);
        return new Identifier(namespace + ID_SEPARATOR + value);
    }

    @JsonIgnore
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Identifier)) {
            return false;
        }
        Identifier id = (Identifier)obj;
        return id.composedId.equals(this.composedId);
    }

    @JsonIgnore
    public int hashCode() {
        return this.value.hashCode() + this.namespace.hashCode();
    }

    public String toString() {
        return this.composedId;
    }
}

