/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.widgets;

import de.memtext.util.DateUtils;
import de.memtext.widgets.TextUnselectableDec;
import de.memtext.widgets.UnicodeReplacerDocument;
import de.memtext.widgets.WarningMessage;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.sql.Date;
import java.text.ParseException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.Keymap;

public class LabeledTextField
extends JPanel {
    private WarningMessage wa = new WarningMessage(this, "Ung\u00fcltige Eingabe");
    JTextField textField;
    private JLabel lbl;

    public LabeledTextField() {
        this("", "", 30);
    }

    public LabeledTextField(String lblText) {
        this(lblText, "", 30);
    }

    public LabeledTextField(String lblText, int length) {
        this(lblText, "", length);
    }

    public LabeledTextField(String lblText, Object value) {
        this(lblText, value, 30);
    }

    public void setLabelFont(Font f) {
        this.lbl.setFont(f);
    }

    public LabeledTextField(String lblText, Object value, int length) {
        this.setLayout(new FlowLayout(0));
        this.setBackground(null);
        this.setName("lblTextField-" + lblText);
        this.lbl = new JLabel(lblText, 0);
        this.initTextField(length);
        this.textField.setBackground(null);
        this.textField.setName("tf-" + lblText);
        if (value == null) {
            value = "";
        }
        this.textField.setText(value.toString());
        this.add(this.lbl);
        this.add(this.textField);
    }

    void initTextField(int length) {
        this.textField = new JTextField(length);
    }

    public Object getValue() {
        return this.textField.getText();
    }

    public boolean isEmpty() {
        return this.textField.getText().length() == 0;
    }

    public void setTextField(JTextField textField) {
        this.textField = textField;
    }

    public void setValue(Object value) {
        if (value == null) {
            value = "";
        }
        this.textField.setText(value.toString());
    }

    public int getPreferredLabelWidth() {
        return this.lbl.getPreferredSize().width;
    }

    public void setDocument(Document document) {
        this.textField.setDocument(document);
    }

    public void activateUnicodeReplacements() {
        String rememberText = this.textField.getText();
        this.textField.setDocument(new UnicodeReplacerDocument());
        this.textField.setText(rememberText);
    }

    public void setHorizontalLabelAlignment(int alignment) {
        this.lbl.setHorizontalAlignment(alignment);
    }

    @Override
    public void requestFocus() {
        this.textField.requestFocus();
    }

    @Override
    public void setFocusable(boolean b) {
        super.setFocusable(b);
        this.textField.setFocusable(b);
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.textField.requestFocusInWindow();
    }

    @Override
    public String toString() {
        return "value: " + this.textField.getText();
    }

    public void clear() {
        this.textField.setText("");
    }

    public void setPreferredLabelWidth(int maxLabelLength) {
        Dimension dim = this.lbl.getPreferredSize();
        dim.width = maxLabelLength;
        this.lbl.setPreferredSize(dim);
    }

    public void setEditable(boolean b) {
        this.textField.setEditable(b);
    }

    @Override
    public void setEnabled(boolean b) {
        this.textField.setEnabled(b);
    }

    public void showWarningMessage() {
        this.wa.show();
    }

    public boolean isIntegerValue() {
        boolean result = true;
        if (!this.textField.getText().equals("")) {
            try {
                int in = Integer.parseInt(this.textField.getText());
                result = true;
            }
            catch (NumberFormatException e) {
                result = false;
            }
        }
        return result;
    }

    public Integer getIntegerValue() {
        Integer result = null;
        if (!this.textField.getText().equals("")) {
            result = Integer.parseInt(this.textField.getText());
        }
        return result;
    }

    public boolean isDateOk() {
        return DateUtils.isValidDateStrict(this.getValue().toString());
    }

    public Date getDateValue() {
        Date result = null;
        try {
            result = DateUtils.parse(this.getValue().toString());
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new RuntimeException("rums");
        }
        return result;
    }

    public void makeUnselectable() {
        TextUnselectableDec dec = new TextUnselectableDec();
        dec.makeUnselectable(this.textField);
    }

    public String getText() {
        return this.textField.getText();
    }

    public Keymap getKeymap() {
        return this.textField.getKeymap();
    }

    public void addDocumentListener(DocumentListener listener) {
        this.textField.getDocument().addDocumentListener(listener);
    }

    public boolean isDateInFuture() throws ParseException {
        return DateUtils.isDateInFuture(DateUtils.parse(this.getValue().toString()));
    }
}

