/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.util;

import de.superx.util.saxon.extensions.DateTodayString;
import de.superx.util.saxon.extensions.Headers2Html;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.s9api.ExtensionFunction;
import net.sf.saxon.s9api.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransletUtils {
    private static TransformerFactory tFactory;
    private static String usedProcessor;

    private TransletUtils() {
    }

    public static synchronized void initFactory() {
        tFactory = TransformerFactory.newInstance();
        tFactory.setErrorListener(new SuperxTransformerErrorListener());
    }

    public static synchronized void initFactory(String preferredParser, String secondaryParser) {
        try {
            tFactory = TransformerFactory.newInstance(preferredParser, null);
            usedProcessor = preferredParser;
            TransformerFactoryImpl tFactoryImpl = (TransformerFactoryImpl)tFactory;
            Configuration saxonConfig = tFactoryImpl.getConfiguration();
            Processor processor = (Processor)saxonConfig.getProcessor();
            Headers2Html headers2html = new Headers2Html();
            DateTodayString dateTodayString = new DateTodayString();
            processor.registerExtensionFunction((ExtensionFunction)headers2html);
            processor.registerExtensionFunction((ExtensionFunction)dateTodayString);
        }
        catch (TransformerFactoryConfigurationError e) {
            if (secondaryParser != null) {
                try {
                    tFactory = TransformerFactory.newInstance(secondaryParser, null);
                    usedProcessor = secondaryParser;
                }
                catch (TransformerFactoryConfigurationError e2) {
                    System.err.println("Weder " + preferredParser + " noch " + secondaryParser + " gefunden");
                    e2.printStackTrace();
                }
            }
            e.printStackTrace();
            throw new IllegalStateException("Kein XML  Parser " + String.valueOf(e));
        }
        if (tFactory != null) {
            tFactory.setErrorListener(new SuperxTransformerErrorListener());
        }
    }

    public static synchronized Templates createTemplate(String xslInURI) throws TransformerConfigurationException {
        if (tFactory == null) {
            TransletUtils.initFactory("net.sf.saxon.TransformerFactoryImpl", "org.apache.xalan.xsltc.trax.TransformerFactoryImpl");
        }
        StreamSource strsrc = new StreamSource(xslInURI);
        return tFactory.newTemplates(strsrc);
    }

    public static void main(String[] args) {
        System.out.println("javax.xml.transform.TransformerFactory was " + System.getProperty("javax.xml.transform.TransformerFactory"));
        System.getProperties().remove("javax.xml.transform.TransformerFactory");
        System.out.println("after unsetting " + System.getProperty("javax.xml.transform.TransformerFactory"));
    }

    public static String getUsedProcessor() {
        return usedProcessor;
    }

    static {
        usedProcessor = null;
    }

    static class SuperxTransformerErrorListener
    implements ErrorListener {
        private static Logger logger = LoggerFactory.getLogger(TransletUtils.class);

        SuperxTransformerErrorListener() {
        }

        @Override
        public void warning(TransformerException exception) throws TransformerException {
            logger.warn("Problem in xsl transform: {}", (Object)exception.getMessageAndLocation());
        }

        @Override
        public void error(TransformerException exception) throws TransformerException {
            logger.error("Error in xsl transform: {}", (Object)exception.getMessageAndLocation());
        }

        @Override
        public void fatalError(TransformerException exception) throws TransformerException {
            logger.error("Fatal error in xsl transform: {}", (Object)exception.getMessageAndLocation());
        }
    }
}

