/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.tree.admin;

import de.memtext.db.DBAccess;
import de.memtext.tree.admin.AdminTreeModel;
import de.memtext.tree.admin.Status;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public class ExitAction
extends AbstractAction
implements Observer {
    private AdminTreeModel model;
    private boolean isSaveNecessary;

    public ExitAction(AdminTreeModel model) {
        if (model == null) {
            throw new RuntimeException("Model must not be null!");
        }
        this.model = model;
        this.isSaveNecessary = false;
    }

    public ExitAction(String name, AdminTreeModel model) {
        super(name);
        if (model == null) {
            throw new RuntimeException("Model must not be null!");
        }
        this.model = model;
        this.isSaveNecessary = false;
    }

    public ExitAction(String name, Icon icon, AdminTreeModel model) {
        super(name, icon);
        if (model == null) {
            throw new RuntimeException("Model must not be null!");
        }
        this.model = model;
        this.isSaveNecessary = false;
    }

    @Override
    public void actionPerformed(ActionEvent arg1) {
        int result;
        if (this.isSaveNecessary && (result = JOptionPane.showConfirmDialog(null, "\u00c4nderungen sind noch nicht gespeichert. Wirklich beenden?", "Frage", 0)) == 1) {
            return;
        }
        try {
            DBAccess.get("RecursiveTableAdmin").closeConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof Status) {
            this.isSaveNecessary = ((Status)o).isSaveNecessary();
        }
    }
}

