/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.db;

import de.memtext.db.DbRequest;
import de.memtext.db.DbResponse;
import de.memtext.db.DbServerI;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.util.List;

public class DbRmiClient {
    private DbServerI dbServerI = null;
    String name = "DbServer";

    public DbRmiClient() {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            this.dbServerI = (DbServerI)Naming.lookup(this.name);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (NotBoundException e) {
            e.printStackTrace();
        }
    }

    public void test() {
        this.testUpdate();
        this.testQuery();
    }

    private void testUpdate() {
        try {
            DbRequest dbRequest = new DbRequest("update dummy set col2=99");
            DbResponse dbResponse = this.dbServerI.execute(dbRequest);
            if (dbResponse.isOK()) {
                System.out.println("OK - updated rows :" + dbResponse.getUpdatedRowsCount());
            } else {
                System.out.println("failed :" + String.valueOf(dbResponse.getException()));
            }
        }
        catch (Exception e) {
            System.out.println(" exception: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void testQuery() {
        try {
            DbRequest dbRequest = new DbRequest("select * from dummy");
            DbResponse dbResponse = this.dbServerI.executeQuery("select * from dummy");
            if (dbResponse.isOK()) {
                System.out.println("OK");
                List result = (List)dbResponse.getResult();
                System.out.println("rows:" + result.size());
                int i = 0;
                for (List row : result) {
                    System.out.print("row " + ++i + " ");
                    for (Object o : row) {
                        System.out.print(" - " + String.valueOf(o));
                    }
                    System.out.println("");
                }
            } else {
                System.out.println("failed :" + String.valueOf(dbResponse.getException()));
            }
        }
        catch (Exception e) {
            System.out.println(" exception: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void main(String[] a) {
        DbRmiClient c = new DbRmiClient();
        c.test();
    }
}

