/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.mapping.item.assignment;

import de.werum.sis.mapping.item.assignment.InvalidAssignmentDataException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class AssignmentStore {
    protected Map rightToLeft_ = null;
    protected Map leftToRight_ = null;
    protected Map assignmentValue_ = null;

    public AssignmentStore() {
        this.leftToRight_ = new HashMap();
        this.rightToLeft_ = new HashMap();
        this.assignmentValue_ = new HashMap();
    }

    public AssignmentStore(AssignmentStore assignment) throws InvalidAssignmentDataException {
        this.leftToRight_ = assignment.getLeftToRight() != null ? new TreeMap(assignment.getLeftToRight()) : new TreeMap();
        this.rightToLeft_ = assignment.getRightToLeft() != null ? new TreeMap(assignment.getRightToLeft()) : new TreeMap();
        this.assignmentValue_ = assignment.getAssignmentValue() != null ? new TreeMap(assignment.getAssignmentValue()) : new TreeMap();
    }

    protected void remove(Object key, Object value, Map map) {
        List m_value = null;
        if (map.containsKey(key)) {
            m_value = (List)map.get(key);
        }
        if (m_value != null && m_value.contains(value)) {
            m_value.remove(value);
            if (m_value.size() == 0) {
                map.remove(key);
            }
        }
    }

    protected void put(String key, Object value, Map map) {
        List m_value = null;
        m_value = map.containsKey(key) ? (List)map.get(key) : new ArrayList();
        if (m_value != null && !m_value.contains(value)) {
            m_value.add(value);
            map.put(key, m_value);
        }
    }

    protected Object getValue(String key, Map map) {
        if (this.containsKey(key, map)) {
            return map.get(key);
        }
        return null;
    }

    protected boolean containsKey(String key, Map map) {
        return map.containsKey(key);
    }

    protected Map getAssignmentValue() {
        return this.assignmentValue_;
    }

    protected Map getRightToLeft() {
        return this.rightToLeft_;
    }

    protected Map getLeftToRight() {
        return this.leftToRight_;
    }

    public Set getAllKeysOnLeftSide() {
        if (this.getLeftToRight() != null) {
            return this.getLeftToRight().keySet();
        }
        return null;
    }

    public Set getAllKeysOnRightSide() {
        if (this.getRightToLeft() != null) {
            return this.getRightToLeft().keySet();
        }
        return null;
    }
}

