/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.mapping.display;

import de.werum.sis.mapping.debug.Logger;
import de.werum.sis.mapping.display.helper.MappingJTreeDisplayHelper;
import de.werum.sis.mapping.item.mappingelement.MappingElementLink;
import de.werum.sis.mapping.item.mappingelement.MappingElementObject;
import de.werum.sis.mapping.util.PointXY;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class AssignmentJPanel
extends JPanel {
    private static final long serialVersionUID = 3257002142446335795L;
    private MappingJTreeDisplayHelper mappingJTDH_ = null;
    private Map popupMenuActionHelper_ = null;
    final Runnable runrepaint = new Runnable(){

        public void run() {
            AssignmentJPanel.this.repaint();
        }
    };

    public AssignmentJPanel(MappingJTreeDisplayHelper mappingJTreeDisplayHelper) {
        this.mappingJTDH_ = mappingJTreeDisplayHelper;
        this.addMouseListener(new AssignmentMouseListener());
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.mappingJTDH_.setAssignmentWidth(this.getWidth());
        this.mappingJTDH_.paintAssignments(g);
        this.mappingJTDH_.paintAnchors(g);
    }

    public MappingJTreeDisplayHelper getMappingJTreeDisplayHelper() {
        return this.mappingJTDH_;
    }

    private JMenuItem buildRemoveMenuItem(String actioncommand) {
        JMenuItem _menuItem = new JMenuItem("L\u00f6schen");
        _menuItem.setActionCommand(actioncommand);
        _menuItem.addActionListener(new RemoveAssignmentActionListener());
        return _menuItem;
    }

    private JMenuItem buildChangeRuleMenuItem(String actioncommand) {
        JMenuItem _menuItem = new JMenuItem("Bearbeiten");
        _menuItem.setActionCommand(actioncommand);
        _menuItem.addActionListener(new ChangeAssignmentRuleActionListener());
        return _menuItem;
    }

    protected class ChangeAssignmentRuleActionListener
    implements ActionListener {
        protected ChangeAssignmentRuleActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            MappingElementLink element;
            Logger.getInstance().debug("--actionPerformed", " Change - A c t i o n " + e.getActionCommand());
            if (e.getActionCommand() != null && AssignmentJPanel.this.popupMenuActionHelper_ != null && AssignmentJPanel.this.popupMenuActionHelper_.containsKey(e.getActionCommand()) && (element = (MappingElementLink)AssignmentJPanel.this.popupMenuActionHelper_.get(e.getActionCommand())) != null && AssignmentJPanel.this.mappingJTDH_.getMapping() != null && AssignmentJPanel.this.mappingJTDH_.getMapping().getMapMaker() != null) {
                AssignmentJPanel.this.mappingJTDH_.getMapping().getMapMaker().editLink(element);
            }
        }
    }

    protected class RemoveAssignmentActionListener
    implements ActionListener {
        protected RemoveAssignmentActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Logger.getInstance().debug("--actionPerformed", " Remove - A c t i o n " + e.getActionCommand());
            if (e.getActionCommand() != null && AssignmentJPanel.this.popupMenuActionHelper_ != null && AssignmentJPanel.this.popupMenuActionHelper_.containsKey(e.getActionCommand())) {
                MappingElementLink element = (MappingElementLink)AssignmentJPanel.this.popupMenuActionHelper_.get(e.getActionCommand());
                if (AssignmentJPanel.this.getMappingJTreeDisplayHelper().getMapping().getMapMaker() != null) {
                    if (AssignmentJPanel.this.getMappingJTreeDisplayHelper().getMapping().getMapMaker().canDelete(element)) {
                        AssignmentJPanel.this.getMappingJTreeDisplayHelper().getMapping().getMapMaker().deleteLink(element);
                    } else {
                        element = null;
                    }
                }
                if (element != null) {
                    AssignmentJPanel.this.getMappingJTreeDisplayHelper().getMapping().getAssignment().remove(element.getLeftKey(), element.getRightKey());
                    AssignmentJPanel.this.getMappingJTreeDisplayHelper().setRefreshAssignmentCoordinates(true);
                    AssignmentJPanel.this.repaint();
                }
            }
        }
    }

    protected class AssignmentMouseListener
    implements MouseListener {
        protected AssignmentMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            List _assignmentlist;
            if (SwingUtilities.isRightMouseButton(e) && (_assignmentlist = AssignmentJPanel.this.getMappingJTreeDisplayHelper().getAssignment(new PointXY(e.getX(), e.getY()), 5)) != null && _assignmentlist.size() > 0) {
                AssignmentJPanel.this.popupMenuActionHelper_ = new HashMap();
                JPopupMenu _mainMPU = null;
                JMenu _subMPU = null;
                if (_assignmentlist.size() > 1) {
                    _mainMPU = new JPopupMenu();
                    Iterator _assignmentiterator = _assignmentlist.iterator();
                    while (_assignmentiterator.hasNext()) {
                        MappingElementLink _assignment = (MappingElementLink)_assignmentiterator.next();
                        AssignmentJPanel.this.popupMenuActionHelper_.put(_assignment.toString(), _assignment);
                        _subMPU = new JMenu(((MappingElementObject)AssignmentJPanel.this.getMappingJTreeDisplayHelper().getMapping().getLeft().get(_assignment.getLeftKey())).getDisplayName() + " : " + ((MappingElementObject)AssignmentJPanel.this.getMappingJTreeDisplayHelper().getMapping().getRight().get(_assignment.getRightKey())).getDisplayName());
                        _subMPU.add(AssignmentJPanel.this.buildChangeRuleMenuItem(_assignment.toString()));
                        _subMPU.add(AssignmentJPanel.this.buildRemoveMenuItem(_assignment.toString()));
                        _mainMPU.add(_subMPU);
                    }
                } else {
                    MappingElementLink _assignment = (MappingElementLink)_assignmentlist.get(0);
                    AssignmentJPanel.this.popupMenuActionHelper_.put(_assignment.toString(), _assignment);
                    _mainMPU = new JPopupMenu(((MappingElementObject)AssignmentJPanel.this.getMappingJTreeDisplayHelper().getMapping().getLeft().get(_assignment.getLeftKey())).getDisplayName() + " : " + ((MappingElementObject)AssignmentJPanel.this.getMappingJTreeDisplayHelper().getMapping().getRight().get(_assignment.getRightKey())).getDisplayName());
                    _mainMPU.add(AssignmentJPanel.this.buildChangeRuleMenuItem(_assignment.toString()));
                    _mainMPU.add(AssignmentJPanel.this.buildRemoveMenuItem(_assignment.toString()));
                }
                _mainMPU.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }
}

