/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.rest.resources;

import com.qmino.miredot.annotations.ReturnType;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.saiku.service.ISessionService;
import org.saiku.service.user.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Path(value="/saiku/session")
public class SessionResource {
    private static final Logger log = LoggerFactory.getLogger(SessionResource.class);
    private ISessionService sessionService;
    private UserService userService;

    public ISessionService getSessionService() {
        return this.sessionService;
    }

    public void setSessionService(ISessionService ss) {
        this.sessionService = ss;
    }

    public void setUserService(UserService us) {
        this.userService = us;
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response login(@Context HttpServletRequest req, @FormParam(value="username") String username, @FormParam(value="password") String password) {
        try {
            this.sessionService.login(req, username, password);
            return Response.ok().build();
        }
        catch (Exception e) {
            log.debug("Error logging in:" + username, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getLocalizedMessage()).build();
        }
    }

    @POST
    @Path(value="/clear")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response clearSession(@Context HttpServletRequest req, @FormParam(value="username") String username, @FormParam(value="password") String password) {
        try {
            this.sessionService.clearSessions(req, username, password);
            return Response.ok((Object)"Session cleared").build();
        }
        catch (Exception e) {
            log.debug("Error clearing sessions for:" + username, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getLocalizedMessage()).build();
        }
    }

    @GET
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @ReturnType(value="java.util.Map<String, Object>")
    public Response getSession(@Context HttpServletRequest req) {
        Map sess = null;
        try {
            sess = this.sessionService.getSession();
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)e.getLocalizedMessage()).build();
        }
        try {
            String acceptLanguage = req.getLocale().getLanguage();
            if (StringUtils.isNotBlank((String)acceptLanguage)) {
                sess.put("language", acceptLanguage);
            }
        }
        catch (Exception e) {
            log.debug("Cannot get language!", (Throwable)e);
        }
        try {
            sess.put("isadmin", this.userService.isAdmin());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.userService.checkFolders();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Response.ok().entity((Object)sess).build();
    }

    @DELETE
    public Response logout(@Context HttpServletRequest req) {
        this.sessionService.logout(req);
        return Response.ok().build();
    }
}

