/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.rest.resources;

import com.qmino.miredot.annotations.ReturnType;
import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataParam;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.jcr.RepositoryException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;
import org.saiku.database.dto.MondrianSchema;
import org.saiku.database.dto.SaikuUser;
import org.saiku.datasources.datasource.SaikuDatasource;
import org.saiku.log.LogExtractor;
import org.saiku.service.datasource.DatasourceService;
import org.saiku.service.datasource.IDatasourceManager;
import org.saiku.service.olap.OlapDiscoverService;
import org.saiku.service.user.UserService;
import org.saiku.service.util.exception.SaikuDataSourceException;
import org.saiku.service.util.exception.SaikuServiceException;
import org.saiku.web.rest.objects.DataSourceMapper;
import org.saiku.web.rest.resources.DataSourceResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Path(value="/saiku/admin")
public class AdminResource {
    private DatasourceService datasourceService;
    private UserService userService;
    private static final Logger log = LoggerFactory.getLogger(DataSourceResource.class);
    private OlapDiscoverService olapDiscoverService;
    private LogExtractor logExtractor;
    private IDatasourceManager repositoryDatasourceManager;

    public LogExtractor getLogExtractor() {
        return this.logExtractor;
    }

    public void setLogExtractor(LogExtractor logExtractor) {
        this.logExtractor = logExtractor;
    }

    public void setOlapDiscoverService(OlapDiscoverService olapDiscoverService) {
        this.olapDiscoverService = olapDiscoverService;
    }

    public void setDatasourceService(DatasourceService ds) {
        this.datasourceService = ds;
    }

    public void setUserService(UserService us) {
        this.userService = us;
    }

    public IDatasourceManager getRepositoryDatasourceManager() {
        return this.repositoryDatasourceManager;
    }

    public void setRepositoryDatasourceManager(IDatasourceManager repositoryDatasourceManager) {
        this.repositoryDatasourceManager = repositoryDatasourceManager;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/datasources")
    @ReturnType(value="java.lang.List<SaikuDatasource>")
    public Response getAvailableDataSources() {
        if (!this.userService.isAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ArrayList<DataSourceMapper> l = new ArrayList<DataSourceMapper>();
        try {
            for (SaikuDatasource d : this.datasourceService.getDatasources(this.userService.getCurrentUserRoles()).values()) {
                l.add(new DataSourceMapper(d));
            }
            return Response.ok().entity(l).build();
        }
        catch (SaikuServiceException e) {
            log.error(this.getClass().getName(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getLocalizedMessage()).type("text/plain").build();
        }
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/datasources/{id}")
    @ReturnType(value="org.saiku.web.rest.objects.DataSourceMapper")
    public Response updateDatasource(DataSourceMapper json, @PathParam(value="id") String id) {
        if (!this.userService.isAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        try {
            this.datasourceService.addDatasource(json.toSaikuDataSource(), true, this.userService.getCurrentUserRoles());
            return Response.ok().type("application/json").entity((Object)json).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getLocalizedMessage()).type("text/plain").build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/datasources/{id}/refresh")
    @ReturnType(value="java.util.List<SaikuConnection>")
    public Response refreshDatasource(@PathParam(value="id") String id) {
        if (!this.userService.isAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        try {
            this.olapDiscoverService.refreshConnection(id);
            return Response.ok().entity((Object)this.olapDiscoverService.getConnection(id)).type("application/json").build();
        }
        catch (Exception e) {
            log.error(this.getClass().getName(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getLocalizedMessage()).type("text/plain").build();
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/datasources")
    @ReturnType(value="org.saiku.web.rest.objects.DataSourceMapper")
    public Response createDatasource(DataSourceMapper json) {
        if (!this.userService.isAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        try {
            this.datasourceService.addDatasource(json.toSaikuDataSource(), false, this.userService.getCurrentUserRoles());
            return Response.ok().entity((Object)json).type("application/json").build();
        }
        catch (Exception e) {
            log.error("Error adding data source", (Throwable)e);
            return Response.serverError().status(Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getLocalizedMessage()).type("text/plain").build();
        }
    }

    @DELETE
    @Path(value="/datasources/{id}")
    public Response deleteDatasource(@PathParam(value="id") String id) {
        if (!this.userService.isAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.datasourceService.removeDatasource(id);
        return Response.ok().type("application/json").entity((Object)this.datasourceService.getDatasources(this.userService.getCurrentUserRoles())).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/schema")
    @ReturnType(value="java.util.List<MondrianSchema>")
    public Response getAvailableSchema() {
        if (!this.userService.isAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return Response.ok().entity((Object)this.datasourceService.getAvailableSchema()).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    @Path(value="/schema/{id}")
    @ReturnType(value="java.util.List<MondrianSchema>")
    public Response uploadSchemaPut(@FormDataParam(value="file") InputStream is, @FormDataParam(value="file") FormDataContentDisposition detail, @FormDataParam(value="name") String name, @PathParam(value="id") String id) {
        if (!this.userService.isAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        String path = "/datasources/" + name + ".xml";
        String schema = AdminResource.getStringFromInputStream(is);
        try {
            this.datasourceService.addSchema(schema, path, name);
            return Response.ok().entity((Object)this.datasourceService.getAvailableSchema()).build();
        }
        catch (Exception e) {
            log.error("Error uploading schema: " + name, (Throwable)e);
            return Response.serverError().status(Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getLocalizedMessage()).type("text/plain").build();
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    @Path(value="/schema/{id}")
    @ReturnType(value="java.util.List<MondrianSchema>")
    public Response uploadSchema(@FormDataParam(value="file") InputStream is, @FormDataParam(value="file") FormDataContentDisposition detail, @FormDataParam(value="name") String name, @PathParam(value="id") String id) {
        if (!this.userService.isAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        String path = "/datasources/" + name + ".xml";
        String schema = AdminResource.getStringFromInputStream(is);
        try {
            this.datasourceService.addSchema(schema, path, name);
            return Response.ok().entity((Object)this.datasourceService.getAvailableSchema()).build();
        }
        catch (Exception e) {
            log.error("Error uploading schema: " + name, (Throwable)e);
            return Response.serverError().status(Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getLocalizedMessage()).type("text/plain").build();
        }
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/datasources/{datasourceName}/locale")
    @ReturnType(value="org.saiku.web.rest.objects.DataSourceMapper")
    public Response updateDatasourceLocale(String locale, @PathParam(value="datasourceName") String datasourceName) {
        try {
            boolean overwrite = true;
            SaikuDatasource saikuDatasource = this.datasourceService.getDatasource(datasourceName);
            this.datasourceService.setLocaleOfDataSource(saikuDatasource, locale);
            this.datasourceService.addDatasource(saikuDatasource, overwrite, this.userService.getCurrentUserRoles());
            return Response.ok().type("application/json").entity((Object)new DataSourceMapper(saikuDatasource)).build();
        }
        catch (SaikuDataSourceException e) {
            return Response.ok().type("application/json").entity((Object)e.getLocalizedMessage()).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getLocalizedMessage()).type("text/plain").build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/users")
    @ReturnType(value="java.util.List<SaikuUser>")
    public Response getExistingUsers() {
        if (!this.userService.isAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return Response.ok().entity((Object)this.userService.getUsers()).build();
    }

    @DELETE
    @Path(value="/schema/{id}")
    @ReturnType(value="java.util.List<MondrianSchema>")
    public Response deleteSchema(@PathParam(value="id") String id) {
        if (!this.userService.isAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.datasourceService.removeSchema(id);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).entity((Object)this.datasourceService.getAvailableSchema()).build();
    }

    @GET
    @Path(value="/schema/{id}")
    @Produces(value={"application/xml"})
    @ReturnType(value="MondrianSchema")
    public Response getSavedSchema(@PathParam(value="id") String id) {
        if (!this.userService.isAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        String p = "";
        for (MondrianSchema s : this.datasourceService.getAvailableSchema()) {
            if (!s.getName().equals(id)) continue;
            try {
                p = this.repositoryDatasourceManager.getInternalFileData(s.getPath());
            }
            catch (RepositoryException e) {
                Response.serverError().entity((Object)e.getLocalizedMessage()).build();
            }
            break;
        }
        return Response.ok((Object)p.getBytes(), (String)"application/octet-stream").header("content-disposition", (Object)("attachment; filename = " + id)).build();
    }

    @GET
    @Path(value="/datasource/import")
    public Response importLegacyDatasources() {
        if (!this.userService.isAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.datasourceService.importLegacyDatasources();
        return Response.ok().build();
    }

    @GET
    @Path(value="/schema/import")
    public Response importLegacySchema() {
        if (!this.userService.isAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.datasourceService.importLegacySchema();
        return Response.ok().build();
    }

    @GET
    @Path(value="/users/import")
    public Response importLegacyUsers() {
        if (!this.userService.isAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.datasourceService.importLegacyUsers();
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/users/{id}")
    @ReturnType(value="org.saiku.database.dto.SaikuUser")
    public Response getUserDetails(@PathParam(value="id") int id) {
        if (!this.userService.isAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return Response.ok().entity((Object)this.userService.getUser(id)).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/users/{username}")
    @ReturnType(value="org.saiku.database.dto.SaikuUser")
    public Response updateUserDetails(SaikuUser jsonString, @PathParam(value="username") String userName) {
        if (!this.userService.isAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (jsonString.getPassword() == null || jsonString.getPassword().equals("")) {
            return Response.ok().entity((Object)this.userService.updateUser(jsonString, false)).build();
        }
        return Response.ok().entity((Object)this.userService.updateUser(jsonString, true)).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/users")
    @ReturnType(value="org.saiku.database.dto.SaikuUser")
    public Response createUserDetails(SaikuUser jsonString) {
        if (!this.userService.isAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return Response.ok().entity((Object)this.userService.addUser(jsonString)).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/users/{username}")
    public Response removeUser(@PathParam(value="username") String username) {
        if (!this.userService.isAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.userService.removeUser(username);
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStringFromInputStream(InputStream is) {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            log.error("IO Exception when reading from input stream", (Throwable)e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    log.error("IO Exception closing input stream", (Throwable)e);
                }
            }
        }
        return sb.toString();
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="/version")
    @ReturnType(value="java.lang.String")
    public Response getVersion() {
        Properties prop = new Properties();
        String version = "";
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        InputStream is = classloader.getResourceAsStream("org/saiku/web/rest/resources/version.properties");
        try {
            prop.load(is);
            version = prop.getProperty("VERSION");
        }
        catch (IOException ex) {
            log.error("IO Exception when reading input stream", (Throwable)ex);
        }
        return Response.ok().entity((Object)version).type("text/plain").build();
    }

    @GET
    @Produces(value={"application/zip"})
    @Path(value="/backup")
    public StreamingOutput getBackup() {
        if (!this.userService.isAdmin()) {
            return null;
        }
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                BufferedOutputStream bus = new BufferedOutputStream(output);
                bus.write(AdminResource.this.datasourceService.exportRepository());
            }
        };
    }

    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"multipart/form-data"})
    @Path(value="/restore")
    public Response postRestore(@FormDataParam(value="file") InputStream is, @FormDataParam(value="file") FormDataContentDisposition detail) {
        if (!this.userService.isAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)is);
            this.datasourceService.restoreRepository(bytes);
            return Response.ok().entity((Object)"Restore Ok").type("text/plain").build();
        }
        catch (IOException e) {
            log.error("Error reading restore file", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Restore Ok").type("text/plain").build();
        }
    }

    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"multipart/form-data"})
    @Path(value="/legacyfiles")
    public Response postRestoreFiles(@FormDataParam(value="file") InputStream is, @FormDataParam(value="file") FormDataContentDisposition detail) {
        if (!this.userService.isAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)is);
            this.datasourceService.restoreLegacyFiles(bytes);
            return Response.ok().entity((Object)"Restore Ok").type("text/plain").build();
        }
        catch (IOException e) {
            log.error("Error reading restore file", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Restore Ok").type("text/plain").build();
        }
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="/log/{logname}")
    public Response getLogFile(@PathParam(value="logname") String logname) {
        if (!this.userService.isAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.logExtractor.readLog(logname)).build();
        }
        catch (IOException e) {
            log.error("Could not read log file", (Throwable)e);
            return Response.serverError().entity((Object)"Could not read log file").build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/datakeys")
    public Response getPropertiesKeys() {
        return Response.ok((Object)this.repositoryDatasourceManager.getAvailablePropertiesKeys()).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/attacheddatasources")
    public Response getDataSources() {
        if (!this.userService.isAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        List list = this.repositoryDatasourceManager.getJujuDatasources();
        return Response.ok((Object)list).build();
    }
}

