/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.export;

import com.his.jackson.core.JsonProcessingException;
import com.his.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.saiku.web.rest.objects.resultset.QueryResult;

public class JSConverter {
    public static String convertToHtml(QueryResult queryResult, boolean wrapcontent) throws IOException {
        StringWriter stringWriter = new StringWriter();
        JSConverter.useJavascriptToConvertToHtml(queryResult, stringWriter);
        String content = stringWriter.toString();
        content = JSConverter.appendSaikuCommercialIfNecessary(content);
        return content;
    }

    private static void useJavascriptToConvertToHtml(QueryResult queryResult, StringWriter stringWriter) throws IOException {
        Context javascriptContext = JSConverter.createJavascriptContext();
        ScriptableObject globalScope = javascriptContext.initStandardObjects();
        JSConverter.loadJavascriptScripts(javascriptContext, (Scriptable)globalScope);
        JSConverter.loadDataIntoJsContext(queryResult, (Scriptable)globalScope);
        JSConverter.loadStringWriterIntoJsContext(stringWriter, (Scriptable)globalScope);
        JSConverter.executeJavascript(javascriptContext, (Scriptable)globalScope);
        Context.exit();
    }

    private static void executeJavascript(Context javascriptContext, Scriptable globalScope) {
        String code = "eval('var cellset = ' + data); \nvar renderer = new SaikuTableRenderer(); \nvar html = renderer.render(cellset, { wrapContent : false }); out.write(html);";
        javascriptContext.evaluateString(globalScope, code, "<mem>", 1, null);
    }

    private static void loadStringWriterIntoJsContext(StringWriter stringWriter, Scriptable globalScope) {
        Object wrappedOut = Context.javaToJS((Object)stringWriter, (Scriptable)globalScope);
        ScriptableObject.putProperty((Scriptable)globalScope, (String)"out", (Object)wrappedOut);
    }

    private static void loadDataIntoJsContext(QueryResult queryResult, Scriptable globalScope) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        String data = objectMapper.writeValueAsString((Object)queryResult);
        Object wrappedQueryResult = Context.javaToJS((Object)data, (Scriptable)globalScope);
        ScriptableObject.putProperty((Scriptable)globalScope, (String)"data", (Object)wrappedQueryResult);
    }

    private static Context createJavascriptContext() {
        Context javascriptContext = Context.enter();
        javascriptContext.setOptimizationLevel(-1);
        javascriptContext.setLanguageVersion(150);
        return javascriptContext;
    }

    private static void loadJavascriptScripts(Context javascriptContext, Scriptable globalScope) throws IOException {
        InputStreamReader underscoreReader = new InputStreamReader(JSConverter.class.getResourceAsStream("underscore.js"));
        javascriptContext.evaluateReader(globalScope, (Reader)underscoreReader, "underscore.js", 1, null);
        InputStreamReader saikuRendererReader = new InputStreamReader(JSConverter.class.getResourceAsStream("SaikuRenderer.js"));
        javascriptContext.evaluateReader(globalScope, (Reader)saikuRendererReader, "SaikuRenderer.js", 1, null);
        String result = IOUtils.toString((InputStream)JSConverter.class.getResourceAsStream("SaikuTableRenderer.js"));
        javascriptContext.evaluateString(globalScope, result, "SaikuTableRenderer.js", 1, null);
    }

    private static String appendSaikuCommercialIfNecessary(String content) {
        if (JSConverter.getVersion() != null && !JSConverter.getVersion().contains("EE")) {
            content = content + "<div style='margin-top:10px;'><h5>Export Provided By Saiku Analytics Community Edition(http://meteorite.bi)</h5></div>";
        }
        content = content.replaceAll("&nbsp;", " ");
        content = content.replaceAll("&nbsp", " ");
        return content;
    }

    public static String convertToHtml(QueryResult qr) throws IOException {
        return JSConverter.convertToHtml(qr, false);
    }

    private static String getVersion() {
        Properties prop = new Properties();
        Object input = null;
        String version = "";
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        InputStream is = classloader.getResourceAsStream("org/saiku/web/rest/resources/version.properties");
        try {
            prop.load(is);
            System.out.println(prop.getProperty("VERSION"));
            version = prop.getProperty("VERSION");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return version;
    }
}

