/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.repository;

import com.his.jackson.core.type.TypeReference;
import com.his.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.commons.JcrUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.saiku.repository.AclEntry;
import org.saiku.repository.AclMethod;
import org.saiku.repository.AclType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Acl2 {
    private static final Logger LOG = LoggerFactory.getLogger(Acl2.class);
    private List<String> adminRoles;
    private AclMethod rootMethod = AclMethod.WRITE;
    @NotNull
    private final Map<String, AclEntry> acl = new TreeMap<String, AclEntry>();

    public Acl2(File n) {
    }

    public void setAdminRoles(List<String> adminRoles) {
        this.adminRoles = adminRoles;
    }

    public Acl2(@NotNull Node root) {
        this.readAclTree(root);
    }

    @NotNull
    public List<AclMethod> getMethods(@NotNull Node node, String username, @NotNull List<String> roles) {
        try {
            AclMethod method;
            ObjectMapper mapper = new ObjectMapper();
            AclEntry entry = null;
            Map acl = new TreeMap();
            try {
                TypeReference<Map<String, AclEntry>> ref = new TypeReference<Map<String, AclEntry>>(){};
                acl = (Map)mapper.readValue(node.getProperty("owner").getString(), (TypeReference)ref);
                entry = (AclEntry)acl.get(node.getPath());
            }
            catch (PathNotFoundException e) {
                if (node.getMixinNodeTypes().length == 0 && (FilenameUtils.getExtension((String)node.getName()).equals("") || FilenameUtils.getExtension((String)node.getName()) == null)) {
                    node.addMixin("nt:saikufolders");
                }
                HashMap<String, List<AclMethod>> m = new HashMap<String, List<AclMethod>>();
                AclEntry e2 = new AclEntry("admin", AclType.PUBLIC, m, null);
                Acl2 acl2 = new Acl2(node);
                acl2.addEntry(node.getPath(), e2);
                acl2.serialize(node);
                node.getSession().save();
                LOG.debug("Path(owner) not found: " + node.getPath(), e.getCause());
            }
            catch (Exception e) {
                LOG.debug("Exception: " + node.getPath(), e.getCause());
            }
            if (node.getPath().startsWith("..")) {
                return this.getAllAcls(AclMethod.NONE);
            }
            if (this.isAdminRole(roles)) {
                return this.getAllAcls(AclMethod.GRANT);
            }
            if (entry != null) {
                switch (entry.getType()) {
                    case PRIVATE: {
                        if (!entry.getOwner().equals(username)) {
                            method = AclMethod.NONE;
                            break;
                        }
                        method = AclMethod.GRANT;
                        break;
                    }
                    case SECURED: {
                        ArrayList<AclMethod> allMethods = new ArrayList<AclMethod>();
                        if (StringUtils.isNotBlank((String)entry.getOwner()) && entry.getOwner().equals(username)) {
                            allMethods.add(AclMethod.GRANT);
                        }
                        ArrayList userMethods = entry.getUsers() != null && entry.getUsers().containsKey(username) ? entry.getUsers().get(username) : new ArrayList();
                        ArrayList roleMethods = new ArrayList();
                        for (String role : roles) {
                            ArrayList r = entry.getRoles() != null && entry.getRoles().containsKey(role) ? entry.getRoles().get(role) : new ArrayList();
                            roleMethods.addAll(r);
                        }
                        allMethods.addAll(userMethods);
                        allMethods.addAll(roleMethods);
                        if (allMethods.size() == 0) {
                            method = AclMethod.NONE;
                            break;
                        }
                        method = AclMethod.max(allMethods);
                        break;
                    }
                    default: {
                        method = AclMethod.WRITE;
                        break;
                    }
                }
            } else if (node.getParent() == null) {
                method = AclMethod.NONE;
            } else {
                if (node.getParent().getName().equals("/")) {
                    return this.getAllAcls(this.rootMethod);
                }
                Node parent = node.getParent();
                List<AclMethod> parentMethods = this.getMethods(parent, username, roles);
                method = AclMethod.max(parentMethods);
            }
            return this.getAllAcls(method);
        }
        catch (Exception e) {
            LOG.debug("Error", e.getCause());
            ArrayList<AclMethod> noMethod = new ArrayList<AclMethod>();
            noMethod.add(AclMethod.NONE);
            return noMethod;
        }
    }

    public void setRootAcl(String rootAcl) {
        try {
            if (StringUtils.isNotBlank((String)rootAcl)) {
                this.rootMethod = AclMethod.valueOf(rootAcl);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to set root ACL", (Throwable)e);
        }
    }

    @NotNull
    private List<AclMethod> getAllAcls(@Nullable AclMethod maxMethod) {
        ArrayList<AclMethod> methods = new ArrayList<AclMethod>();
        if (maxMethod != null) {
            for (AclMethod m : AclMethod.values()) {
                if (m.ordinal() <= 0 || m.ordinal() > maxMethod.ordinal()) continue;
                methods.add(m);
            }
        }
        return methods;
    }

    public boolean canGrant(@NotNull Node node, String username, @NotNull List<String> roles) {
        List<AclMethod> acls = this.getMethods(node, username, roles);
        return acls.contains((Object)AclMethod.GRANT);
    }

    public void addEntry(String path, @Nullable AclEntry entry) {
        try {
            if (entry != null) {
                this.acl.put(path, entry);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Node serialize(@NotNull Node node) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            node.setProperty("owner", "");
            node.setProperty("owner", mapper.writeValueAsString(this.acl));
            return node;
        }
        catch (Exception e) {
            try {
                LOG.info("Error while reading ACL files at path: " + node.getPath(), e.getCause());
            }
            catch (RepositoryException e1) {
                LOG.info("Repository Exception", e1.getCause());
            }
            return node;
        }
    }

    private Map<String, AclEntry> deserialize(@Nullable Node node) {
        ObjectMapper mapper = new ObjectMapper();
        Map<String, AclEntry> acl = new TreeMap<String, AclEntry>();
        try {
            if (node != null && node.getProperty("owner") != null) {
                TypeReference<Map<String, AclEntry>> ref = new TypeReference<Map<String, AclEntry>>(){};
                acl = (Map)mapper.readValue(node.getProperty("owner").getString(), (TypeReference)ref);
            }
        }
        catch (Exception e) {
            try {
                LOG.info("Error while reading ACL files at path: " + node.getPath(), e.getCause());
            }
            catch (RepositoryException e1) {
                LOG.info("Repository Exception", e1.getCause());
            }
        }
        return acl;
    }

    @Nullable
    public AclEntry getEntry(String path) {
        return this.acl.containsKey(path) ? this.acl.get(path) : null;
    }

    public boolean canRead(@Nullable Node path, String username, @NotNull List<String> roles) {
        if (path == null) {
            return false;
        }
        List<AclMethod> acls = this.getMethods(path, username, roles);
        return acls.contains((Object)AclMethod.READ);
    }

    public boolean canWrite(@Nullable Node path, String username, @NotNull List<String> roles) {
        if (path == null) {
            return false;
        }
        List<AclMethod> acls = this.getMethods(path, username, roles);
        return !acls.contains((Object)AclMethod.WRITE);
    }

    private void readAclTree(@NotNull Node resource) {
        try {
            String s = resource.getPrimaryNodeType().getName();
            String jsonFile = resource.getProperty("owner").getString();
            if (jsonFile != null && !jsonFile.equals("")) {
                Map<String, AclEntry> folderAclMap = this.deserialize(resource);
                TreeMap<String, AclEntry> aclMap = new TreeMap<String, AclEntry>();
                for (String key : folderAclMap.keySet()) {
                    if (!key.equals(resource.getPath())) continue;
                    AclEntry entry = folderAclMap.get(key);
                    aclMap.put(resource.getPath(), entry);
                }
                this.acl.putAll(aclMap);
            }
            for (Node file : JcrUtils.getChildNodes((Node)resource)) {
                if (file.getName().equals("/") || file.getName().startsWith("jcr:") || file.getName().startsWith("rep:")) continue;
                this.readAclTree(file);
            }
        }
        catch (Exception e) {
            try {
                LOG.info("Error while reading ACL files at path: " + resource.getPath(), e.getCause());
            }
            catch (RepositoryException e1) {
                LOG.info("Repository Exception", e1.getCause());
            }
        }
    }

    public List<String> getAdminRoles() {
        return this.adminRoles;
    }

    private boolean isAdminRole(String role) {
        return this.adminRoles.contains(role);
    }

    private boolean isAdminRole(@NotNull List<String> roles) {
        for (String role : roles) {
            if (!this.isAdminRole(role)) continue;
            return true;
        }
        return false;
    }

    public void serialize(File n) {
        try {
            File f = new File(n, "acl.json");
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue(f, this.acl);
        }
        catch (Exception e) {
            LOG.info("Error while writing ACL files at path: " + n.getPath(), e.getCause());
        }
    }

    public boolean canWrite(File node, String user, List<String> roles) {
        if (node == null) {
            return false;
        }
        List<AclMethod> acls = this.getMethods(node, user, roles);
        return acls.contains((Object)AclMethod.WRITE);
    }

    public boolean canRead(File node, String user, List<String> roles) {
        if (node == null) {
            return false;
        }
        List<AclMethod> acls = this.getMethods(node, user, roles);
        return acls.contains((Object)AclMethod.READ);
    }

    public boolean canGrant(File node, String user, List<String> roles) {
        if (node == null) {
            return false;
        }
        List<AclMethod> acls = this.getMethods(node, user, roles);
        return acls.contains((Object)AclMethod.GRANT);
    }

    public boolean canRead(String relativePath, String user, List<String> roles) {
        if (relativePath == null) {
            return false;
        }
        List<AclMethod> acls = this.getMethods(new File(relativePath), user, roles);
        return acls.contains((Object)AclMethod.READ);
    }

    @NotNull
    public List<AclMethod> getMethods(@NotNull File file, String username, @NotNull List<String> roles) {
        try {
            AclMethod method;
            ObjectMapper mapper = new ObjectMapper();
            AclEntry entry = null;
            Map aclData = new TreeMap();
            try {
                TypeReference<Map<String, AclEntry>> ref = new TypeReference<Map<String, AclEntry>>(){};
                aclData = (Map)mapper.readValue(new File(file, "acl.json"), (TypeReference)ref);
                entry = (AclEntry)aclData.get(file.getPath());
            }
            catch (Exception e) {
                LOG.debug("Exception: " + file.getPath(), e.getCause());
            }
            if (file.getPath().startsWith("..")) {
                return this.getAllAcls(AclMethod.NONE);
            }
            if (this.isAdminRole(roles)) {
                return this.getAllAcls(AclMethod.GRANT);
            }
            if (entry != null) {
                switch (entry.getType()) {
                    case PRIVATE: {
                        if (!entry.getOwner().equals(username)) {
                            method = AclMethod.NONE;
                            break;
                        }
                        method = AclMethod.GRANT;
                        break;
                    }
                    case SECURED: {
                        ArrayList<AclMethod> allMethods = new ArrayList<AclMethod>();
                        if (StringUtils.isNotBlank((String)entry.getOwner()) && entry.getOwner().equals(username)) {
                            allMethods.add(AclMethod.GRANT);
                        }
                        ArrayList userMethods = entry.getUsers() != null && entry.getUsers().containsKey(username) ? entry.getUsers().get(username) : new ArrayList();
                        ArrayList roleMethods = new ArrayList();
                        for (String role : roles) {
                            ArrayList r = entry.getRoles() != null && entry.getRoles().containsKey(role) ? entry.getRoles().get(role) : new ArrayList();
                            roleMethods.addAll(r);
                        }
                        allMethods.addAll(userMethods);
                        allMethods.addAll(roleMethods);
                        if (allMethods.size() == 0) {
                            method = AclMethod.NONE;
                            break;
                        }
                        method = AclMethod.max(allMethods);
                        break;
                    }
                    default: {
                        method = AclMethod.WRITE;
                        break;
                    }
                }
            } else if (file.getParentFile() == null) {
                method = AclMethod.NONE;
            } else {
                if (file.getParentFile().getName().equals("/")) {
                    return this.getAllAcls(this.rootMethod);
                }
                List<AclMethod> parentMethods = this.getMethods(file.getParentFile(), username, roles);
                method = AclMethod.max(parentMethods);
            }
            return this.getAllAcls(method);
        }
        catch (Exception e) {
            LOG.debug("Error", e.getCause());
            ArrayList<AclMethod> noMethod = new ArrayList<AclMethod>();
            noMethod.add(AclMethod.NONE);
            return noMethod;
        }
    }
}

