/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.query;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.olap4j.impl.Named;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Member;
import org.saiku.query.AbstractQuerySet;
import org.saiku.query.Parameter;
import org.saiku.query.QueryHierarchy;

public class QueryLevel
extends AbstractQuerySet
implements Named {
    private final QueryHierarchy hierarchy;
    private final Level level;
    private List<Member> inclusions = new ArrayList<Member>();
    private List<Member> exclusions = new ArrayList<Member>();
    private Member rangeStart = null;
    private Member rangeEnd = null;
    private String rangeStartExpr = null;
    private String rangeEndExpr = null;
    private String rangeStartSyn;
    private String rangeEndSyn;
    private String parameterName = null;
    private Parameter.SelectionType parameterSelectionType = Parameter.SelectionType.INCLUSION;

    public QueryLevel(QueryHierarchy hierarchy, Level level) {
        this.hierarchy = hierarchy;
        this.level = level;
    }

    public QueryHierarchy getQueryHierarchy() {
        return this.hierarchy;
    }

    @Override
    public String getName() {
        return this.level.getName();
    }

    public String getUniqueName() {
        return this.level.getUniqueName();
    }

    public String getCaption() {
        return this.level.getCaption();
    }

    @Override
    public boolean isSimple() {
        return super.isSimple() && (this.level.getLevelType().equals((Object)Level.Type.ALL) || this.inclusions.isEmpty() && this.exclusions.isEmpty() && this.rangeStart == null && this.rangeEnd == null && this.rangeStartExpr == null && this.rangeEndExpr == null) && (!this.hasParameter() || this.hierarchy.getQuery().getParameter(this.getParameterName()) == null);
    }

    public boolean isRange() {
        return this.rangeStart != null && this.rangeEnd != null || this.rangeStartExpr != null || this.rangeEndExpr != null;
    }

    public Level getLevel() {
        return this.level;
    }

    public List<Member> getInclusions() {
        return this.inclusions;
    }

    public List<Member> getExclusions() {
        return this.exclusions;
    }

    public Member getRangeStart() {
        return this.rangeStart;
    }

    public Member getRangeEnd() {
        return this.rangeEnd;
    }

    public String getRangeStartExpr() {
        return this.rangeStartExpr;
    }

    public String getRangeEndExpr() {
        return this.rangeEndExpr;
    }

    public String getRangeStartSyn() {
        return this.rangeStartSyn;
    }

    public String getRangeEndSyn() {
        return this.rangeEndSyn;
    }

    protected void clearSelections() {
        this.inclusions.clear();
        this.exclusions.clear();
        this.rangeStart = null;
        this.rangeStartExpr = null;
        this.rangeStartSyn = null;
        this.rangeEnd = null;
        this.rangeEndExpr = null;
        this.rangeEndSyn = null;
    }

    protected void include(Member m) {
        if (!this.inclusions.contains(m)) {
            this.inclusions.add(m);
        }
    }

    protected void exclude(Member m) {
        if (this.inclusions.contains(m)) {
            this.inclusions.remove(m);
        }
        if (!this.exclusions.contains(m)) {
            this.exclusions.add(m);
        }
    }

    protected void setRange(Member start, Member end) {
        this.rangeStart = start;
        this.rangeEnd = end;
    }

    public void setRangeSynonyms(String startSynonym, String endSynonym) {
        this.rangeStartSyn = startSynonym;
        this.rangeEndSyn = endSynonym;
    }

    public void setRangeStartSynonym(String startSyn) {
        this.rangeStartSyn = startSyn;
    }

    public void setRangeEndSynonym(String endSyn) {
        this.rangeEndSyn = endSyn;
    }

    public void setRangeStartExpr(String startExp) {
        this.rangeStart = null;
        this.rangeStartExpr = startExp;
    }

    public void setRangeEndExpr(String endExp) {
        this.rangeEnd = null;
        this.rangeEndExpr = endExp;
    }

    public void setRangeExpressions(String startExpr, String endExpr) {
        this.rangeStart = null;
        this.rangeEnd = null;
        this.rangeStartExpr = startExpr;
        this.rangeEndExpr = endExpr;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.level == null ? 0 : this.level.getUniqueName().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryLevel other = (QueryLevel)obj;
        return !(this.level == null ? other.level != null : !this.level.getUniqueName().equals(other.getLevel().getUniqueName()));
    }

    public String toString() {
        return this.level.getUniqueName();
    }

    public void setParameterName(String parameter) {
        this.parameterName = parameter;
    }

    public void setParameterSelectionType(Parameter.SelectionType selectionType) {
        this.parameterSelectionType = selectionType;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public Parameter.SelectionType getParameterSelectionType() {
        return this.parameterSelectionType;
    }

    public boolean hasParameter() {
        return StringUtils.isNotBlank((String)this.parameterName);
    }
}

