/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.common.AbstractMessage;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.ObjectReferenceParser;
import de.statspez.pleditor.generator.parser.ParserChain;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import de.statspez.pleditor.generator.parser.ThisParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ObjectContextParser
extends SubParser
implements SuperParser {
    private MetaStatspezObjekt currentElement = null;
    private ParserChain parserChain = new ParserChain();
    private ThisParser thisParser = null;
    private ObjectReferenceParser objectReferenceParser = null;
    private boolean canEnabled = true;

    public ObjectContextParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
        this.thisParser = new ThisParser(this, resolver);
        this.parserChain.addParser(this.thisParser);
        this.objectReferenceParser = new ObjectReferenceParser(this, resolver);
        this.parserChain.addParser(this.objectReferenceParser);
    }

    @Override
    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.destatis.de/schema/datml-ssp/1.0".equalsIgnoreCase(namespaceURI) && "objectContext".equalsIgnoreCase(tag)) {
            return this.canEnabled;
        }
        return this.isEnabled();
    }

    @Override
    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("objectContext".equalsIgnoreCase(localName)) {
            this.enable();
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts)) {
            throw ILParseException.unknownTagException(localName);
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("objectContext".equalsIgnoreCase(localName)) {
            this.canEnabled = false;
            this.disableAndNotify();
        } else if (!this.parserChain.endElement(namespaceURI, localName, qName) && !this.handleTag(namespaceURI, localName, qName)) {
            throw ILParseException.unkownClosingTagException(localName);
        }
    }

    @Override
    public MetaElement object() {
        return this.currentElement;
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("objectContext".equalsIgnoreCase(localName)) {
            String str = atts.getValue("class");
            if (str != null) {
                // empty if block
            }
            if ((str = atts.getValue("name")) != null) {
                // empty if block
            }
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) throws SAXException {
        boolean handled = false;
        return handled;
    }

    @Override
    public void notifyObjectAvailable(SubParser aParser) {
    }

    @Override
    public StringBuffer charData() {
        return this.superParser().charData();
    }

    @Override
    public String parentElement() {
        return this.superParser().parentElement();
    }

    public void setCurrentElement(MetaStatspezObjekt objekt) {
        this.currentElement = objekt;
        this.objectReferenceParser.setCurrentElement(this.currentElement);
        this.thisParser.setCurrentElement(this.currentElement);
        this.canEnabled = true;
    }

    @Override
    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

