/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.common.AbstractMessage;
import de.statspez.pleditor.generator.common.ElementMessageContext;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomParameter;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaProgramParameter;
import de.statspez.pleditor.generator.meta.MetaStatementSequence;
import de.statspez.pleditor.generator.parser.Helper;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.ObjectContextParser;
import de.statspez.pleditor.generator.parser.ParserChain;
import de.statspez.pleditor.generator.parser.PropertiesParser;
import de.statspez.pleditor.generator.parser.ReplacementUtil;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import de.statspez.pleditor.generator.parser.speclanguage.SpecLangParseException;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FunctionParser
extends SubParser
implements SuperParser {
    private MetaCustomFunktion currentFunction = null;
    private MetaCustomParameter currentParameter = null;
    private ParserChain parserChain = new ParserChain();
    private PropertiesParser propertiesParser;
    private ObjectContextParser objectContextParser;
    private final boolean canHaveIndexOperator;

    public FunctionParser(SuperParser sParser, Resolver resolver, boolean canHaveIndexOperator) {
        super(sParser, resolver);
        this.canHaveIndexOperator = canHaveIndexOperator;
    }

    @Override
    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.werum.de/pl-editor".equalsIgnoreCase(namespaceURI) && "function".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    @Override
    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("function".equalsIgnoreCase(localName)) {
            this.enable();
            this.currentFunction = new MetaCustomFunktion();
            this.propertiesParser = new PropertiesParser(this, this.resolver());
            this.parserChain.addParser(this.propertiesParser);
            this.objectContextParser = new ObjectContextParser(this, this.resolver());
            this.parserChain.addParser(this.objectContextParser);
            this.propertiesParser.setCurrentElement(this.currentFunction);
            this.objectContextParser.setCurrentElement(this.currentFunction);
        } else if ("parameter".equalsIgnoreCase(localName)) {
            this.currentParameter = new MetaCustomParameter();
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts) && !this.canHandleTag(namespaceURI, localName)) {
            throw ILParseException.unknownTagException(localName);
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("function".equalsIgnoreCase(localName)) {
            this.disable();
            this.notifyObjectAvailable();
        } else if (!this.parserChain.endElement(namespaceURI, localName, qName) && !this.handleTag(namespaceURI, localName, qName)) {
            throw ILParseException.unknownTagException(localName);
        }
    }

    @Override
    public MetaElement object() {
        return this.currentFunction;
    }

    @Override
    public void notifyObjectAvailable(SubParser aParser) {
    }

    @Override
    public StringBuffer charData() {
        return this.superParser().charData();
    }

    @Override
    public String parentElement() {
        return this.superParser().parentElement();
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("function".equalsIgnoreCase(localName)) {
            String name = atts.getValue("name").trim();
            String rtype = atts.getValue("returntype").trim();
            String type = atts.getValue("type").trim();
            String def = atts.getValue("definition").trim();
            String str = atts.getValue("id");
            if (str != null && str.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                this.currentFunction.setId(str.trim());
            } else {
                this.currentFunction.setId(name);
            }
            this.currentFunction.setName(name);
            this.currentFunction.setRueckgabeTyp(Helper.typeByName(rtype));
            this.currentFunction.setArt(def);
            String state = atts.getValue("state");
            if (state != null && state.trim().equals("approved")) {
                this.currentFunction.setFreigabeStatus((short)1);
            }
            if (type.equals("test")) {
                this.currentFunction.setFunctionType(1);
            } else {
                this.currentFunction.setFunctionType(0);
            }
        } else if ("parameter".equalsIgnoreCase(localName)) {
            String name = atts.getValue("name").trim();
            String type = atts.getValue("type").trim();
            this.currentParameter.setName(name);
            this.currentParameter.setTyp(Helper.typeByName(type));
            this.currentParameter.setListe(false);
            String length = atts.getValue("length");
            if (length == null) {
                this.currentParameter.setLaenge(0L);
            } else {
                this.currentParameter.setLaenge(Long.parseLong(length.trim()));
            }
            String dimensionsAttr = atts.getValue("dimensions");
            if (dimensionsAttr != null && dimensionsAttr.trim().length() > 0) {
                int[] dimensions = Helper.parseDimensionSpec(dimensionsAttr.trim());
                this.currentParameter.setListe(true);
                this.currentParameter.setDimensions(dimensions);
                this.currentParameter.setDimension(dimensionsAttr);
            }
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) throws SAXException {
        boolean handled = true;
        String chars = this.superParser().charData().toString().trim();
        if ("parameter".equalsIgnoreCase(localName)) {
            this.currentFunction.addToParameter(this.currentParameter);
            this.currentParameter = null;
        } else if ("code".equalsIgnoreCase(localName)) {
            MetaProgram spez;
            ReplacementUtil util = ReplacementUtil.getInstance();
            if (util.sollErsetztWerden(this.superParser().getParserKontext().getVersion())) {
                chars = util.replace(chars);
            }
            this.currentFunction.setAnweisungen(chars);
            String art = this.currentFunction.getArt();
            if (art == null || art.isEmpty() || "intern".equals(art)) {
                MetaProgram metaProgram = null;
                try {
                    int contextType = 4;
                    if (this.currentFunction != null && this.currentFunction.getFunctionType() == 1) {
                        contextType = 3;
                    }
                    metaProgram = Helper.metaStructureFor(new ElementMessageContext(contextType, this.currentFunction.getId(), this.currentFunction.getName()), chars);
                }
                catch (SpecLangParseException e) {
                    Iterator mit = e.messageIterator();
                    while (mit.hasNext()) {
                        AbstractMessage aMsg = (AbstractMessage)mit.next();
                        this.error(aMsg);
                    }
                    metaProgram = new MetaProgram("Funktion " + this.currentFunction.getName(), new MetaStatementSequence());
                }
                metaProgram.setHasToReturnValue(true);
                spez = metaProgram;
            } else if ("extern".equals(art)) {
                spez = new MetaProgram("Externe Funktion " + this.currentFunction.getName(), new MetaStatementSequence());
            } else if ("ref".equals(art)) {
                spez = new MetaProgram("Referenzfunktion " + this.currentFunction.getName(), new MetaStatementSequence());
            } else {
                throw new IllegalStateException("Unbekannte Art: " + art);
            }
            if (spez != null) {
                spez.setName(this.currentFunction.getName());
                spez.setCanHaveIndexOperator(this.canHaveIndexOperator);
                this.currentFunction.setMetaSpezifikation(spez);
                for (int i = 0; i < this.currentFunction.sizeOfParameter(); ++i) {
                    MetaCustomParameter aParam = (MetaCustomParameter)this.currentFunction.getFromParameter(i);
                    MetaProgramParameter programParam = null;
                    MetaIdentifier paramName = new MetaIdentifier(aParam.getName());
                    programParam = !aParam.getListe() ? new MetaProgramParameter(paramName) : new MetaProgramParameter(paramName, aParam.dimensions());
                    this.currentFunction.getMetaSpezifikation().addParameter(programParam);
                }
            }
        } else if (!"properties".equalsIgnoreCase(localName) && !"about".equalsIgnoreCase(localName)) {
            if ("description".equalsIgnoreCase(localName)) {
                chars = this.superParser().charData().toString();
                this.currentParameter.setBeschreibung(chars);
            } else {
                handled = false;
            }
        }
        return handled;
    }

    private boolean canHandleTag(String namespaceURI, String tag) {
        boolean bed_1 = "http://www.werum.de/pl-editor".equalsIgnoreCase(namespaceURI) && (tag.equalsIgnoreCase("code") || tag.equalsIgnoreCase("parameter"));
        boolean bed_2 = "http://www.destatis.de/schema/datml-ssp/1.0".equalsIgnoreCase(namespaceURI) && ("properties".equalsIgnoreCase(tag) || "about".equalsIgnoreCase(tag) || "description".equalsIgnoreCase(tag));
        return bed_1 || bed_2;
    }

    @Override
    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

