/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.masken;

import de.statspez.pleditor.generator.masken.AbstractMaske;
import de.statspez.pleditor.generator.masken.AbstractMaskenParser;
import de.statspez.pleditor.generator.masken.DatumAusdruckList;
import de.statspez.pleditor.generator.masken.DatumMaske;
import de.statspez.pleditor.generator.masken.MaskeException;

public class DatumMaskenParser
extends AbstractMaskenParser {
    @Override
    public AbstractMaske parse(String maske) throws MaskeException {
        StringBuffer message = new StringBuffer();
        try {
            DatumReader reader;
            DatumAusdruckList list;
            DatumMaske dateMaske = new DatumMaske();
            if (maske == null || maske.length() == 0) {
                throw new MaskeException("Maske soll angegeben werden");
            }
            if (this.isSegmentGueltig(maske, message)) {
                maske = this.parseAusrichtung(dateMaske, maske);
                list = new DatumAusdruckList();
                reader = new DatumReader(list);
                for (int i = 0; i < maske.length(); ++i) {
                    reader.add(maske.charAt(i), i == maske.length() - 1);
                }
            } else {
                throw new MaskeException(message.toString());
            }
            dateMaske.setzeMinLaenge(reader.laenge);
            dateMaske.setzeMaxLaenge(reader.laenge);
            String patternString = list.gibPattern(dateMaske.gibMinLaenge(), dateMaske.gibMaxLaenge());
            DatumMaske.createSimpleDateFormat(patternString);
            dateMaske.setzeMaskeAlsString(patternString);
            return dateMaske;
        }
        catch (Exception e) {
            throw new MaskeException("Die Datum-Maske ist falsch beschrieben." + (e.getMessage() != null ? " " + e.getMessage() : ""));
        }
    }

    @Override
    protected String parseAusrichtung(AbstractMaske abstractMaske, String maske) {
        if (maske != null && maske.length() > 0 && 'M' == maske.charAt(0)) {
            String MMM = new String(new char[]{'M', 'M', 'M'});
            String MM = new String(new char[]{'M', 'M'});
            if (maske.startsWith(MMM) || !maske.startsWith(MM)) {
                abstractMaske.setzeAusrichtung('M');
                maske = maske.substring(1);
            }
        } else {
            maske = super.parseAusrichtung(abstractMaske, maske);
        }
        return maske;
    }

    private char toEnglisch(char ch) {
        switch (ch) {
            case 'J': {
                return 'y';
            }
            case 'T': {
                return 'd';
            }
            case 'S': {
                return 'H';
            }
        }
        return ch;
    }

    private boolean isSegmentGueltig(String segment, StringBuffer message) {
        boolean maskiert = false;
        boolean ok = true;
        SymbolZaehler zaehler = new SymbolZaehler();
        int anz = segment.length();
        block16: for (int i = 0; ok && i < anz; ++i) {
            char ch = segment.charAt(i);
            if (this.istSymbol(ch) && !maskiert) {
                switch (ch) {
                    case 'L': 
                    case 'R': {
                        if (i == 0) continue block16;
                        ok = false;
                        if (message == null) continue block16;
                        message.append("Ausrichtungssymbol '" + ch + "' darf nur am Anfang der Maskendefinition vorkommen.");
                        break;
                    }
                    case 'M': {
                        boolean isAusrichtung = false;
                        if (i == 0) {
                            for (int j = 0; j < segment.length() && segment.charAt(j) == 'M'; ++j) {
                                isAusrichtung = !isAusrichtung;
                            }
                        }
                        if (isAusrichtung) continue block16;
                        try {
                            zaehler.add(ch, null);
                        }
                        catch (MaskeException e) {
                            ok = false;
                            if (message == null) continue block16;
                            message.append(e.getMessage());
                        }
                        break;
                    }
                    case '\\': {
                        try {
                            zaehler.print(null);
                            maskiert = true;
                        }
                        catch (MaskeException e1) {
                            ok = false;
                            if (message == null) continue block16;
                            message.append(e1.getMessage());
                        }
                        break;
                    }
                    case '@': {
                        try {
                            zaehler.print(null);
                        }
                        catch (MaskeException e1) {
                            ok = false;
                            if (message == null) continue block16;
                            message.append(e1.getMessage());
                        }
                        break;
                    }
                    default: {
                        try {
                            zaehler.add(ch, null);
                        }
                        catch (MaskeException e) {
                            ok = false;
                            if (message == null) continue block16;
                            message.append(e.getMessage());
                        }
                        break;
                    }
                }
                continue;
            }
            if (ch == ' ') {
                ok = false;
                if (message == null) continue;
                message.append("Kein Leerzeichen in der Maskendefinition erlaubt.");
                continue;
            }
            if (maskiert) {
                maskiert = false;
            }
            try {
                zaehler.print(null);
                continue;
            }
            catch (MaskeException e) {
                ok = false;
                if (message == null) continue;
                message.append(e.getMessage());
            }
        }
        return ok;
    }

    @Override
    public boolean isSegmentGueltig(String segment) {
        return this.isSegmentGueltig(segment, null);
    }

    @Override
    protected void initSymbole() {
        this.symbole = new char[]{'L', 'M', 'R', 'J', 'M', 'T', 'S', 'm', 's', '\\', '@'};
    }

    private class SymbolZaehler {
        private char symbol;
        int anz = 0;

        private SymbolZaehler() {
        }

        private void add(char ch, DatumAusdruckList list) throws MaskeException {
            if (this.symbol != ch) {
                this.print(list);
                this.symbol = ch;
                ++this.anz;
            } else {
                ++this.anz;
                if (this.symbol == 'J' && this.anz > 4 || this.symbol != 'J' && this.anz > 2) {
                    this.formatException(this.symbol);
                }
            }
        }

        private void print(DatumAusdruckList list) throws MaskeException {
            if (this.anz == 0) {
                return;
            }
            if (this.anz == 2 || this.anz == 4 && this.symbol == 'J') {
                if (list != null) {
                    StringBuffer buf = new StringBuffer();
                    char ch = DatumMaskenParser.this.toEnglisch(this.symbol);
                    for (int i = 0; i < this.anz; ++i) {
                        buf.append(ch);
                    }
                    list.fuegeAusdruckHinzu(buf.toString());
                }
                this.anz = 0;
                return;
            }
            this.formatException(this.symbol);
        }

        private void formatException(char ch) throws MaskeException {
            StringBuffer buf = new StringBuffer();
            switch (ch) {
                case 'J': {
                    buf.append("Jahresangabe ");
                    break;
                }
                case 'M': {
                    buf.append("Monatsangabe ");
                    break;
                }
                case 'T': {
                    buf.append("Tagesangabe ");
                    break;
                }
                case 'S': {
                    buf.append("Stundenangabe ");
                    break;
                }
                case 'm': {
                    buf.append("Minutenangabe ");
                    break;
                }
                case 's': {
                    buf.append("Sekundenangabe ");
                }
            }
            buf.append("ist falsch.");
            throw new MaskeException(buf.toString());
        }
    }

    private class DatumReader {
        private StringBuffer text;
        private boolean negation;
        private SymbolZaehler zaehler;
        private DatumAusdruckList list;
        private int laenge;

        private DatumReader(DatumAusdruckList list) {
            this.zaehler = new SymbolZaehler();
            this.list = list;
            this.text = new StringBuffer();
            this.negation = false;
            this.zaehler = new SymbolZaehler();
            this.laenge = 0;
        }

        public void add(char ch, boolean last) throws MaskeException {
            if ('@' == ch) {
                if (this.negation) {
                    this.addToText(ch);
                } else {
                    this.addToText(' ');
                }
            } else if ('\\' == ch) {
                if (this.negation) {
                    this.addToText(ch);
                } else {
                    this.negation = true;
                }
            } else if (DatumMaskenParser.this.istSymbol(ch) && !this.negation) {
                this.addToSymbol(ch);
            } else {
                this.addToText(ch);
            }
            if (last) {
                if (this.text.length() > 0) {
                    this.list.fuegeAusdruckHinzu(this.text.toString());
                } else {
                    this.zaehler.print(this.list);
                }
            }
        }

        private void addToText(char ch) throws MaskeException {
            ++this.laenge;
            if (this.zaehler.anz > 0) {
                this.zaehler.print(this.list);
            }
            if (this.negation) {
                this.negation = false;
            }
            this.text.append(ch);
        }

        private void addToSymbol(char ch) throws MaskeException {
            ++this.laenge;
            this.printText();
            this.zaehler.add(ch, this.list);
        }

        private void printText() {
            if (this.text.length() > 0) {
                this.list.fuegeAusdruckHinzu(this.text.toString());
                this.text.setLength(0);
            }
        }
    }
}

