/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.compare.ui;

import de.statspez.pleditor.generator.compare.CompareResult;
import de.statspez.pleditor.generator.compare.ComparedNode;
import de.statspez.pleditor.generator.compare.SatzInterfaceCompare;
import de.statspez.pleditor.generator.compare.ui.CETreeTableModel;
import de.statspez.pleditor.generator.compare.ui.DataChangeEvent;
import de.statspez.pleditor.generator.compare.ui.DataChangeListener;
import de.statspez.pleditor.generator.compare.ui.TableColorRenderer;
import de.statspez.pleditor.generator.compare.ui.TreeColorRenderer;
import de.statspez.pleditor.generator.compare.ui.TreeTable;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;

public class CompareEditor
extends JPanel {
    private static final long serialVersionUID = -3886835011768468732L;
    private static final Color COLOR_DIFFERENCES = new Color(208, 227, 255);
    private static final Color COLOR_CHANGES = new Color(255, 204, 153);
    public static final int RIGHT_TO_LEFT = 1;
    public static final int LEFT_TO_RIGHT = 2;
    private JToolBar toolBar;
    private JPanel toolPanel;
    private JLabel label;
    private JPopupMenu jPopupMenu;
    private TreeTable table;
    private CETreeTableModel treeTableModel;
    private ValueToRightAction valueToRightAction;
    private ValueToLeftAction valueToLeftAction;
    private ToNextDifferenceAction toNextDifferenceAction;
    private ToPrevDifferenceAction toPrevDifferenceAction;
    private CopyToRightAction copyToRightAction;
    private CopyToLeftAction copyToLeftAction;
    private CompareResult compareResult;
    private TableColorRenderer tableRenderer;
    private TreeColorRenderer treeRenderer;
    private Color colorForDifferences;
    private Color colorForChanges;
    private final List listenerList;

    public CompareEditor(MetaCustomPlausibilisierung plausi, SatzInterface satz1, SatzInterface satz2, boolean valueToLeftProtected, boolean valueToRightProtected, int displayOption) {
        this(new SatzInterfaceCompare().compare(plausi, satz1, satz2), valueToLeftProtected, valueToRightProtected);
    }

    public CompareEditor(CompareResult compareResult, boolean valueToLeftProtected, boolean valueToRightProtected) {
        super(new BorderLayout());
        this.compareResult = compareResult;
        this.listenerList = new ArrayList();
        this.colorForChanges = COLOR_CHANGES;
        this.colorForDifferences = COLOR_DIFFERENCES;
        this.treeTableModel = new CETreeTableModel(compareResult.getRootNode());
        this.table = new TreeTable(this.treeTableModel, this);
        this.table.setSelectionMode(0);
        this.table.getTree().getSelectionModel().setSelectionMode(1);
        this.table.setGridColor(SystemColor.control);
        this.table.setRowHeight(18);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.tableRenderer = new TableColorRenderer(this);
        this.table.setDefaultRenderer(String.class, this.tableRenderer);
        this.treeRenderer = new TreeColorRenderer(this);
        this.table.setTreeCellRenderer(this.treeRenderer);
        this.label = new JLabel();
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.getViewport().setBackground(this.table.getBackground());
        this.add((Component)scrollPane, "Center");
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.valueToLeftAction = new ValueToLeftAction();
        this.valueToRightAction = new ValueToRightAction();
        this.copyToLeftAction = new CopyToLeftAction();
        this.copyToRightAction = new CopyToRightAction();
        this.toNextDifferenceAction = new ToNextDifferenceAction();
        this.toPrevDifferenceAction = new ToPrevDifferenceAction();
        this.toolBar.add(this.createToolBarButton(this.toNextDifferenceAction));
        this.toolBar.add(this.createToolBarButton(this.toPrevDifferenceAction));
        if (!valueToLeftProtected) {
            this.toolBar.add(this.createToolBarButton(this.valueToLeftAction));
            this.toolBar.add(this.createToolBarButton(this.copyToLeftAction));
        }
        if (!valueToRightProtected) {
            this.toolBar.add(this.createToolBarButton(this.valueToRightAction));
            this.toolBar.add(this.createToolBarButton(this.copyToRightAction));
        }
        this.toolPanel = new JPanel(new BorderLayout());
        this.toolPanel.add((Component)this.label, "Center");
        this.toolPanel.add((Component)this.toolBar, "East");
        this.label.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.add((Component)this.toolPanel, "North");
        this.addPopupMenu(valueToLeftProtected, valueToRightProtected);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (CompareEditor.this.table.getSelectedRow() >= 0) {
                    CompareEditor.this.table.scrollRectToVisible(CompareEditor.this.table.getCellRect(CompareEditor.this.table.getSelectedRow(), 0, true));
                    ComparedNode selectedNode = (ComparedNode)CompareEditor.this.table.getTree().getPathForRow(CompareEditor.this.table.getSelectedRow()).getLastPathComponent();
                    CompareEditor.this.setEnabledActions(selectedNode);
                } else {
                    CompareEditor.this.setEnabledActions(null);
                }
            }
        });
        this.updateDifferingUI();
    }

    private void setEnabledActions(ComparedNode selectedNode) {
        if (selectedNode == null) {
            if (this.valueToLeftAction != null) {
                this.valueToLeftAction.setEnabled(false);
            }
            if (this.valueToRightAction != null) {
                this.valueToRightAction.setEnabled(false);
            }
            if (this.copyToRightAction != null) {
                this.copyToRightAction.setEnabled(false);
            }
            if (this.copyToLeftAction != null) {
                this.copyToLeftAction.setEnabled(false);
            }
        } else {
            boolean enabled;
            if (this.valueToLeftAction != null) {
                if (selectedNode.getChildCount() > 0) {
                    if (selectedNode.hasDifferentValues() || this.compareResult.getDifferingCount(selectedNode) > 0) {
                        this.valueToLeftAction.setEnabled(true);
                    } else if (!selectedNode.hasSatz1() || !selectedNode.hasSatz2()) {
                        this.valueToLeftAction.setEnabled(true);
                    } else {
                        this.valueToLeftAction.setEnabled(false);
                    }
                } else if (selectedNode.hasDifferentValues()) {
                    if (selectedNode.getParent() != null) {
                        if (selectedNode.getParent().hasSatz1() && selectedNode.getParent().hasSatz2()) {
                            this.valueToLeftAction.setEnabled(true);
                        } else {
                            this.valueToLeftAction.setEnabled(false);
                        }
                    }
                } else {
                    this.valueToLeftAction.setEnabled(false);
                }
            }
            if (this.valueToRightAction != null) {
                if (selectedNode.getChildCount() > 0) {
                    if (selectedNode.hasDifferentValues() || this.compareResult.getDifferingCount(selectedNode) != 0) {
                        this.valueToRightAction.setEnabled(true);
                    } else if (!selectedNode.hasSatz1() || !selectedNode.hasSatz2()) {
                        this.valueToRightAction.setEnabled(true);
                    } else {
                        this.valueToRightAction.setEnabled(false);
                    }
                } else if (selectedNode.hasDifferentValues()) {
                    if (selectedNode.getParent() != null) {
                        if (selectedNode.getParent().hasSatz1() && selectedNode.getParent().hasSatz2()) {
                            this.valueToRightAction.setEnabled(true);
                        } else {
                            this.valueToRightAction.setEnabled(false);
                        }
                    }
                } else {
                    this.valueToRightAction.setEnabled(false);
                }
            }
            if (this.copyToRightAction != null) {
                enabled = selectedNode.isNDimensional() && selectedNode.hasSatz1() && selectedNode.getFeldDeskriptor().getIndizes() != null;
                this.copyToRightAction.setEnabled(enabled);
            }
            if (this.copyToLeftAction != null) {
                enabled = selectedNode.isNDimensional() && selectedNode.hasSatz2() && selectedNode.getFeldDeskriptor().getIndizes() != null;
                this.copyToLeftAction.setEnabled(enabled);
            }
        }
    }

    private void updateDifferingUI() {
        int count = this.compareResult.getDifferingCount(this.compareResult.getRootNode());
        if (count == 0) {
            this.label.setText("Kein Unterschied");
        } else {
            this.label.setText(count + " Unterschied" + (count > 1 ? "e" : ""));
        }
        this.toNextDifferenceAction.setEnabled(count > 0);
        this.toPrevDifferenceAction.setEnabled(count > 0);
    }

    public void setNameForColumn1(String name) {
        TableColumn column = this.table.getColumnModel().getColumn(0);
        column.setHeaderValue(name);
    }

    public void setNameForColumn2(String name) {
        TableColumn column = this.table.getColumnModel().getColumn(1);
        column.setHeaderValue(name);
    }

    public void setNameForColumn3(String name) {
        TableColumn column = this.table.getColumnModel().getColumn(2);
        column.setHeaderValue(name);
    }

    public void setColorForDifferences(Color color) {
        this.colorForDifferences = color;
    }

    public void setColorForChanges(Color color) {
        this.colorForChanges = color;
    }

    public Color getColorForChanges() {
        return this.colorForChanges;
    }

    public Color getColorForDifferences() {
        return this.colorForDifferences;
    }

    public void setToolBarVisible(boolean visible) {
        this.toolPanel.setVisible(visible);
    }

    public Action getToNextDifferenceAction() {
        return this.toNextDifferenceAction;
    }

    public Action getToPrevDifferenceAction() {
        return this.toPrevDifferenceAction;
    }

    public Action getValueToRightAction() {
        return this.valueToRightAction;
    }

    public Action getValueToLeftAction() {
        return this.valueToLeftAction;
    }

    public Action getCopyToLeftAction() {
        return this.copyToLeftAction;
    }

    public Action getCopyToRightAction() {
        return this.copyToRightAction;
    }

    public void transferSelectedValue(int direction) {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow >= 0) {
            TreePath selectedPath = this.table.getTree().getPathForRow(selectedRow);
            ComparedNode selectedNode = (ComparedNode)selectedPath.getLastPathComponent();
            String valueOld = "";
            String valueNew = "";
            if (selectedNode != null) {
                if (selectedNode.getChildCount() > 0) {
                    String question = direction == 2 ? (!selectedNode.hasSatz1() ? "Soll die ausgew\u00e4hlte Struktur in der rechten Spalte gel\u00f6scht werden?" : "Sollen alle Unterschiede der ausgew\u00e4hlten Struktur von links nach rechts \u00fcbernommen werden?") : (!selectedNode.hasSatz2() ? "Soll die ausgew\u00e4hlte Struktur in der linken Spalte gel\u00f6scht werden?" : "Sollen alle Unterschiede der ausgew\u00e4hlten Struktur von rechts nach links \u00fcbernommen werden?");
                    if (0 == JOptionPane.showOptionDialog(this, question, "Achtung!", 1, 3, null, null, null)) {
                        if (direction == 1) {
                            selectedNode.changeValue1();
                        } else {
                            selectedNode.changeValue2();
                        }
                        Enumeration<TreePath> expandedDescendants = this.table.getTree().getExpandedDescendants(selectedPath.getParentPath());
                        this.treeTableModel.nodeChanged(selectedNode);
                        if (expandedDescendants != null) {
                            while (expandedDescendants.hasMoreElements()) {
                                this.table.getTree().expandPath(expandedDescendants.nextElement());
                            }
                        }
                        if (selectedNode.isRemoved() && this.table.getRowCount() <= selectedRow) {
                            --selectedRow;
                        }
                        this.table.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
                        if (direction == 1) {
                            this.fireDataChangeEvent(this.compareResult.getRootNode().getSatz1(), selectedNode.getFeldDeskriptor());
                        } else {
                            this.fireDataChangeEvent(this.compareResult.getRootNode().getSatz2(), selectedNode.getFeldDeskriptor());
                        }
                    }
                } else {
                    if (direction == 1) {
                        valueOld = selectedNode.getValue1();
                        selectedNode.changeValue1();
                    } else {
                        valueOld = selectedNode.getValue2();
                        selectedNode.changeValue2();
                    }
                    Enumeration<TreePath> expandedDescendants = this.table.getTree().getExpandedDescendants(selectedPath.getParentPath());
                    selectedPath = new TreePath(selectedNode.getPath());
                    this.treeTableModel.nodeChanged(selectedNode);
                    if (expandedDescendants != null) {
                        while (expandedDescendants.hasMoreElements()) {
                            this.table.getTree().expandPath(expandedDescendants.nextElement());
                        }
                    }
                    this.table.getSelectionModel().setSelectionInterval(this.table.getTree().getRowForPath(selectedPath), this.table.getTree().getRowForPath(selectedPath));
                    if (direction == 1) {
                        valueNew = selectedNode.getValue1();
                        this.fireDataChangeEvent(((ComparedNode)this.treeTableModel.getRoot()).getSatz1(), valueOld, valueNew, selectedNode.getFeldDeskriptor());
                    } else {
                        valueNew = selectedNode.getValue2();
                        this.fireDataChangeEvent(((ComparedNode)this.treeTableModel.getRoot()).getSatz2(), valueOld, valueNew, selectedNode.getFeldDeskriptor());
                    }
                }
                this.updateDifferingUI();
            }
        }
    }

    public void goToDifference(boolean next) {
        TreePath selectedPath = this.table.getTree().getPathForRow(this.table.getSelectedRow());
        if (selectedPath == null) {
            selectedPath = new TreePath(this.compareResult.getRootNode().getPath());
        }
        ComparedNode selectedNode = (ComparedNode)selectedPath.getLastPathComponent();
        ComparedNode nextDifferingNode = next ? this.compareResult.getNextDifferingNode(selectedNode) : this.compareResult.getPrevDifferingNode(selectedNode);
        if (nextDifferingNode == null) {
            nextDifferingNode = this.compareResult.getRootNode();
        } else {
            TreePath nextPath = new TreePath(nextDifferingNode.getPath());
            this.table.getTree().setSelectionPath(nextPath);
            Enumeration<TreePath> expandedDescendants = this.table.getTree().getExpandedDescendants(nextPath.getParentPath());
            if (expandedDescendants != null) {
                while (expandedDescendants.hasMoreElements()) {
                    this.table.getTree().expandPath(expandedDescendants.nextElement());
                }
            }
            this.table.getSelectionModel().setSelectionInterval(this.table.getTree().getRowForPath(nextPath), this.table.getTree().getRowForPath(nextPath));
        }
    }

    public void goToPreviousDifference() {
        ComparedNode selectedNode;
        ComparedNode nextDifferingNode;
        TreePath selectedPath = this.table.getTree().getPathForRow(this.table.getSelectedRow());
        if (selectedPath == null) {
            selectedPath = new TreePath(this.compareResult.getRootNode().getPath());
        }
        if ((nextDifferingNode = this.compareResult.getPrevDifferingNode(selectedNode = (ComparedNode)selectedPath.getLastPathComponent())) == null) {
            nextDifferingNode = this.compareResult.getRootNode();
        } else {
            TreePath nextPath = new TreePath(nextDifferingNode.getPath());
            this.table.getTree().setSelectionPath(nextPath);
            Enumeration<TreePath> expandedDescendants = this.table.getTree().getExpandedDescendants(nextPath.getParentPath());
            if (expandedDescendants != null) {
                while (expandedDescendants.hasMoreElements()) {
                    this.table.getTree().expandPath(expandedDescendants.nextElement());
                }
            }
            this.table.getSelectionModel().setSelectionInterval(this.table.getTree().getRowForPath(nextPath), this.table.getTree().getRowForPath(nextPath));
        }
    }

    public void copySelectedValue(int direction) throws NoSuchFieldException {
        String question;
        TreePath selectedPath;
        ComparedNode selectedNode;
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow >= 0 && (selectedNode = (ComparedNode)(selectedPath = this.table.getTree().getPathForRow(selectedRow)).getLastPathComponent()) != null && selectedNode.getChildCount() > 0 && 0 == JOptionPane.showOptionDialog(this, question = direction == 2 ? "Soll die ausgew\u00e4hlte Struktur von links kopiert und in rechts als neuen Satz hinzugef\u00fcgt werden?" : "Soll die ausgew\u00e4hlte Struktur von rechts kopiert und in links als neuen Satz hinzugef\u00fcgt werden?", "Achtung!", 1, 3, null, null, null)) {
            if (direction == 1) {
                selectedNode.copyValue1();
            } else {
                selectedNode.copyValue2();
            }
            this.updateDifferingUI();
            Enumeration<TreePath> expandedDescendants = this.table.getTree().getExpandedDescendants(selectedPath.getParentPath());
            this.treeTableModel.nodeChanged(selectedNode);
            if (expandedDescendants != null) {
                while (expandedDescendants.hasMoreElements()) {
                    this.table.getTree().expandPath(expandedDescendants.nextElement());
                }
            }
            if (selectedNode.isRemoved() && this.table.getRowCount() <= selectedRow) {
                --selectedRow;
            }
            this.table.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
            if (direction == 1) {
                this.fireDataChangeEvent(this.compareResult.getRootNode().getSatz1(), selectedNode.getFeldDeskriptor());
            } else {
                this.fireDataChangeEvent(this.compareResult.getRootNode().getSatz2(), selectedNode.getFeldDeskriptor());
            }
        }
    }

    private Component createToolBarButton(Action action) {
        JButton button = new JButton(action);
        button.setDisabledIcon((Icon)action.getValue("disabledIcon"));
        return button;
    }

    public void addPopupMenu(boolean valueToLeftProtected, boolean valueToRightProtected) {
        this.jPopupMenu = new JPopupMenu();
        JMenuItem valueToLeft = new JMenuItem(this.getValueToLeftAction());
        valueToLeft.setText("Werte in die linke Spalte \u00fcbernehmen");
        JMenuItem valueToRight = new JMenuItem(this.getValueToRightAction());
        valueToRight.setText("Werte in die rechte Spalte \u00fcbernehmen");
        JMenuItem copyToRight = new JMenuItem(this.getCopyToRightAction());
        copyToRight.setText((String)this.getCopyToRightAction().getValue("ShortDescription"));
        JMenuItem copyToLeft = new JMenuItem(this.getCopyToLeftAction());
        copyToLeft.setText((String)this.getCopyToLeftAction().getValue("ShortDescription"));
        JMenuItem toNextDifference = new JMenuItem(this.getToNextDifferenceAction());
        toNextDifference.setText("Zum n\u00e4chsten Unterschied springen");
        JMenuItem toPreviousDifference = new JMenuItem(this.getToPrevDifferenceAction());
        toPreviousDifference.setText("Zum vorherigen Unterschied springen");
        if (this.compareResult.getDifferingCount(this.compareResult.getRootNode()) > 0) {
            this.jPopupMenu.add(toNextDifference);
            this.jPopupMenu.add(toPreviousDifference);
        }
        if (!valueToLeftProtected) {
            this.jPopupMenu.add(valueToLeft);
            this.jPopupMenu.add(copyToLeft);
        }
        if (!valueToRightProtected) {
            this.jPopupMenu.add(valueToRight);
            this.jPopupMenu.add(copyToRight);
        }
        MouseAdapter mousListener = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() && CompareEditor.this.table.getSelectedRow() >= 0) {
                    CompareEditor.this.jPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.table.addMouseListener(mousListener);
    }

    public void addDataChangeListener(DataChangeListener listener) {
        this.listenerList.add(listener);
    }

    public void fireDataChangeEvent(SatzInterface changedDataSet, String valueOld, String valueNew, FeldDeskriptorImpl feldDescriptor) {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            DataChangeListener listener = (DataChangeListener)this.listenerList.get(i);
            listener.dataChangedEvent(new DataChangeEvent(changedDataSet, valueOld, valueNew, feldDescriptor));
        }
    }

    public void fireDataChangeEvent(SatzInterface changedDataSet, FeldDeskriptorImpl feldDescriptor) {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            DataChangeListener listener = (DataChangeListener)this.listenerList.get(i);
            listener.dataChangedEvent(new DataChangeEvent(changedDataSet, feldDescriptor));
        }
    }

    public void setCompareResult(CompareResult compareResult) {
        this.table.clearSelection();
        List paths = this.getExpandedNodesAsStrings();
        this.compareResult = compareResult;
        this.treeTableModel.root = this.compareResult.getRootNode();
        this.treeTableModel.nodeChanged((ComparedNode)this.treeTableModel.getRoot());
        this.setExpandedNodesAsStrings(paths);
    }

    private List getExpandedNodesAsStrings() {
        ArrayList<String> list = new ArrayList<String>();
        TreePath rootTreePath = new TreePath(this.compareResult.getRootNode());
        Enumeration<TreePath> expandedDescendants = this.table.getTree().getExpandedDescendants(rootTreePath);
        if (expandedDescendants != null) {
            while (expandedDescendants.hasMoreElements()) {
                TreePath treePath = expandedDescendants.nextElement();
                String string = this.getTreePathAsString(treePath);
                if (string == null) continue;
                list.add(string);
            }
        }
        return list;
    }

    private void setExpandedNodesAsStrings(List list) {
        ArrayList allPaths = new ArrayList();
        this.getAllPaths(this.compareResult.getRootNode(), allPaths);
        for (int i = 0; i < allPaths.size(); ++i) {
            TreePath tmp = (TreePath)allPaths.get(i);
            String str = this.getTreePathAsString(tmp);
            if (str == null || !list.contains(str)) continue;
            this.table.getTree().expandPath(tmp);
        }
    }

    private String getTreePathAsString(TreePath treePath) {
        ComparedNode comparedNode = (ComparedNode)treePath.getLastPathComponent();
        String result = comparedNode != null && comparedNode.getFeldDeskriptor() != null ? comparedNode.getFeldDeskriptor().hierarchyAsString() : null;
        return result;
    }

    private void getAllPaths(ComparedNode parent, List allPaths) {
        ComparedNode child = null;
        if (parent.getChildCount() > 0) {
            int childcount = parent.getChildCount();
            for (int i = 0; i < childcount; ++i) {
                child = parent.getChild(i);
                allPaths.add(new TreePath(parent.getChild(i).getPath()));
                this.getAllPaths(child, allPaths);
            }
        }
    }

    private class CopyToLeftAction
    extends AbstractAction {
        private static final long serialVersionUID = 3223816708389324405L;

        public CopyToLeftAction() {
            this.putValue("ShortDescription", "Werte in die linke Spalte kopieren");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/de/statspez/pleditor/generator/compare/ui/images/add_l.gif")));
            this.putValue("disabledIcon", new ImageIcon(this.getClass().getResource("/de/statspez/pleditor/generator/compare/ui/images/add_l_d.gif")));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                CompareEditor.this.copySelectedValue(1);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    private class CopyToRightAction
    extends AbstractAction {
        public CopyToRightAction() {
            this.putValue("ShortDescription", "Werte in die rechte Spalte kopieren");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/de/statspez/pleditor/generator/compare/ui/images/add_r.gif")));
            this.putValue("disabledIcon", new ImageIcon(this.getClass().getResource("/de/statspez/pleditor/generator/compare/ui/images/add_r_d.gif")));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                CompareEditor.this.copySelectedValue(2);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    private class ToPrevDifferenceAction
    extends AbstractAction {
        private Icon icon = new ImageIcon(CompareEditor.class.getResource("/de/statspez/pleditor/generator/compare/ui/images/prev_nav.gif"));
        private static final long serialVersionUID = 1L;

        public ToPrevDifferenceAction() {
            this.putValue("SmallIcon", this.icon);
            this.putValue("ShortDescription", "Zum vorherigen Unterschied springen");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CompareEditor.this.goToDifference(false);
        }
    }

    private class ToNextDifferenceAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ToNextDifferenceAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/de/statspez/pleditor/generator/compare/ui/images/next_nav.gif")));
            this.putValue("ShortDescription", "Zum n\u00e4chsten Unterschied springen");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CompareEditor.this.goToDifference(true);
        }
    }

    private class ValueToLeftAction
    extends AbstractAction {
        private static final long serialVersionUID = 3223816708389324405L;

        public ValueToLeftAction() {
            this.putValue("ShortDescription", "Werte in die linke Spalte \u00fcbernehmen");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/de/statspez/pleditor/generator/compare/ui/images/copy_l.gif")));
            this.putValue("disabledIcon", new ImageIcon(this.getClass().getResource("/de/statspez/pleditor/generator/compare/ui/images/copy_l_d.gif")));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CompareEditor.this.transferSelectedValue(1);
        }
    }

    private class ValueToRightAction
    extends AbstractAction {
        private static final long serialVersionUID = -633388733562553678L;

        public ValueToRightAction() {
            this.putValue("ShortDescription", "Werte in die rechte Spalte \u00fcbernehmen");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/de/statspez/pleditor/generator/compare/ui/images/copy_r.gif")));
            this.putValue("disabledIcon", new ImageIcon(this.getClass().getResource("/de/statspez/pleditor/generator/compare/ui/images/copy_r_d.gif")));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CompareEditor.this.transferSelectedValue(2);
        }
    }
}

