/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

public class EdtNormalizer {
    private boolean ignoreObjectId = false;
    private boolean ignoreObjectPackage = false;
    private boolean ignoreAuthor = false;
    private boolean ignoreState = false;

    public boolean isIgnoreObjectId() {
        return this.ignoreObjectId;
    }

    public void setIgnoreObjectId(boolean ignoreObjectId) {
        this.ignoreObjectId = ignoreObjectId;
    }

    public boolean isIgnoreObjectPackage() {
        return this.ignoreObjectPackage;
    }

    public void setIgnoreObjectPackage(boolean ignoreObjectPackage) {
        this.ignoreObjectPackage = ignoreObjectPackage;
    }

    public boolean isIgnoreAuthor() {
        return this.ignoreAuthor;
    }

    public void setIgnoreAuthor(boolean ignoreAuthor) {
        this.ignoreAuthor = ignoreAuthor;
    }

    public boolean isIgnoreState() {
        return this.ignoreState;
    }

    public void setIgnoreState(boolean ignoreState) {
        this.ignoreState = ignoreState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void normalize(File inFile, File outFile) throws IOException {
        FileReader in = null;
        OutputStreamWriter out = null;
        try {
            in = new FileReader(inFile);
            out = new FileWriter(outFile);
            this.normalize(in, out);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable throwable) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void normalize(Reader in, Writer out) throws IOException {
        BufferedReader reader = new BufferedReader(in);
        PrintWriter writer = new PrintWriter(out);
        String line = null;
        while ((line = reader.readLine()) != null) {
            line = line.replaceAll("<ssp:year>\\d*</ssp:year>", "<ssp:year>0000</ssp:year>");
            line = line.replaceAll("<ssp:month>\\d*</ssp:month>", "<ssp:month>00</ssp:month>");
            line = line.replaceAll("<ssp:day>\\d*</ssp:day>", "<ssp:day>00</ssp:day>");
            line = line.replaceAll("<ssp:hours>\\d*</ssp:hours>", "<ssp:hours>00</ssp:hours>");
            line = line.replaceAll("<ssp:minutes>\\d*</ssp:minutes>", "<ssp:minutes>00</ssp:minutes>");
            line = line.replaceAll("<ssp:seconds>\\d*</ssp:seconds>", "<ssp:seconds>00</ssp:seconds>");
            if (this.isIgnoreObjectId()) {
                line = line.replaceAll("id=\"[^\"]*\"", "id=\"0\"");
                line = line.replaceAll("<ssp:objectID class=\"\">(\\D*):\\d*</ssp:objectID>", "<ssp:objectID class=\"\">$1:0</ssp:objectID>");
            }
            if (this.isIgnoreObjectPackage()) {
                line = line.replaceAll("<ssp:objectPackage>[^<]*</ssp:objectPackage>", "<ssp:objectPackage></ssp:objectPackage>");
            }
            if (this.isIgnoreAuthor()) {
                line = line.replaceAll("<ssp:fullName>[^<]*</ssp:fullName>", "<ssp:fullName></ssp:fullName>");
            }
            if (this.isIgnoreState()) {
                line = line.replaceAll("state=\"[^\"]*\"", "state=\"comparing\"");
            }
            writer.println(line);
        }
    }

    public static void main(String[] args) {
        int exitCode;
        block15: {
            exitCode = 0;
            File fileOrDir = null;
            Boolean noId = null;
            Boolean noPackage = null;
            Boolean noAuthor = null;
            Boolean noState = null;
            if (args.length > 0) {
                fileOrDir = new File(args[0]);
                for (int i = 1; i < args.length; ++i) {
                    if (args[i].equalsIgnoreCase("-noid")) {
                        noId = Boolean.TRUE;
                        continue;
                    }
                    if (args[i].equalsIgnoreCase("-nopackage")) {
                        noPackage = Boolean.TRUE;
                        continue;
                    }
                    if (args[i].equalsIgnoreCase("-noauthor")) {
                        noAuthor = Boolean.TRUE;
                        continue;
                    }
                    if (!args[i].equalsIgnoreCase("-nostate")) continue;
                    noState = Boolean.TRUE;
                }
            }
            if (fileOrDir != null) {
                System.out.println(fileOrDir);
                EdtNormalizer edtNormalizer = new EdtNormalizer();
                if (noId != null) {
                    edtNormalizer.setIgnoreObjectId(noId);
                }
                if (noPackage != null) {
                    edtNormalizer.setIgnoreObjectPackage(noPackage);
                }
                if (noAuthor != null) {
                    edtNormalizer.setIgnoreAuthor(noAuthor);
                }
                if (noState != null) {
                    edtNormalizer.setIgnoreState(noState);
                }
                try {
                    if (fileOrDir.isDirectory()) {
                        File[] files = fileOrDir.listFiles(new FileFilter(){

                            @Override
                            public boolean accept(File file) {
                                return file.getName().toLowerCase().endsWith(".xml");
                            }
                        });
                        for (int i = 0; i < files.length; ++i) {
                            System.out.println(files[i].getName());
                            edtNormalizer.normalize(files[i], new File(files[i].getAbsolutePath() + ".norm"));
                        }
                        break block15;
                    }
                    edtNormalizer.normalize(fileOrDir, new File(fileOrDir.getName() + ".norm"));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    exitCode = -2;
                }
            } else {
                System.err.println("Aufruf: EdtNormalizer <file|dir> [-noid] [-nopackage]");
                exitCode = -1;
            }
        }
        System.exit(exitCode);
    }
}

